/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the method that featurizes (transforms) a dataset field. The method is part of the
 * <code>FeaturizationPipeline</code> of the <a>Featurization</a> object.
 * </p>
 * <p>
 * The following is an example of how you specify a <code>FeaturizationMethod</code> object.
 * </p>
 * <p>
 * <code>{</code>
 * </p>
 * <p>
 * <code>"FeaturizationMethodName": "filling",</code>
 * </p>
 * <p>
 * <code>"FeaturizationMethodParameters": {"aggregation": "sum", "middlefill": "zero", "backfill": "zero"}</code>
 * </p>
 * <p>
 * <code>}</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeaturizationMethod implements SdkPojo, Serializable,
        ToCopyableBuilder<FeaturizationMethod.Builder, FeaturizationMethod> {
    private static final SdkField<String> FEATURIZATION_METHOD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeaturizationMethodName").getter(getter(FeaturizationMethod::featurizationMethodNameAsString))
            .setter(setter(Builder::featurizationMethodName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationMethodName").build())
            .build();

    private static final SdkField<Map<String, String>> FEATURIZATION_METHOD_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("FeaturizationMethodParameters")
            .getter(getter(FeaturizationMethod::featurizationMethodParameters))
            .setter(setter(Builder::featurizationMethodParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationMethodParameters")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FEATURIZATION_METHOD_NAME_FIELD, FEATURIZATION_METHOD_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String featurizationMethodName;

    private final Map<String, String> featurizationMethodParameters;

    private FeaturizationMethod(BuilderImpl builder) {
        this.featurizationMethodName = builder.featurizationMethodName;
        this.featurizationMethodParameters = builder.featurizationMethodParameters;
    }

    /**
     * <p>
     * The name of the method. The "filling" method is the only supported method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #featurizationMethodName} will return {@link FeaturizationMethodName#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #featurizationMethodNameAsString}.
     * </p>
     * 
     * @return The name of the method. The "filling" method is the only supported method.
     * @see FeaturizationMethodName
     */
    public final FeaturizationMethodName featurizationMethodName() {
        return FeaturizationMethodName.fromValue(featurizationMethodName);
    }

    /**
     * <p>
     * The name of the method. The "filling" method is the only supported method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #featurizationMethodName} will return {@link FeaturizationMethodName#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #featurizationMethodNameAsString}.
     * </p>
     * 
     * @return The name of the method. The "filling" method is the only supported method.
     * @see FeaturizationMethodName
     */
    public final String featurizationMethodNameAsString() {
        return featurizationMethodName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeaturizationMethodParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFeaturizationMethodParameters() {
        return featurizationMethodParameters != null && !(featurizationMethodParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to
     * override the default values. Related Time Series attributes do not accept aggregation parameters.
     * </p>
     * <p>
     * The following list shows the parameters and their valid values for the "filling" featurization method for a
     * <b>Target Time Series</b> dataset. Bold signifies the default value.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>frontfill</code>: <b>none</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>,
     * <code>mean</code>, <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization
     * method (there are no defaults):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in
     * a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the
     * following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeaturizationMethodParameters} method.
     * </p>
     * 
     * @return The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters
     *         to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
     *         <p>
     *         The following list shows the parameters and their valid values for the "filling" featurization method for
     *         a <b>Target Time Series</b> dataset. Bold signifies the default value.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>,
     *         <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>frontfill</code>: <b>none</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>,
     *         <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>,
     *         <code>mean</code>, <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following list shows the parameters and their valid values for a <b>Related Time Series</b>
     *         featurization method (there are no defaults):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the
     *         value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2,
     *         include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
     */
    public final Map<String, String> featurizationMethodParameters() {
        return featurizationMethodParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featurizationMethodNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeaturizationMethodParameters() ? featurizationMethodParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeaturizationMethod)) {
            return false;
        }
        FeaturizationMethod other = (FeaturizationMethod) obj;
        return Objects.equals(featurizationMethodNameAsString(), other.featurizationMethodNameAsString())
                && hasFeaturizationMethodParameters() == other.hasFeaturizationMethodParameters()
                && Objects.equals(featurizationMethodParameters(), other.featurizationMethodParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("FeaturizationMethod")
                .add("FeaturizationMethodName", featurizationMethodNameAsString())
                .add("FeaturizationMethodParameters", hasFeaturizationMethodParameters() ? featurizationMethodParameters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeaturizationMethodName":
            return Optional.ofNullable(clazz.cast(featurizationMethodNameAsString()));
        case "FeaturizationMethodParameters":
            return Optional.ofNullable(clazz.cast(featurizationMethodParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeaturizationMethod, T> g) {
        return obj -> g.apply((FeaturizationMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeaturizationMethod> {
        /**
         * <p>
         * The name of the method. The "filling" method is the only supported method.
         * </p>
         * 
         * @param featurizationMethodName
         *        The name of the method. The "filling" method is the only supported method.
         * @see FeaturizationMethodName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeaturizationMethodName
         */
        Builder featurizationMethodName(String featurizationMethodName);

        /**
         * <p>
         * The name of the method. The "filling" method is the only supported method.
         * </p>
         * 
         * @param featurizationMethodName
         *        The name of the method. The "filling" method is the only supported method.
         * @see FeaturizationMethodName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeaturizationMethodName
         */
        Builder featurizationMethodName(FeaturizationMethodName featurizationMethodName);

        /**
         * <p>
         * The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to
         * override the default values. Related Time Series attributes do not accept aggregation parameters.
         * </p>
         * <p>
         * The following list shows the parameters and their valid values for the "filling" featurization method for a
         * <b>Target Time Series</b> dataset. Bold signifies the default value.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>,
         * <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>frontfill</code>: <b>none</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>,
         * <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>,
         * <code>mean</code>, <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization
         * method (there are no defaults):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the
         * value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2,
         * include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
         * </p>
         * 
         * @param featurizationMethodParameters
         *        The method parameters (key-value pairs), which are a map of override parameters. Specify these
         *        parameters to override the default values. Related Time Series attributes do not accept aggregation
         *        parameters.</p>
         *        <p>
         *        The following list shows the parameters and their valid values for the "filling" featurization method
         *        for a <b>Target Time Series</b> dataset. Bold signifies the default value.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>,
         *        <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>frontfill</code>: <b>none</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>,
         *        <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>,
         *        <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following list shows the parameters and their valid values for a <b>Related Time Series</b>
         *        featurization method (there are no defaults):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         *        <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To set a filling method to a specific value, set the fill parameter to <code>value</code> and define
         *        the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value
         *        of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featurizationMethodParameters(Map<String, String> featurizationMethodParameters);
    }

    static final class BuilderImpl implements Builder {
        private String featurizationMethodName;

        private Map<String, String> featurizationMethodParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturizationMethod model) {
            featurizationMethodName(model.featurizationMethodName);
            featurizationMethodParameters(model.featurizationMethodParameters);
        }

        public final String getFeaturizationMethodName() {
            return featurizationMethodName;
        }

        public final void setFeaturizationMethodName(String featurizationMethodName) {
            this.featurizationMethodName = featurizationMethodName;
        }

        @Override
        @Transient
        public final Builder featurizationMethodName(String featurizationMethodName) {
            this.featurizationMethodName = featurizationMethodName;
            return this;
        }

        @Override
        @Transient
        public final Builder featurizationMethodName(FeaturizationMethodName featurizationMethodName) {
            this.featurizationMethodName(featurizationMethodName == null ? null : featurizationMethodName.toString());
            return this;
        }

        public final Map<String, String> getFeaturizationMethodParameters() {
            if (featurizationMethodParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return featurizationMethodParameters;
        }

        public final void setFeaturizationMethodParameters(Map<String, String> featurizationMethodParameters) {
            this.featurizationMethodParameters = FeaturizationMethodParametersCopier.copy(featurizationMethodParameters);
        }

        @Override
        @Transient
        public final Builder featurizationMethodParameters(Map<String, String> featurizationMethodParameters) {
            this.featurizationMethodParameters = FeaturizationMethodParametersCopier.copy(featurizationMethodParameters);
            return this;
        }

        @Override
        public FeaturizationMethod build() {
            return new FeaturizationMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
