/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.TestWindowsCopier;
import software.amazon.awssdk.services.forecast.model.WindowSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationResult> {
    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmArn").getter(EvaluationResult.getter(EvaluationResult::algorithmArn)).setter(EvaluationResult.setter(Builder::algorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()}).build();
    private static final SdkField<List<WindowSummary>> TEST_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TestWindows").getter(EvaluationResult.getter(EvaluationResult::testWindows)).setter(EvaluationResult.setter(Builder::testWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WindowSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_ARN_FIELD, TEST_WINDOWS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithmArn;
    private final List<WindowSummary> testWindows;

    private EvaluationResult(BuilderImpl builder) {
        this.algorithmArn = builder.algorithmArn;
        this.testWindows = builder.testWindows;
    }

    public final String algorithmArn() {
        return this.algorithmArn;
    }

    public final boolean hasTestWindows() {
        return this.testWindows != null && !(this.testWindows instanceof SdkAutoConstructList);
    }

    public final List<WindowSummary> testWindows() {
        return this.testWindows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestWindows() ? this.testWindows() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        return Objects.equals(this.algorithmArn(), other.algorithmArn()) && this.hasTestWindows() == other.hasTestWindows() && Objects.equals(this.testWindows(), other.testWindows());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationResult").add("AlgorithmArn", (Object)this.algorithmArn()).add("TestWindows", this.hasTestWindows() ? this.testWindows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmArn": {
                return Optional.ofNullable(clazz.cast(this.algorithmArn()));
            }
            case "TestWindows": {
                return Optional.ofNullable(clazz.cast(this.testWindows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResult, T> g) {
        return obj -> g.apply((EvaluationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithmArn;
        private List<WindowSummary> testWindows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            this.algorithmArn(model.algorithmArn);
            this.testWindows(model.testWindows);
        }

        public final String getAlgorithmArn() {
            return this.algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final List<WindowSummary.Builder> getTestWindows() {
            List<WindowSummary.Builder> result = TestWindowsCopier.copyToBuilder(this.testWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestWindows(Collection<WindowSummary.BuilderImpl> testWindows) {
            this.testWindows = TestWindowsCopier.copyFromBuilder(testWindows);
        }

        @Override
        public final Builder testWindows(Collection<WindowSummary> testWindows) {
            this.testWindows = TestWindowsCopier.copy(testWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testWindows(WindowSummary ... testWindows) {
            this.testWindows(Arrays.asList(testWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testWindows(Consumer<WindowSummary.Builder> ... testWindows) {
            this.testWindows(Stream.of(testWindows).map(c -> (WindowSummary)((WindowSummary.Builder)WindowSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluationResult build() {
            return new EvaluationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationResult> {
        public Builder algorithmArn(String var1);

        public Builder testWindows(Collection<WindowSummary> var1);

        public Builder testWindows(WindowSummary ... var1);

        public Builder testWindows(Consumer<WindowSummary.Builder> ... var1);
    }
}

