/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.DatasetType;
import software.amazon.awssdk.services.forecast.model.Domain;
import software.amazon.awssdk.services.forecast.model.EncryptionConfig;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.Schema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatasetResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeDatasetResponse> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetArn)).setter(DescribeDatasetResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetName)).setter(DescribeDatasetResponse.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::domainAsString)).setter(DescribeDatasetResponse.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetType").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetTypeAsString)).setter(DescribeDatasetResponse.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()}).build();
    private static final SdkField<String> DATA_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFrequency").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::dataFrequency)).setter(DescribeDatasetResponse.setter(Builder::dataFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFrequency").build()}).build();
    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schema").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::schema)).setter(DescribeDatasetResponse.setter(Builder::schema)).constructor(Schema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfig").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::encryptionConfig)).setter(DescribeDatasetResponse.setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::status)).setter(DescribeDatasetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::creationTime)).setter(DescribeDatasetResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::lastModificationTime)).setter(DescribeDatasetResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD, DATASET_NAME_FIELD, DOMAIN_FIELD, DATASET_TYPE_FIELD, DATA_FREQUENCY_FIELD, SCHEMA_FIELD, ENCRYPTION_CONFIG_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private final String datasetArn;
    private final String datasetName;
    private final String domain;
    private final String datasetType;
    private final String dataFrequency;
    private final Schema schema;
    private final EncryptionConfig encryptionConfig;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.domain = builder.domain;
        this.datasetType = builder.datasetType;
        this.dataFrequency = builder.dataFrequency;
        this.schema = builder.schema;
        this.encryptionConfig = builder.encryptionConfig;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final Domain domain() {
        return Domain.fromValue(this.domain);
    }

    public final String domainAsString() {
        return this.domain;
    }

    public final DatasetType datasetType() {
        return DatasetType.fromValue(this.datasetType);
    }

    public final String datasetTypeAsString() {
        return this.datasetType;
    }

    public final String dataFrequency() {
        return this.dataFrequency;
    }

    public final Schema schema() {
        return this.schema;
    }

    public final EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse)((Object)obj);
        return Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.datasetTypeAsString(), other.datasetTypeAsString()) && Objects.equals(this.dataFrequency(), other.dataFrequency()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.encryptionConfig(), other.encryptionConfig()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDatasetResponse").add("DatasetArn", (Object)this.datasetArn()).add("DatasetName", (Object)this.datasetName()).add("Domain", (Object)this.domainAsString()).add("DatasetType", (Object)this.datasetTypeAsString()).add("DataFrequency", (Object)this.dataFrequency()).add("Schema", (Object)this.schema()).add("EncryptionConfig", (Object)this.encryptionConfig()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetTypeAsString()));
            }
            case "DataFrequency": {
                return Optional.ofNullable(clazz.cast(this.dataFrequency()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "EncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String datasetArn;
        private String datasetName;
        private String domain;
        private String datasetType;
        private String dataFrequency;
        private Schema schema;
        private EncryptionConfig encryptionConfig;
        private String status;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            this.datasetArn(model.datasetArn);
            this.datasetName(model.datasetName);
            this.domain(model.domain);
            this.datasetType(model.datasetType);
            this.dataFrequency(model.dataFrequency);
            this.schema(model.schema);
            this.encryptionConfig(model.encryptionConfig);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        @Transient
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        @Transient
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        @Transient
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        @Transient
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        @Transient
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final String getDataFrequency() {
            return this.dataFrequency;
        }

        public final void setDataFrequency(String dataFrequency) {
            this.dataFrequency = dataFrequency;
        }

        @Override
        @Transient
        public final Builder dataFrequency(String dataFrequency) {
            this.dataFrequency = dataFrequency;
            return this;
        }

        public final Schema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        @Transient
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return this.encryptionConfig != null ? this.encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        @Transient
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatasetResponse> {
        public Builder datasetArn(String var1);

        public Builder datasetName(String var1);

        public Builder domain(String var1);

        public Builder domain(Domain var1);

        public Builder datasetType(String var1);

        public Builder datasetType(DatasetType var1);

        public Builder dataFrequency(String var1);

        public Builder schema(Schema var1);

        default public Builder schema(Consumer<Schema.Builder> schema) {
            return this.schema((Schema)((Schema.Builder)Schema.builder().applyMutation(schema)).build());
        }

        public Builder encryptionConfig(EncryptionConfig var1);

        default public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return this.encryptionConfig((EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation(encryptionConfig)).build());
        }

        public Builder status(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

