/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMonitorsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListMonitorsResponse.Builder, ListMonitorsResponse> {
    private static final SdkField<List<MonitorSummary>> MONITORS_FIELD = SdkField
            .<List<MonitorSummary>> builder(MarshallingType.LIST)
            .memberName("Monitors")
            .getter(getter(ListMonitorsResponse::monitors))
            .setter(setter(Builder::monitors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMonitorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MonitorSummary> monitors;

    private final String nextToken;

    private ListMonitorsResponse(BuilderImpl builder) {
        super(builder);
        this.monitors = builder.monitors;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Monitors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMonitors() {
        return monitors != null && !(monitors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize each monitor's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitors} method.
     * </p>
     * 
     * @return An array of objects that summarize each monitor's properties.
     */
    public final List<MonitorSummary> monitors() {
        return monitors;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the
     * token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
     *         use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitors() ? monitors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitorsResponse)) {
            return false;
        }
        ListMonitorsResponse other = (ListMonitorsResponse) obj;
        return hasMonitors() == other.hasMonitors() && Objects.equals(monitors(), other.monitors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMonitorsResponse").add("Monitors", hasMonitors() ? monitors() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Monitors":
            return Optional.ofNullable(clazz.cast(monitors()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitorsResponse, T> g) {
        return obj -> g.apply((ListMonitorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMonitorsResponse> {
        /**
         * <p>
         * An array of objects that summarize each monitor's properties.
         * </p>
         * 
         * @param monitors
         *        An array of objects that summarize each monitor's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitors(Collection<MonitorSummary> monitors);

        /**
         * <p>
         * An array of objects that summarize each monitor's properties.
         * </p>
         * 
         * @param monitors
         *        An array of objects that summarize each monitor's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitors(MonitorSummary... monitors);

        /**
         * <p>
         * An array of objects that summarize each monitor's properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MonitorSummary>.Builder} avoiding
         * the need to create one manually via {@link List<MonitorSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MonitorSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #monitors(List<MonitorSummary>)}.
         * 
         * @param monitors
         *        a consumer that will call methods on {@link List<MonitorSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitors(List<MonitorSummary>)
         */
        Builder monitors(Consumer<MonitorSummary.Builder>... monitors);

        /**
         * <p>
         * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<MonitorSummary> monitors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitorsResponse model) {
            super(model);
            monitors(model.monitors);
            nextToken(model.nextToken);
        }

        public final List<MonitorSummary.Builder> getMonitors() {
            List<MonitorSummary.Builder> result = MonitorsCopier.copyToBuilder(this.monitors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitors(Collection<MonitorSummary.BuilderImpl> monitors) {
            this.monitors = MonitorsCopier.copyFromBuilder(monitors);
        }

        @Override
        public final Builder monitors(Collection<MonitorSummary> monitors) {
            this.monitors = MonitorsCopier.copy(monitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(MonitorSummary... monitors) {
            monitors(Arrays.asList(monitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Consumer<MonitorSummary.Builder>... monitors) {
            monitors(Stream.of(monitors).map(c -> MonitorSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMonitorsResponse build() {
            return new ListMonitorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
