/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metrics you can use as a baseline for comparison purposes. Use these metrics when you interpret monitoring results
 * for an auto predictor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Baseline implements SdkPojo, Serializable, ToCopyableBuilder<Baseline.Builder, Baseline> {
    private static final SdkField<PredictorBaseline> PREDICTOR_BASELINE_FIELD = SdkField
            .<PredictorBaseline> builder(MarshallingType.SDK_POJO).memberName("PredictorBaseline")
            .getter(getter(Baseline::predictorBaseline)).setter(setter(Builder::predictorBaseline))
            .constructor(PredictorBaseline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorBaseline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_BASELINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PredictorBaseline predictorBaseline;

    private Baseline(BuilderImpl builder) {
        this.predictorBaseline = builder.predictorBaseline;
    }

    /**
     * <p>
     * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for the
     * predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your predictor
     * and the metrics change.
     * </p>
     * 
     * @return The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a>
     *         for the predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use
     *         your predictor and the metrics change.
     */
    public final PredictorBaseline predictorBaseline() {
        return predictorBaseline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predictorBaseline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Baseline)) {
            return false;
        }
        Baseline other = (Baseline) obj;
        return Objects.equals(predictorBaseline(), other.predictorBaseline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Baseline").add("PredictorBaseline", predictorBaseline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorBaseline":
            return Optional.ofNullable(clazz.cast(predictorBaseline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Baseline, T> g) {
        return obj -> g.apply((Baseline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Baseline> {
        /**
         * <p>
         * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for
         * the predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your
         * predictor and the metrics change.
         * </p>
         * 
         * @param predictorBaseline
         *        The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a>
         *        for the predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you
         *        use your predictor and the metrics change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorBaseline(PredictorBaseline predictorBaseline);

        /**
         * <p>
         * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for
         * the predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your
         * predictor and the metrics change.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictorBaseline.Builder} avoiding the
         * need to create one manually via {@link PredictorBaseline#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredictorBaseline.Builder#build()} is called immediately and its
         * result is passed to {@link #predictorBaseline(PredictorBaseline)}.
         * 
         * @param predictorBaseline
         *        a consumer that will call methods on {@link PredictorBaseline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictorBaseline(PredictorBaseline)
         */
        default Builder predictorBaseline(Consumer<PredictorBaseline.Builder> predictorBaseline) {
            return predictorBaseline(PredictorBaseline.builder().applyMutation(predictorBaseline).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PredictorBaseline predictorBaseline;

        private BuilderImpl() {
        }

        private BuilderImpl(Baseline model) {
            predictorBaseline(model.predictorBaseline);
        }

        public final PredictorBaseline.Builder getPredictorBaseline() {
            return predictorBaseline != null ? predictorBaseline.toBuilder() : null;
        }

        public final void setPredictorBaseline(PredictorBaseline.BuilderImpl predictorBaseline) {
            this.predictorBaseline = predictorBaseline != null ? predictorBaseline.build() : null;
        }

        @Override
        public final Builder predictorBaseline(PredictorBaseline predictorBaseline) {
            this.predictorBaseline = predictorBaseline;
            return this;
        }

        @Override
        public Baseline build() {
            return new Baseline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
