/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListForecastsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListForecastsResponse.Builder, ListForecastsResponse> {
    private static final SdkField<List<ForecastSummary>> FORECASTS_FIELD = SdkField
            .<List<ForecastSummary>> builder(MarshallingType.LIST)
            .memberName("Forecasts")
            .getter(getter(ListForecastsResponse::forecasts))
            .setter(setter(Builder::forecasts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Forecasts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ForecastSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ForecastSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListForecastsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECASTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ForecastSummary> forecasts;

    private final String nextToken;

    private ListForecastsResponse(BuilderImpl builder) {
        super(builder);
        this.forecasts = builder.forecasts;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Forecasts property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasForecasts() {
        return forecasts != null && !(forecasts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize each forecast's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasForecasts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that summarize each forecast's properties.
     */
    public final List<ForecastSummary> forecasts() {
        return forecasts;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the
     * token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
     *         use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasForecasts() ? forecasts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListForecastsResponse)) {
            return false;
        }
        ListForecastsResponse other = (ListForecastsResponse) obj;
        return hasForecasts() == other.hasForecasts() && Objects.equals(forecasts(), other.forecasts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListForecastsResponse").add("Forecasts", hasForecasts() ? forecasts() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Forecasts":
            return Optional.ofNullable(clazz.cast(forecasts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListForecastsResponse, T> g) {
        return obj -> g.apply((ListForecastsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListForecastsResponse> {
        /**
         * <p>
         * An array of objects that summarize each forecast's properties.
         * </p>
         * 
         * @param forecasts
         *        An array of objects that summarize each forecast's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecasts(Collection<ForecastSummary> forecasts);

        /**
         * <p>
         * An array of objects that summarize each forecast's properties.
         * </p>
         * 
         * @param forecasts
         *        An array of objects that summarize each forecast's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecasts(ForecastSummary... forecasts);

        /**
         * <p>
         * An array of objects that summarize each forecast's properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ForecastSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ForecastSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ForecastSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #forecasts(List<ForecastSummary>)}.
         * 
         * @param forecasts
         *        a consumer that will call methods on {@link List<ForecastSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecasts(List<ForecastSummary>)
         */
        Builder forecasts(Consumer<ForecastSummary.Builder>... forecasts);

        /**
         * <p>
         * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<ForecastSummary> forecasts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListForecastsResponse model) {
            super(model);
            forecasts(model.forecasts);
            nextToken(model.nextToken);
        }

        public final List<ForecastSummary.Builder> getForecasts() {
            List<ForecastSummary.Builder> result = ForecastsCopier.copyToBuilder(this.forecasts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForecasts(Collection<ForecastSummary.BuilderImpl> forecasts) {
            this.forecasts = ForecastsCopier.copyFromBuilder(forecasts);
        }

        @Override
        @Transient
        public final Builder forecasts(Collection<ForecastSummary> forecasts) {
            this.forecasts = ForecastsCopier.copy(forecasts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forecasts(ForecastSummary... forecasts) {
            forecasts(Arrays.asList(forecasts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forecasts(Consumer<ForecastSummary.Builder>... forecasts) {
            forecasts(Stream.of(forecasts).map(c -> ForecastSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListForecastsResponse build() {
            return new ListForecastsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
