/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data used to train a predictor. The data includes a dataset group and any supplementary features. You specify
 * this object in the <a>CreatePredictor</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDataConfig implements SdkPojo, Serializable, ToCopyableBuilder<InputDataConfig.Builder, InputDataConfig> {
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetGroupArn").getter(getter(InputDataConfig::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()).build();

    private static final SdkField<List<SupplementaryFeature>> SUPPLEMENTARY_FEATURES_FIELD = SdkField
            .<List<SupplementaryFeature>> builder(MarshallingType.LIST)
            .memberName("SupplementaryFeatures")
            .getter(getter(InputDataConfig::supplementaryFeatures))
            .setter(setter(Builder::supplementaryFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementaryFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupplementaryFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupplementaryFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_ARN_FIELD,
            SUPPLEMENTARY_FEATURES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetGroupArn;

    private final List<SupplementaryFeature> supplementaryFeatures;

    private InputDataConfig(BuilderImpl builder) {
        this.datasetGroupArn = builder.datasetGroupArn;
        this.supplementaryFeatures = builder.supplementaryFeatures;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * Returns true if the SupplementaryFeatures property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupplementaryFeatures() {
        return supplementaryFeatures != null && !(supplementaryFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of supplementary features. The only supported feature is a holiday calendar.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupplementaryFeatures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of supplementary features. The only supported feature is a holiday calendar.
     */
    public final List<SupplementaryFeature> supplementaryFeatures() {
        return supplementaryFeatures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupplementaryFeatures() ? supplementaryFeatures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig) obj;
        return Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && hasSupplementaryFeatures() == other.hasSupplementaryFeatures()
                && Objects.equals(supplementaryFeatures(), other.supplementaryFeatures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDataConfig").add("DatasetGroupArn", datasetGroupArn())
                .add("SupplementaryFeatures", hasSupplementaryFeatures() ? supplementaryFeatures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "SupplementaryFeatures":
            return Optional.ofNullable(clazz.cast(supplementaryFeatures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDataConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * An array of supplementary features. The only supported feature is a holiday calendar.
         * </p>
         * 
         * @param supplementaryFeatures
         *        An array of supplementary features. The only supported feature is a holiday calendar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementaryFeatures(Collection<SupplementaryFeature> supplementaryFeatures);

        /**
         * <p>
         * An array of supplementary features. The only supported feature is a holiday calendar.
         * </p>
         * 
         * @param supplementaryFeatures
         *        An array of supplementary features. The only supported feature is a holiday calendar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementaryFeatures(SupplementaryFeature... supplementaryFeatures);

        /**
         * <p>
         * An array of supplementary features. The only supported feature is a holiday calendar.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SupplementaryFeature>.Builder} avoiding the
         * need to create one manually via {@link List<SupplementaryFeature>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SupplementaryFeature>.Builder#build()} is called immediately
         * and its result is passed to {@link #supplementaryFeatures(List<SupplementaryFeature>)}.
         * 
         * @param supplementaryFeatures
         *        a consumer that will call methods on {@link List<SupplementaryFeature>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supplementaryFeatures(List<SupplementaryFeature>)
         */
        Builder supplementaryFeatures(Consumer<SupplementaryFeature.Builder>... supplementaryFeatures);
    }

    static final class BuilderImpl implements Builder {
        private String datasetGroupArn;

        private List<SupplementaryFeature> supplementaryFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            datasetGroupArn(model.datasetGroupArn);
            supplementaryFeatures(model.supplementaryFeatures);
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        @Transient
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final List<SupplementaryFeature.Builder> getSupplementaryFeatures() {
            List<SupplementaryFeature.Builder> result = SupplementaryFeaturesCopier.copyToBuilder(this.supplementaryFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupplementaryFeatures(Collection<SupplementaryFeature.BuilderImpl> supplementaryFeatures) {
            this.supplementaryFeatures = SupplementaryFeaturesCopier.copyFromBuilder(supplementaryFeatures);
        }

        @Override
        @Transient
        public final Builder supplementaryFeatures(Collection<SupplementaryFeature> supplementaryFeatures) {
            this.supplementaryFeatures = SupplementaryFeaturesCopier.copy(supplementaryFeatures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supplementaryFeatures(SupplementaryFeature... supplementaryFeatures) {
            supplementaryFeatures(Arrays.asList(supplementaryFeatures));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supplementaryFeatures(Consumer<SupplementaryFeature.Builder>... supplementaryFeatures) {
            supplementaryFeatures(Stream.of(supplementaryFeatures)
                    .map(c -> SupplementaryFeature.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
