/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExplainabilityRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateExplainabilityRequest.Builder, CreateExplainabilityRequest> {
    private static final SdkField<String> EXPLAINABILITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityName").getter(getter(CreateExplainabilityRequest::explainabilityName))
            .setter(setter(Builder::explainabilityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityName").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(CreateExplainabilityRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<ExplainabilityConfig> EXPLAINABILITY_CONFIG_FIELD = SdkField
            .<ExplainabilityConfig> builder(MarshallingType.SDK_POJO).memberName("ExplainabilityConfig")
            .getter(getter(CreateExplainabilityRequest::explainabilityConfig)).setter(setter(Builder::explainabilityConfig))
            .constructor(ExplainabilityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityConfig").build())
            .build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(CreateExplainabilityRequest::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(CreateExplainabilityRequest::schema)).setter(setter(Builder::schema)).constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<Boolean> ENABLE_VISUALIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableVisualization").getter(getter(CreateExplainabilityRequest::enableVisualization))
            .setter(setter(Builder::enableVisualization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableVisualization").build())
            .build();

    private static final SdkField<String> START_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDateTime").getter(getter(CreateExplainabilityRequest::startDateTime))
            .setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()).build();

    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndDateTime").getter(getter(CreateExplainabilityRequest::endDateTime))
            .setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateExplainabilityRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_NAME_FIELD,
            RESOURCE_ARN_FIELD, EXPLAINABILITY_CONFIG_FIELD, DATA_SOURCE_FIELD, SCHEMA_FIELD, ENABLE_VISUALIZATION_FIELD,
            START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, TAGS_FIELD));

    private final String explainabilityName;

    private final String resourceArn;

    private final ExplainabilityConfig explainabilityConfig;

    private final DataSource dataSource;

    private final Schema schema;

    private final Boolean enableVisualization;

    private final String startDateTime;

    private final String endDateTime;

    private final List<Tag> tags;

    private CreateExplainabilityRequest(BuilderImpl builder) {
        super(builder);
        this.explainabilityName = builder.explainabilityName;
        this.resourceArn = builder.resourceArn;
        this.explainabilityConfig = builder.explainabilityConfig;
        this.dataSource = builder.dataSource;
        this.schema = builder.schema;
        this.enableVisualization = builder.enableVisualization;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name for the Explainability.
     * </p>
     * 
     * @return A unique name for the Explainability.
     */
    public final String explainabilityName() {
        return explainabilityName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The configuration settings that define the granularity of time series and time points for the Explainability.
     * </p>
     * 
     * @return The configuration settings that define the granularity of time series and time points for the
     *         Explainability.
     */
    public final ExplainabilityConfig explainabilityConfig() {
        return explainabilityConfig;
    }

    /**
     * Returns the value of the DataSource property for this object.
     * 
     * @return The value of the DataSource property for this object.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * Returns the value of the Schema property for this object.
     * 
     * @return The value of the Schema property for this object.
     */
    public final Schema schema() {
        return schema;
    }

    /**
     * <p>
     * Create an Expainability visualization that is viewable within the AWS console.
     * </p>
     * 
     * @return Create an Expainability visualization that is viewable within the AWS console.
     */
    public final Boolean enableVisualization() {
        return enableVisualization;
    }

    /**
     * <p>
     * If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, define the first point for the
     * Explainability.
     * </p>
     * <p>
     * Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
     * </p>
     * 
     * @return If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, define the first point for the
     *         Explainability.</p>
     *         <p>
     *         Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
     */
    public final String startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, define the last time point for the
     * Explainability.
     * </p>
     * <p>
     * Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
     * </p>
     * 
     * @return If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, define the last time point for the
     *         Explainability.</p>
     *         <p>
     *         Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
     */
    public final String endDateTime() {
        return endDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an optional
     * value, both of which you define. Tag keys and values are case sensitive.
     * </p>
     * <p>
     * The following restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For each resource, each tag key must be unique and each tag key must have one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum number of tags per resource: 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length: 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length: 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging
     * schema is used across other services and resources, the character restrictions of those services also apply.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>. Values
     * can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast considers
     * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
     * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with this
     * prefix.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an
     *         optional value, both of which you define. Tag keys and values are case sensitive.</p>
     *         <p>
     *         The following restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique and each tag key must have one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource: 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length: 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length: 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
     *         tagging schema is used across other services and resources, the character restrictions of those services
     *         also apply.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
     *         Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not,
     *         Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the
     *         key prefix of <code>aws</code> do not count against your tags per resource limit. You cannot edit or
     *         delete tag keys with this prefix.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(enableVisualization());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExplainabilityRequest)) {
            return false;
        }
        CreateExplainabilityRequest other = (CreateExplainabilityRequest) obj;
        return Objects.equals(explainabilityName(), other.explainabilityName())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(explainabilityConfig(), other.explainabilityConfig())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(schema(), other.schema())
                && Objects.equals(enableVisualization(), other.enableVisualization())
                && Objects.equals(startDateTime(), other.startDateTime()) && Objects.equals(endDateTime(), other.endDateTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExplainabilityRequest").add("ExplainabilityName", explainabilityName())
                .add("ResourceArn", resourceArn()).add("ExplainabilityConfig", explainabilityConfig())
                .add("DataSource", dataSource()).add("Schema", schema()).add("EnableVisualization", enableVisualization())
                .add("StartDateTime", startDateTime()).add("EndDateTime", endDateTime()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExplainabilityName":
            return Optional.ofNullable(clazz.cast(explainabilityName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ExplainabilityConfig":
            return Optional.ofNullable(clazz.cast(explainabilityConfig()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "EnableVisualization":
            return Optional.ofNullable(clazz.cast(enableVisualization()));
        case "StartDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "EndDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExplainabilityRequest, T> g) {
        return obj -> g.apply((CreateExplainabilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateExplainabilityRequest> {
        /**
         * <p>
         * A unique name for the Explainability.
         * </p>
         * 
         * @param explainabilityName
         *        A unique name for the Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityName(String explainabilityName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The configuration settings that define the granularity of time series and time points for the Explainability.
         * </p>
         * 
         * @param explainabilityConfig
         *        The configuration settings that define the granularity of time series and time points for the
         *        Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig);

        /**
         * <p>
         * The configuration settings that define the granularity of time series and time points for the Explainability.
         * </p>
         * This is a convenience that creates an instance of the {@link ExplainabilityConfig.Builder} avoiding the need
         * to create one manually via {@link ExplainabilityConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExplainabilityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #explainabilityConfig(ExplainabilityConfig)}.
         * 
         * @param explainabilityConfig
         *        a consumer that will call methods on {@link ExplainabilityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explainabilityConfig(ExplainabilityConfig)
         */
        default Builder explainabilityConfig(Consumer<ExplainabilityConfig.Builder> explainabilityConfig) {
            return explainabilityConfig(ExplainabilityConfig.builder().applyMutation(explainabilityConfig).build());
        }

        /**
         * Sets the value of the DataSource property for this object.
         *
         * @param dataSource
         *        The new value for the DataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * Sets the value of the DataSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataSource.Builder} avoiding the need to create
         * one manually via {@link DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * Sets the value of the Schema property for this object.
         *
         * @param schema
         *        The new value for the Schema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * Sets the value of the Schema property for this object.
         *
         * This is a convenience that creates an instance of the {@link Schema.Builder} avoiding the need to create one
         * manually via {@link Schema#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * Create an Expainability visualization that is viewable within the AWS console.
         * </p>
         * 
         * @param enableVisualization
         *        Create an Expainability visualization that is viewable within the AWS console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableVisualization(Boolean enableVisualization);

        /**
         * <p>
         * If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, define the first point for the
         * Explainability.
         * </p>
         * <p>
         * Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
         * </p>
         * 
         * @param startDateTime
         *        If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, define the first point for the
         *        Explainability.</p>
         *        <p>
         *        Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(String startDateTime);

        /**
         * <p>
         * If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, define the last time point for the
         * Explainability.
         * </p>
         * <p>
         * Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
         * </p>
         * 
         * @param endDateTime
         *        If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, define the last time point for
         *        the Explainability.</p>
         *        <p>
         *        Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(String endDateTime);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata to help you categorize and organize your resources. Each tag consists of a key and
         *        an optional value, both of which you define. Tag keys and values are case sensitive.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique and each tag key must have one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource: 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If
         *        your tagging schema is used across other services and resources, the character restrictions of those
         *        services also apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or
         *        <code>AWS:</code>. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but
         *        the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        You cannot edit or delete tag keys with this prefix.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata to help you categorize and organize your resources. Each tag consists of a key and
         *        an optional value, both of which you define. Tag keys and values are case sensitive.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique and each tag key must have one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource: 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If
         *        your tagging schema is used across other services and resources, the character restrictions of those
         *        services also apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or
         *        <code>AWS:</code>. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but
         *        the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        You cannot edit or delete tag keys with this prefix.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String explainabilityName;

        private String resourceArn;

        private ExplainabilityConfig explainabilityConfig;

        private DataSource dataSource;

        private Schema schema;

        private Boolean enableVisualization;

        private String startDateTime;

        private String endDateTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExplainabilityRequest model) {
            super(model);
            explainabilityName(model.explainabilityName);
            resourceArn(model.resourceArn);
            explainabilityConfig(model.explainabilityConfig);
            dataSource(model.dataSource);
            schema(model.schema);
            enableVisualization(model.enableVisualization);
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
            tags(model.tags);
        }

        public final String getExplainabilityName() {
            return explainabilityName;
        }

        public final void setExplainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
        }

        @Override
        @Transient
        public final Builder explainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ExplainabilityConfig.Builder getExplainabilityConfig() {
            return explainabilityConfig != null ? explainabilityConfig.toBuilder() : null;
        }

        public final void setExplainabilityConfig(ExplainabilityConfig.BuilderImpl explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig != null ? explainabilityConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        @Transient
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        @Transient
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final Boolean getEnableVisualization() {
            return enableVisualization;
        }

        public final void setEnableVisualization(Boolean enableVisualization) {
            this.enableVisualization = enableVisualization;
        }

        @Override
        @Transient
        public final Builder enableVisualization(Boolean enableVisualization) {
            this.enableVisualization = enableVisualization;
            return this;
        }

        public final String getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        @Transient
        public final Builder startDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        @Transient
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExplainabilityRequest build() {
            return new CreateExplainabilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
