/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Domain {
    RETAIL("RETAIL"),
    CUSTOM("CUSTOM"),
    INVENTORY_PLANNING("INVENTORY_PLANNING"),
    EC2_CAPACITY("EC2_CAPACITY"),
    WORK_FORCE("WORK_FORCE"),
    WEB_TRAFFIC("WEB_TRAFFIC"),
    METRICS("METRICS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Domain(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Domain fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Domain.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Domain> knownValues() {
        return Stream.of(Domain.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

