/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for a hyperparameter tuning job. You specify this object in the <a>CreatePredictor</a>
 * request.
 * </p>
 * <p>
 * A <i>hyperparameter</i> is a parameter that governs the model training process. You set hyperparameters before
 * training starts, unlike model parameters, which are determined during training. The values of the hyperparameters
 * effect which values are chosen for the model parameters.
 * </p>
 * <p>
 * In a <i>hyperparameter tuning job</i>, Amazon Forecast chooses the set of hyperparameter values that optimize a
 * specified metric. Forecast accomplishes this by running many training jobs over a range of hyperparameter values. The
 * optimum set of values depends on the algorithm, the training data, and the specified metric objective.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTuningJobConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTuningJobConfig.Builder, HyperParameterTuningJobConfig> {
    private static final SdkField<ParameterRanges> PARAMETER_RANGES_FIELD = SdkField
            .<ParameterRanges> builder(MarshallingType.SDK_POJO).memberName("ParameterRanges")
            .getter(getter(HyperParameterTuningJobConfig::parameterRanges)).setter(setter(Builder::parameterRanges))
            .constructor(ParameterRanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterRanges").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ParameterRanges parameterRanges;

    private HyperParameterTuningJobConfig(BuilderImpl builder) {
        this.parameterRanges = builder.parameterRanges;
    }

    /**
     * <p>
     * Specifies the ranges of valid values for the hyperparameters.
     * </p>
     * 
     * @return Specifies the ranges of valid values for the hyperparameters.
     */
    public final ParameterRanges parameterRanges() {
        return parameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterRanges());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobConfig)) {
            return false;
        }
        HyperParameterTuningJobConfig other = (HyperParameterTuningJobConfig) obj;
        return Objects.equals(parameterRanges(), other.parameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperParameterTuningJobConfig").add("ParameterRanges", parameterRanges()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterRanges":
            return Optional.ofNullable(clazz.cast(parameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobConfig, T> g) {
        return obj -> g.apply((HyperParameterTuningJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTuningJobConfig> {
        /**
         * <p>
         * Specifies the ranges of valid values for the hyperparameters.
         * </p>
         * 
         * @param parameterRanges
         *        Specifies the ranges of valid values for the hyperparameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterRanges(ParameterRanges parameterRanges);

        /**
         * <p>
         * Specifies the ranges of valid values for the hyperparameters.
         * </p>
         * This is a convenience that creates an instance of the {@link ParameterRanges.Builder} avoiding the need to
         * create one manually via {@link ParameterRanges#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParameterRanges.Builder#build()} is called immediately and its
         * result is passed to {@link #parameterRanges(ParameterRanges)}.
         * 
         * @param parameterRanges
         *        a consumer that will call methods on {@link ParameterRanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterRanges(ParameterRanges)
         */
        default Builder parameterRanges(Consumer<ParameterRanges.Builder> parameterRanges) {
            return parameterRanges(ParameterRanges.builder().applyMutation(parameterRanges).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ParameterRanges parameterRanges;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobConfig model) {
            parameterRanges(model.parameterRanges);
        }

        public final ParameterRanges.Builder getParameterRanges() {
            return parameterRanges != null ? parameterRanges.toBuilder() : null;
        }

        @Override
        public final Builder parameterRanges(ParameterRanges parameterRanges) {
            this.parameterRanges = parameterRanges;
            return this;
        }

        public final void setParameterRanges(ParameterRanges.BuilderImpl parameterRanges) {
            this.parameterRanges = parameterRanges != null ? parameterRanges.build() : null;
        }

        @Override
        public HyperParameterTuningJobConfig build() {
            return new HyperParameterTuningJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
