/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse;
import software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobSummary;

public class ListPredictorBacktestExportJobsIterable
implements SdkIterable<ListPredictorBacktestExportJobsResponse> {
    private final ForecastClient client;
    private final ListPredictorBacktestExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPredictorBacktestExportJobsIterable(ForecastClient client, ListPredictorBacktestExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPredictorBacktestExportJobsResponseFetcher();
    }

    public Iterator<ListPredictorBacktestExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PredictorBacktestExportJobSummary> predictorBacktestExportJobs() {
        Function<ListPredictorBacktestExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.predictorBacktestExportJobs() != null) {
                return response.predictorBacktestExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPredictorBacktestExportJobsResponseFetcher
    implements SyncPageFetcher<ListPredictorBacktestExportJobsResponse> {
        private ListPredictorBacktestExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListPredictorBacktestExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPredictorBacktestExportJobsResponse nextPage(ListPredictorBacktestExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListPredictorBacktestExportJobsIterable.this.client.listPredictorBacktestExportJobs(ListPredictorBacktestExportJobsIterable.this.firstRequest);
            }
            return ListPredictorBacktestExportJobsIterable.this.client.listPredictorBacktestExportJobs((ListPredictorBacktestExportJobsRequest)((Object)ListPredictorBacktestExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

