/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListForecastExportJobsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListForecastExportJobsResponse.Builder, ListForecastExportJobsResponse> {
    private static final SdkField<List<ForecastExportJobSummary>> FORECAST_EXPORT_JOBS_FIELD = SdkField
            .<List<ForecastExportJobSummary>> builder(MarshallingType.LIST)
            .memberName("ForecastExportJobs")
            .getter(getter(ListForecastExportJobsResponse::forecastExportJobs))
            .setter(setter(Builder::forecastExportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastExportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ForecastExportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ForecastExportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListForecastExportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_EXPORT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ForecastExportJobSummary> forecastExportJobs;

    private final String nextToken;

    private ListForecastExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.forecastExportJobs = builder.forecastExportJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ForecastExportJobs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasForecastExportJobs() {
        return forecastExportJobs != null && !(forecastExportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize each export job's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasForecastExportJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that summarize each export job's properties.
     */
    public List<ForecastExportJobSummary> forecastExportJobs() {
        return forecastExportJobs;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the
     * token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
     *         use the token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(forecastExportJobs());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListForecastExportJobsResponse)) {
            return false;
        }
        ListForecastExportJobsResponse other = (ListForecastExportJobsResponse) obj;
        return Objects.equals(forecastExportJobs(), other.forecastExportJobs()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListForecastExportJobsResponse").add("ForecastExportJobs", forecastExportJobs())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastExportJobs":
            return Optional.ofNullable(clazz.cast(forecastExportJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListForecastExportJobsResponse, T> g) {
        return obj -> g.apply((ListForecastExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListForecastExportJobsResponse> {
        /**
         * <p>
         * An array of objects that summarize each export job's properties.
         * </p>
         * 
         * @param forecastExportJobs
         *        An array of objects that summarize each export job's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastExportJobs(Collection<ForecastExportJobSummary> forecastExportJobs);

        /**
         * <p>
         * An array of objects that summarize each export job's properties.
         * </p>
         * 
         * @param forecastExportJobs
         *        An array of objects that summarize each export job's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastExportJobs(ForecastExportJobSummary... forecastExportJobs);

        /**
         * <p>
         * An array of objects that summarize each export job's properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ForecastExportJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<ForecastExportJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ForecastExportJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #forecastExportJobs(List<ForecastExportJobSummary>)}.
         * 
         * @param forecastExportJobs
         *        a consumer that will call methods on {@link List<ForecastExportJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecastExportJobs(List<ForecastExportJobSummary>)
         */
        Builder forecastExportJobs(Consumer<ForecastExportJobSummary.Builder>... forecastExportJobs);

        /**
         * <p>
         * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<ForecastExportJobSummary> forecastExportJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListForecastExportJobsResponse model) {
            super(model);
            forecastExportJobs(model.forecastExportJobs);
            nextToken(model.nextToken);
        }

        public final Collection<ForecastExportJobSummary.Builder> getForecastExportJobs() {
            return forecastExportJobs != null ? forecastExportJobs.stream().map(ForecastExportJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder forecastExportJobs(Collection<ForecastExportJobSummary> forecastExportJobs) {
            this.forecastExportJobs = ForecastExportJobsCopier.copy(forecastExportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastExportJobs(ForecastExportJobSummary... forecastExportJobs) {
            forecastExportJobs(Arrays.asList(forecastExportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastExportJobs(Consumer<ForecastExportJobSummary.Builder>... forecastExportJobs) {
            forecastExportJobs(Stream.of(forecastExportJobs)
                    .map(c -> ForecastExportJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setForecastExportJobs(Collection<ForecastExportJobSummary.BuilderImpl> forecastExportJobs) {
            this.forecastExportJobs = ForecastExportJobsCopier.copyFromBuilder(forecastExportJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListForecastExportJobsResponse build() {
            return new ListForecastExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
