/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetImportJobResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeDatasetImportJobResponse.Builder, DescribeDatasetImportJobResponse> {
    private static final SdkField<String> DATASET_IMPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetImportJobName").getter(getter(DescribeDatasetImportJobResponse::datasetImportJobName))
            .setter(setter(Builder::datasetImportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobName").build())
            .build();

    private static final SdkField<String> DATASET_IMPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetImportJobArn").getter(getter(DescribeDatasetImportJobResponse::datasetImportJobArn))
            .setter(setter(Builder::datasetImportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArn").build())
            .build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DescribeDatasetImportJobResponse::datasetArn))
            .setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampFormat").getter(getter(DescribeDatasetImportJobResponse::timestampFormat))
            .setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DescribeDatasetImportJobResponse::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Map<String, Statistics>> FIELD_STATISTICS_FIELD = SdkField
            .<Map<String, Statistics>> builder(MarshallingType.MAP)
            .memberName("FieldStatistics")
            .getter(getter(DescribeDatasetImportJobResponse::fieldStatistics))
            .setter(setter(Builder::fieldStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldStatistics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Statistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(Statistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Double> DATA_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DataSize").getter(getter(DescribeDatasetImportJobResponse::dataSize)).setter(setter(Builder::dataSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSize").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDatasetImportJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeDatasetImportJobResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeDatasetImportJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeDatasetImportJobResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_NAME_FIELD,
            DATASET_IMPORT_JOB_ARN_FIELD, DATASET_ARN_FIELD, TIMESTAMP_FORMAT_FIELD, DATA_SOURCE_FIELD, FIELD_STATISTICS_FIELD,
            DATA_SIZE_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private final String datasetImportJobName;

    private final String datasetImportJobArn;

    private final String datasetArn;

    private final String timestampFormat;

    private final DataSource dataSource;

    private final Map<String, Statistics> fieldStatistics;

    private final Double dataSize;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private DescribeDatasetImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobName = builder.datasetImportJobName;
        this.datasetImportJobArn = builder.datasetImportJobArn;
        this.datasetArn = builder.datasetArn;
        this.timestampFormat = builder.timestampFormat;
        this.dataSource = builder.dataSource;
        this.fieldStatistics = builder.fieldStatistics;
        this.dataSize = builder.dataSize;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The name of the dataset import job.
     * </p>
     * 
     * @return The name of the dataset import job.
     */
    public String datasetImportJobName() {
        return datasetImportJobName;
    }

    /**
     * <p>
     * The ARN of the dataset import job.
     * </p>
     * 
     * @return The ARN of the dataset import job.
     */
    public String datasetImportJobArn() {
        return datasetImportJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
     */
    public String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The format of timestamps in the dataset. The format that you specify depends on the <code>DataFrequency</code>
     * specified when the dataset was created. The following formats are supported
     * </p>
     * <ul>
     * <li>
     * <p>
     * "yyyy-MM-dd"
     * </p>
     * <p>
     * For the following data frequencies: Y, M, W, and D
     * </p>
     * </li>
     * <li>
     * <p>
     * "yyyy-MM-dd HH:mm:ss"
     * </p>
     * <p>
     * For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     * </p>
     * </li>
     * </ul>
     * 
     * @return The format of timestamps in the dataset. The format that you specify depends on the
     *         <code>DataFrequency</code> specified when the dataset was created. The following formats are
     *         supported</p>
     *         <ul>
     *         <li>
     *         <p>
     *         "yyyy-MM-dd"
     *         </p>
     *         <p>
     *         For the following data frequencies: Y, M, W, and D
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "yyyy-MM-dd HH:mm:ss"
     *         </p>
     *         <p>
     *         For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     *         </p>
     *         </li>
     */
    public String timestampFormat() {
        return timestampFormat;
    }

    /**
     * <p>
     * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
     * Forecast can assume to access the data.
     * </p>
     * <p>
     * If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.
     * </p>
     * 
     * @return The location of the training data to import and an AWS Identity and Access Management (IAM) role that
     *         Amazon Forecast can assume to access the data.</p>
     *         <p>
     *         If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.
     */
    public DataSource dataSource() {
        return dataSource;
    }

    /**
     * Returns true if the FieldStatistics property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFieldStatistics() {
        return fieldStatistics != null && !(fieldStatistics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Statistical information about each field in the input data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldStatistics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Statistical information about each field in the input data.
     */
    public Map<String, Statistics> fieldStatistics() {
        return fieldStatistics;
    }

    /**
     * <p>
     * The size of the dataset in gigabytes (GB) after the import job has finished.
     * </p>
     * 
     * @return The size of the dataset in gigabytes (GB) after the import job has finished.
     */
    public Double dataSize() {
        return dataSize;
    }

    /**
     * <p>
     * The status of the dataset import job. The status is reflected in the status of the dataset. For example, when the
     * import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is
     * <code>UPDATE_IN_PROGRESS</code>. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the dataset import job. The status is reflected in the status of the dataset. For example,
     *         when the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is
     *         <code>UPDATE_IN_PROGRESS</code>. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * When the dataset import job was created.
     * </p>
     * 
     * @return When the dataset import job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time that the dataset was modified. The time depends on the status of the job, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The same time as <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time that the dataset was modified. The time depends on the status of the job, as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The same time as <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(fieldStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(dataSize());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetImportJobResponse)) {
            return false;
        }
        DescribeDatasetImportJobResponse other = (DescribeDatasetImportJobResponse) obj;
        return Objects.equals(datasetImportJobName(), other.datasetImportJobName())
                && Objects.equals(datasetImportJobArn(), other.datasetImportJobArn())
                && Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(timestampFormat(), other.timestampFormat())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(fieldStatistics(), other.fieldStatistics())
                && Objects.equals(dataSize(), other.dataSize()) && Objects.equals(status(), other.status())
                && Objects.equals(message(), other.message()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDatasetImportJobResponse").add("DatasetImportJobName", datasetImportJobName())
                .add("DatasetImportJobArn", datasetImportJobArn()).add("DatasetArn", datasetArn())
                .add("TimestampFormat", timestampFormat()).add("DataSource", dataSource())
                .add("FieldStatistics", fieldStatistics()).add("DataSize", dataSize()).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetImportJobName":
            return Optional.ofNullable(clazz.cast(datasetImportJobName()));
        case "DatasetImportJobArn":
            return Optional.ofNullable(clazz.cast(datasetImportJobArn()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "TimestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "FieldStatistics":
            return Optional.ofNullable(clazz.cast(fieldStatistics()));
        case "DataSize":
            return Optional.ofNullable(clazz.cast(dataSize()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetImportJobResponse, T> g) {
        return obj -> g.apply((DescribeDatasetImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDatasetImportJobResponse> {
        /**
         * <p>
         * The name of the dataset import job.
         * </p>
         * 
         * @param datasetImportJobName
         *        The name of the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobName(String datasetImportJobName);

        /**
         * <p>
         * The ARN of the dataset import job.
         * </p>
         * 
         * @param datasetImportJobArn
         *        The ARN of the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArn(String datasetImportJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The format of timestamps in the dataset. The format that you specify depends on the
         * <code>DataFrequency</code> specified when the dataset was created. The following formats are supported
         * </p>
         * <ul>
         * <li>
         * <p>
         * "yyyy-MM-dd"
         * </p>
         * <p>
         * For the following data frequencies: Y, M, W, and D
         * </p>
         * </li>
         * <li>
         * <p>
         * "yyyy-MM-dd HH:mm:ss"
         * </p>
         * <p>
         * For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         * </p>
         * </li>
         * </ul>
         * 
         * @param timestampFormat
         *        The format of timestamps in the dataset. The format that you specify depends on the
         *        <code>DataFrequency</code> specified when the dataset was created. The following formats are
         *        supported</p>
         *        <ul>
         *        <li>
         *        <p>
         *        "yyyy-MM-dd"
         *        </p>
         *        <p>
         *        For the following data frequencies: Y, M, W, and D
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "yyyy-MM-dd HH:mm:ss"
         *        </p>
         *        <p>
         *        For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);

        /**
         * <p>
         * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data.
         * </p>
         * <p>
         * If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.
         * </p>
         * 
         * @param dataSource
         *        The location of the training data to import and an AWS Identity and Access Management (IAM) role that
         *        Amazon Forecast can assume to access the data.</p>
         *        <p>
         *        If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data.
         * </p>
         * <p>
         * If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSource.Builder} avoiding the need to create
         * one manually via {@link DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * Statistical information about each field in the input data.
         * </p>
         * 
         * @param fieldStatistics
         *        Statistical information about each field in the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldStatistics(Map<String, Statistics> fieldStatistics);

        /**
         * <p>
         * The size of the dataset in gigabytes (GB) after the import job has finished.
         * </p>
         * 
         * @param dataSize
         *        The size of the dataset in gigabytes (GB) after the import job has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSize(Double dataSize);

        /**
         * <p>
         * The status of the dataset import job. The status is reflected in the status of the dataset. For example, when
         * the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is
         * <code>UPDATE_IN_PROGRESS</code>. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the dataset import job. The status is reflected in the status of the dataset. For
         *        example, when the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is
         *        <code>UPDATE_IN_PROGRESS</code>. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the dataset import job was created.
         * </p>
         * 
         * @param creationTime
         *        When the dataset import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time that the dataset was modified. The time depends on the status of the job, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The same time as <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time that the dataset was modified. The time depends on the status of the job, as
         *        follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The same time as <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String datasetImportJobName;

        private String datasetImportJobArn;

        private String datasetArn;

        private String timestampFormat;

        private DataSource dataSource;

        private Map<String, Statistics> fieldStatistics = DefaultSdkAutoConstructMap.getInstance();

        private Double dataSize;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetImportJobResponse model) {
            super(model);
            datasetImportJobName(model.datasetImportJobName);
            datasetImportJobArn(model.datasetImportJobArn);
            datasetArn(model.datasetArn);
            timestampFormat(model.timestampFormat);
            dataSource(model.dataSource);
            fieldStatistics(model.fieldStatistics);
            dataSize(model.dataSize);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getDatasetImportJobName() {
            return datasetImportJobName;
        }

        @Override
        public final Builder datasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
            return this;
        }

        public final void setDatasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
        }

        public final String getDatasetImportJobArn() {
            return datasetImportJobArn;
        }

        @Override
        public final Builder datasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
            return this;
        }

        public final void setDatasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final Map<String, Statistics.Builder> getFieldStatistics() {
            return fieldStatistics != null ? CollectionUtils.mapValues(fieldStatistics, Statistics::toBuilder) : null;
        }

        @Override
        public final Builder fieldStatistics(Map<String, Statistics> fieldStatistics) {
            this.fieldStatistics = FieldStatisticsCopier.copy(fieldStatistics);
            return this;
        }

        public final void setFieldStatistics(Map<String, Statistics.BuilderImpl> fieldStatistics) {
            this.fieldStatistics = FieldStatisticsCopier.copyFromBuilder(fieldStatistics);
        }

        public final Double getDataSize() {
            return dataSize;
        }

        @Override
        public final Builder dataSize(Double dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public final void setDataSize(Double dataSize) {
            this.dataSize = dataSize;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DescribeDatasetImportJobResponse build() {
            return new DescribeDatasetImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
