/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the forecast export job properties used in the <a>ListForecastExportJobs</a> operation. To get
 * the complete set of properties, call the <a>DescribeForecastExportJob</a> operation, and provide the listed
 * <code>ForecastExportJobArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ForecastExportJobSummary.Builder, ForecastExportJobSummary> {
    private static final SdkField<String> FORECAST_EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastExportJobArn").getter(getter(ForecastExportJobSummary::forecastExportJobArn))
            .setter(setter(Builder::forecastExportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastExportJobArn").build())
            .build();

    private static final SdkField<String> FORECAST_EXPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastExportJobName").getter(getter(ForecastExportJobSummary::forecastExportJobName))
            .setter(setter(Builder::forecastExportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastExportJobName").build())
            .build();

    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField
            .<DataDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(ForecastExportJobSummary::destination)).setter(setter(Builder::destination))
            .constructor(DataDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ForecastExportJobSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ForecastExportJobSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ForecastExportJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(ForecastExportJobSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_EXPORT_JOB_ARN_FIELD,
            FORECAST_EXPORT_JOB_NAME_FIELD, DESTINATION_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String forecastExportJobArn;

    private final String forecastExportJobName;

    private final DataDestination destination;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private ForecastExportJobSummary(BuilderImpl builder) {
        this.forecastExportJobArn = builder.forecastExportJobArn;
        this.forecastExportJobName = builder.forecastExportJobName;
        this.destination = builder.destination;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the forecast export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the forecast export job.
     */
    public final String forecastExportJobArn() {
        return forecastExportJobArn;
    }

    /**
     * <p>
     * The name of the forecast export job.
     * </p>
     * 
     * @return The name of the forecast export job.
     */
    public final String forecastExportJobName() {
        return forecastExportJobName;
    }

    /**
     * <p>
     * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
     * </p>
     * 
     * @return The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
     */
    public final DataDestination destination() {
        return destination;
    }

    /**
     * <p>
     * The status of the forecast export job. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast
     * in your S3 bucket.
     * </p>
     * </note>
     * 
     * @return The status of the forecast export job. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the
     *         forecast in your S3 bucket.
     *         </p>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the forecast export job was created.
     * </p>
     * 
     * @return When the forecast export job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the last successful export job finished.
     * </p>
     * 
     * @return When the last successful export job finished.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forecastExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(forecastExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastExportJobSummary)) {
            return false;
        }
        ForecastExportJobSummary other = (ForecastExportJobSummary) obj;
        return Objects.equals(forecastExportJobArn(), other.forecastExportJobArn())
                && Objects.equals(forecastExportJobName(), other.forecastExportJobName())
                && Objects.equals(destination(), other.destination()) && Objects.equals(status(), other.status())
                && Objects.equals(message(), other.message()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForecastExportJobSummary").add("ForecastExportJobArn", forecastExportJobArn())
                .add("ForecastExportJobName", forecastExportJobName()).add("Destination", destination()).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastExportJobArn":
            return Optional.ofNullable(clazz.cast(forecastExportJobArn()));
        case "ForecastExportJobName":
            return Optional.ofNullable(clazz.cast(forecastExportJobName()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastExportJobSummary, T> g) {
        return obj -> g.apply((ForecastExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForecastExportJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the forecast export job.
         * </p>
         * 
         * @param forecastExportJobArn
         *        The Amazon Resource Name (ARN) of the forecast export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastExportJobArn(String forecastExportJobArn);

        /**
         * <p>
         * The name of the forecast export job.
         * </p>
         * 
         * @param forecastExportJobName
         *        The name of the forecast export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastExportJobName(String forecastExportJobName);

        /**
         * <p>
         * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
         * </p>
         * 
         * @param destination
         *        The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DataDestination destination);

        /**
         * <p>
         * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
         * </p>
         * This is a convenience that creates an instance of the {@link DataDestination.Builder} avoiding the need to
         * create one manually via {@link DataDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(DataDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DataDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DataDestination)
         */
        default Builder destination(Consumer<DataDestination.Builder> destination) {
            return destination(DataDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The status of the forecast export job. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the
         * forecast in your S3 bucket.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the forecast export job. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access
         *        the forecast in your S3 bucket.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the forecast export job was created.
         * </p>
         * 
         * @param creationTime
         *        When the forecast export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the last successful export job finished.
         * </p>
         * 
         * @param lastModificationTime
         *        When the last successful export job finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String forecastExportJobArn;

        private String forecastExportJobName;

        private DataDestination destination;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastExportJobSummary model) {
            forecastExportJobArn(model.forecastExportJobArn);
            forecastExportJobName(model.forecastExportJobName);
            destination(model.destination);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getForecastExportJobArn() {
            return forecastExportJobArn;
        }

        @Override
        public final Builder forecastExportJobArn(String forecastExportJobArn) {
            this.forecastExportJobArn = forecastExportJobArn;
            return this;
        }

        public final void setForecastExportJobArn(String forecastExportJobArn) {
            this.forecastExportJobArn = forecastExportJobArn;
        }

        public final String getForecastExportJobName() {
            return forecastExportJobName;
        }

        @Override
        public final Builder forecastExportJobName(String forecastExportJobName) {
            this.forecastExportJobName = forecastExportJobName;
            return this;
        }

        public final void setForecastExportJobName(String forecastExportJobName) {
            this.forecastExportJobName = forecastExportJobName;
        }

        public final DataDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public ForecastExportJobSummary build() {
            return new ForecastExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
