/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPredictorsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListPredictorsResponse.Builder, ListPredictorsResponse> {
    private static final SdkField<List<PredictorSummary>> PREDICTORS_FIELD = SdkField
            .<List<PredictorSummary>> builder(MarshallingType.LIST)
            .memberName("Predictors")
            .getter(getter(ListPredictorsResponse::predictors))
            .setter(setter(Builder::predictors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predictors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PredictorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PredictorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPredictorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PredictorSummary> predictors;

    private final String nextToken;

    private ListPredictorsResponse(BuilderImpl builder) {
        super(builder);
        this.predictors = builder.predictors;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Predictors property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPredictors() {
        return predictors != null && !(predictors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize each predictor's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPredictors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that summarize each predictor's properties.
     */
    public List<PredictorSummary> predictors() {
        return predictors;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the
     * token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
     *         use the token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPredictors() ? predictors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPredictorsResponse)) {
            return false;
        }
        ListPredictorsResponse other = (ListPredictorsResponse) obj;
        return hasPredictors() == other.hasPredictors() && Objects.equals(predictors(), other.predictors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPredictorsResponse").add("Predictors", hasPredictors() ? predictors() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Predictors":
            return Optional.ofNullable(clazz.cast(predictors()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPredictorsResponse, T> g) {
        return obj -> g.apply((ListPredictorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPredictorsResponse> {
        /**
         * <p>
         * An array of objects that summarize each predictor's properties.
         * </p>
         * 
         * @param predictors
         *        An array of objects that summarize each predictor's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictors(Collection<PredictorSummary> predictors);

        /**
         * <p>
         * An array of objects that summarize each predictor's properties.
         * </p>
         * 
         * @param predictors
         *        An array of objects that summarize each predictor's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictors(PredictorSummary... predictors);

        /**
         * <p>
         * An array of objects that summarize each predictor's properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PredictorSummary>.Builder} avoiding the
         * need to create one manually via {@link List<PredictorSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PredictorSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #predictors(List<PredictorSummary>)}.
         * 
         * @param predictors
         *        a consumer that will call methods on {@link List<PredictorSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictors(List<PredictorSummary>)
         */
        Builder predictors(Consumer<PredictorSummary.Builder>... predictors);

        /**
         * <p>
         * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<PredictorSummary> predictors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPredictorsResponse model) {
            super(model);
            predictors(model.predictors);
            nextToken(model.nextToken);
        }

        public final Collection<PredictorSummary.Builder> getPredictors() {
            if (predictors instanceof SdkAutoConstructList) {
                return null;
            }
            return predictors != null ? predictors.stream().map(PredictorSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder predictors(Collection<PredictorSummary> predictors) {
            this.predictors = PredictorsCopier.copy(predictors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictors(PredictorSummary... predictors) {
            predictors(Arrays.asList(predictors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictors(Consumer<PredictorSummary.Builder>... predictors) {
            predictors(Stream.of(predictors).map(c -> PredictorSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPredictors(Collection<PredictorSummary.BuilderImpl> predictors) {
            this.predictors = PredictorsCopier.copyFromBuilder(predictors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPredictorsResponse build() {
            return new ListPredictorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
