/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PredictorEvaluationResultsCopier {
    static List<EvaluationResult> copy(Collection<EvaluationResult> predictorEvaluationResultsParam) {
        if (predictorEvaluationResultsParam == null || predictorEvaluationResultsParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<EvaluationResult> predictorEvaluationResultsParamCopy = new ArrayList<>(predictorEvaluationResultsParam);
        return Collections.unmodifiableList(predictorEvaluationResultsParamCopy);
    }

    static List<EvaluationResult> copyFromBuilder(Collection<? extends EvaluationResult.Builder> predictorEvaluationResultsParam) {
        if (predictorEvaluationResultsParam == null || predictorEvaluationResultsParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(predictorEvaluationResultsParam.stream().map(EvaluationResult.Builder::build).collect(toList()));
    }
}
