/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a supplementary feature of a dataset group. This object is part of the <a>InputDataConfig</a> object.
 * </p>
 * <p>
 * The only supported feature is a holiday calendar. If you use the calendar, all data in the datasets should belong to
 * the same country as the calendar. For the holiday calendar data, see the <a
 * href="http://jollyday.sourceforge.net/data.html">Jollyday</a> web site.
 * </p>
 * <p>
 * India and Korea's holidays are not included in the Jollyday library, but both are supported by Amazon Forecast. Their
 * holidays are:
 * </p>
 * <p>
 * <b>"IN" - INDIA</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>JANUARY 26 - REPUBLIC DAY</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AUGUST 15 - INDEPENDENCE DAY</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>OCTOBER 2 GANDHI'S BIRTHDAY</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>"KR" - KOREA</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>JANUARY 1 - NEW YEAR</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>MARCH 1 - INDEPENDENCE MOVEMENT DAY</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>MAY 5 - CHILDREN'S DAY</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>JUNE 6 - MEMORIAL DAY</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AUGUST 15 - LIBERATION DAY</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>OCTOBER 3 - NATIONAL FOUNDATION DAY</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>OCTOBER 9 - HANGEUL DAY</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DECEMBER 25 - CHRISTMAS DAY</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupplementaryFeature implements SdkPojo, Serializable,
        ToCopyableBuilder<SupplementaryFeature.Builder, SupplementaryFeature> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SupplementaryFeature::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(SupplementaryFeature::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private SupplementaryFeature(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the feature. This must be "holiday".
     * </p>
     * 
     * @return The name of the feature. This must be "holiday".
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * One of the following 2 letter country codes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * "AR" - ARGENTINA
     * </p>
     * </li>
     * <li>
     * <p>
     * "AT" - AUSTRIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "AU" - AUSTRALIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "BE" - BELGIUM
     * </p>
     * </li>
     * <li>
     * <p>
     * "BR" - BRAZIL
     * </p>
     * </li>
     * <li>
     * <p>
     * "CA" - CANADA
     * </p>
     * </li>
     * <li>
     * <p>
     * "CN" - CHINA
     * </p>
     * </li>
     * <li>
     * <p>
     * "CZ" - CZECH REPUBLIC
     * </p>
     * </li>
     * <li>
     * <p>
     * "DK" - DENMARK
     * </p>
     * </li>
     * <li>
     * <p>
     * "EC" - ECUADOR
     * </p>
     * </li>
     * <li>
     * <p>
     * "FI" - FINLAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "FR" - FRANCE
     * </p>
     * </li>
     * <li>
     * <p>
     * "DE" - GERMANY
     * </p>
     * </li>
     * <li>
     * <p>
     * "HU" - HUNGARY
     * </p>
     * </li>
     * <li>
     * <p>
     * "IE" - IRELAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "IN" - INDIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "IT" - ITALY
     * </p>
     * </li>
     * <li>
     * <p>
     * "JP" - JAPAN
     * </p>
     * </li>
     * <li>
     * <p>
     * "KR" - KOREA
     * </p>
     * </li>
     * <li>
     * <p>
     * "LU" - LUXEMBOURG
     * </p>
     * </li>
     * <li>
     * <p>
     * "MX" - MEXICO
     * </p>
     * </li>
     * <li>
     * <p>
     * "NL" - NETHERLANDS
     * </p>
     * </li>
     * <li>
     * <p>
     * "NO" - NORWAY
     * </p>
     * </li>
     * <li>
     * <p>
     * "PL" - POLAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "PT" - PORTUGAL
     * </p>
     * </li>
     * <li>
     * <p>
     * "RU" - RUSSIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "ZA" - SOUTH AFRICA
     * </p>
     * </li>
     * <li>
     * <p>
     * "ES" - SPAIN
     * </p>
     * </li>
     * <li>
     * <p>
     * "SE" - SWEDEN
     * </p>
     * </li>
     * <li>
     * <p>
     * "CH" - SWITZERLAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "US" - UNITED STATES
     * </p>
     * </li>
     * <li>
     * <p>
     * "UK" - UNITED KINGDOM
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following 2 letter country codes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         "AR" - ARGENTINA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "AT" - AUSTRIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "AU" - AUSTRALIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "BE" - BELGIUM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "BR" - BRAZIL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CA" - CANADA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CN" - CHINA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CZ" - CZECH REPUBLIC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "DK" - DENMARK
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "EC" - ECUADOR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "FI" - FINLAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "FR" - FRANCE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "DE" - GERMANY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "HU" - HUNGARY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "IE" - IRELAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "IN" - INDIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "IT" - ITALY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "JP" - JAPAN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "KR" - KOREA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "LU" - LUXEMBOURG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "MX" - MEXICO
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "NL" - NETHERLANDS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "NO" - NORWAY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "PL" - POLAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "PT" - PORTUGAL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "RU" - RUSSIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "ZA" - SOUTH AFRICA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "ES" - SPAIN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "SE" - SWEDEN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CH" - SWITZERLAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "US" - UNITED STATES
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "UK" - UNITED KINGDOM
     *         </p>
     *         </li>
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupplementaryFeature)) {
            return false;
        }
        SupplementaryFeature other = (SupplementaryFeature) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SupplementaryFeature").add("Name", name()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SupplementaryFeature, T> g) {
        return obj -> g.apply((SupplementaryFeature) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupplementaryFeature> {
        /**
         * <p>
         * The name of the feature. This must be "holiday".
         * </p>
         * 
         * @param name
         *        The name of the feature. This must be "holiday".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * One of the following 2 letter country codes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "AR" - ARGENTINA
         * </p>
         * </li>
         * <li>
         * <p>
         * "AT" - AUSTRIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "AU" - AUSTRALIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "BE" - BELGIUM
         * </p>
         * </li>
         * <li>
         * <p>
         * "BR" - BRAZIL
         * </p>
         * </li>
         * <li>
         * <p>
         * "CA" - CANADA
         * </p>
         * </li>
         * <li>
         * <p>
         * "CN" - CHINA
         * </p>
         * </li>
         * <li>
         * <p>
         * "CZ" - CZECH REPUBLIC
         * </p>
         * </li>
         * <li>
         * <p>
         * "DK" - DENMARK
         * </p>
         * </li>
         * <li>
         * <p>
         * "EC" - ECUADOR
         * </p>
         * </li>
         * <li>
         * <p>
         * "FI" - FINLAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "FR" - FRANCE
         * </p>
         * </li>
         * <li>
         * <p>
         * "DE" - GERMANY
         * </p>
         * </li>
         * <li>
         * <p>
         * "HU" - HUNGARY
         * </p>
         * </li>
         * <li>
         * <p>
         * "IE" - IRELAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "IN" - INDIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "IT" - ITALY
         * </p>
         * </li>
         * <li>
         * <p>
         * "JP" - JAPAN
         * </p>
         * </li>
         * <li>
         * <p>
         * "KR" - KOREA
         * </p>
         * </li>
         * <li>
         * <p>
         * "LU" - LUXEMBOURG
         * </p>
         * </li>
         * <li>
         * <p>
         * "MX" - MEXICO
         * </p>
         * </li>
         * <li>
         * <p>
         * "NL" - NETHERLANDS
         * </p>
         * </li>
         * <li>
         * <p>
         * "NO" - NORWAY
         * </p>
         * </li>
         * <li>
         * <p>
         * "PL" - POLAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "PT" - PORTUGAL
         * </p>
         * </li>
         * <li>
         * <p>
         * "RU" - RUSSIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "ZA" - SOUTH AFRICA
         * </p>
         * </li>
         * <li>
         * <p>
         * "ES" - SPAIN
         * </p>
         * </li>
         * <li>
         * <p>
         * "SE" - SWEDEN
         * </p>
         * </li>
         * <li>
         * <p>
         * "CH" - SWITZERLAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "US" - UNITED STATES
         * </p>
         * </li>
         * <li>
         * <p>
         * "UK" - UNITED KINGDOM
         * </p>
         * </li>
         * </ul>
         * 
         * @param value
         *        One of the following 2 letter country codes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        "AR" - ARGENTINA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "AT" - AUSTRIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "AU" - AUSTRALIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "BE" - BELGIUM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "BR" - BRAZIL
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CA" - CANADA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CN" - CHINA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CZ" - CZECH REPUBLIC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "DK" - DENMARK
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "EC" - ECUADOR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "FI" - FINLAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "FR" - FRANCE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "DE" - GERMANY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "HU" - HUNGARY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "IE" - IRELAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "IN" - INDIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "IT" - ITALY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "JP" - JAPAN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "KR" - KOREA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "LU" - LUXEMBOURG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "MX" - MEXICO
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "NL" - NETHERLANDS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "NO" - NORWAY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "PL" - POLAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "PT" - PORTUGAL
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "RU" - RUSSIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "ZA" - SOUTH AFRICA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "ES" - SPAIN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "SE" - SWEDEN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CH" - SWITZERLAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "US" - UNITED STATES
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "UK" - UNITED KINGDOM
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(SupplementaryFeature model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public SupplementaryFeature build() {
            return new SupplementaryFeature(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
