/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the dataset properties used in the <a>ListDatasets</a> operation. To get the complete set of
 * properties, call the <a>DescribeDataset</a> operation, and provide the <code>DatasetArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetSummary implements SdkPojo, Serializable, ToCopyableBuilder<DatasetSummary.Builder, DatasetSummary> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetSummary::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetSummary::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetSummary::datasetTypeAsString)).setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetSummary::domainAsString)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DatasetSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DatasetSummary::lastModificationTime)).setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD,
            DATASET_NAME_FIELD, DATASET_TYPE_FIELD, DOMAIN_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetArn;

    private final String datasetName;

    private final String datasetType;

    private final String domain;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private DatasetSummary(BuilderImpl builder) {
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.datasetType = builder.datasetType;
        this.domain = builder.domain;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The dataset type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The dataset type.
     * @see DatasetType
     */
    public DatasetType datasetType() {
        return DatasetType.fromValue(datasetType);
    }

    /**
     * <p>
     * The dataset type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The dataset type.
     * @see DatasetType
     */
    public String datasetTypeAsString() {
        return datasetType;
    }

    /**
     * <p>
     * The domain associated with the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset.
     * @see Domain
     */
    public Domain domain() {
        return Domain.fromValue(domain);
    }

    /**
     * <p>
     * The domain associated with the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset.
     * @see Domain
     */
    public String domainAsString() {
        return domain;
    }

    /**
     * <p>
     * When the dataset was created.
     * </p>
     * 
     * @return When the dataset was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While data
     * is being imported to the dataset, <code>LastModificationTime</code> is the current time of the
     * <code>ListDatasets</code> call. After a <a>CreateDatasetImportJob</a> operation has finished,
     * <code>LastModificationTime</code> is when the import job completed or failed.
     * </p>
     * 
     * @return When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>.
     *         While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the
     *         <code>ListDatasets</code> call. After a <a>CreateDatasetImportJob</a> operation has finished,
     *         <code>LastModificationTime</code> is when the import job completed or failed.
     */
    public Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSummary)) {
            return false;
        }
        DatasetSummary other = (DatasetSummary) obj;
        return Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(datasetTypeAsString(), other.datasetTypeAsString())
                && Objects.equals(domainAsString(), other.domainAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatasetSummary").add("DatasetArn", datasetArn()).add("DatasetName", datasetName())
                .add("DatasetType", datasetTypeAsString()).add("Domain", domainAsString()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetTypeAsString()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetSummary, T> g) {
        return obj -> g.apply((DatasetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The dataset type.
         * </p>
         * 
         * @param datasetType
         *        The dataset type.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The dataset type.
         * </p>
         * 
         * @param datasetType
         *        The dataset type.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(DatasetType datasetType);

        /**
         * <p>
         * The domain associated with the dataset.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(String domain);

        /**
         * <p>
         * The domain associated with the dataset.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(Domain domain);

        /**
         * <p>
         * When the dataset was created.
         * </p>
         * 
         * @param creationTime
         *        When the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While
         * data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the
         * <code>ListDatasets</code> call. After a <a>CreateDatasetImportJob</a> operation has finished,
         * <code>LastModificationTime</code> is when the import job completed or failed.
         * </p>
         * 
         * @param lastModificationTime
         *        When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>.
         *        While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of
         *        the <code>ListDatasets</code> call. After a <a>CreateDatasetImportJob</a> operation has finished,
         *        <code>LastModificationTime</code> is when the import job completed or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String datasetArn;

        private String datasetName;

        private String datasetType;

        private String domain;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSummary model) {
            datasetArn(model.datasetArn);
            datasetName(model.datasetName);
            datasetType(model.datasetType);
            domain(model.domain);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DatasetSummary build() {
            return new DatasetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
