/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.DatasetType;
import software.amazon.awssdk.services.forecast.model.Domain;
import software.amazon.awssdk.services.forecast.model.EncryptionConfig;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.Schema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateDatasetRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDatasetRequest.getter(CreateDatasetRequest::datasetName)).setter(CreateDatasetRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDatasetRequest.getter(CreateDatasetRequest::domainAsString)).setter(CreateDatasetRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDatasetRequest.getter(CreateDatasetRequest::datasetTypeAsString)).setter(CreateDatasetRequest.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()}).build();
    private static final SdkField<String> DATA_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDatasetRequest.getter(CreateDatasetRequest::dataFrequency)).setter(CreateDatasetRequest.setter(Builder::dataFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFrequency").build()}).build();
    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDatasetRequest.getter(CreateDatasetRequest::schema)).setter(CreateDatasetRequest.setter(Builder::schema)).constructor(Schema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDatasetRequest.getter(CreateDatasetRequest::encryptionConfig)).setter(CreateDatasetRequest.setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD, DOMAIN_FIELD, DATASET_TYPE_FIELD, DATA_FREQUENCY_FIELD, SCHEMA_FIELD, ENCRYPTION_CONFIG_FIELD));
    private final String datasetName;
    private final String domain;
    private final String datasetType;
    private final String dataFrequency;
    private final Schema schema;
    private final EncryptionConfig encryptionConfig;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.domain = builder.domain;
        this.datasetType = builder.datasetType;
        this.dataFrequency = builder.dataFrequency;
        this.schema = builder.schema;
        this.encryptionConfig = builder.encryptionConfig;
    }

    public String datasetName() {
        return this.datasetName;
    }

    public Domain domain() {
        return Domain.fromValue(this.domain);
    }

    public String domainAsString() {
        return this.domain;
    }

    public DatasetType datasetType() {
        return DatasetType.fromValue(this.datasetType);
    }

    public String datasetTypeAsString() {
        return this.datasetType;
    }

    public String dataFrequency() {
        return this.dataFrequency;
    }

    public Schema schema() {
        return this.schema;
    }

    public EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest)((Object)obj);
        return Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.datasetTypeAsString(), other.datasetTypeAsString()) && Objects.equals(this.dataFrequency(), other.dataFrequency()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.encryptionConfig(), other.encryptionConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateDatasetRequest").add("DatasetName", (Object)this.datasetName()).add("Domain", (Object)this.domainAsString()).add("DatasetType", (Object)this.datasetTypeAsString()).add("DataFrequency", (Object)this.dataFrequency()).add("Schema", (Object)this.schema()).add("EncryptionConfig", (Object)this.encryptionConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetTypeAsString()));
            }
            case "DataFrequency": {
                return Optional.ofNullable(clazz.cast(this.dataFrequency()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "EncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String datasetName;
        private String domain;
        private String datasetType;
        private String dataFrequency;
        private Schema schema;
        private EncryptionConfig encryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            this.datasetName(model.datasetName);
            this.domain(model.domain);
            this.datasetType(model.datasetType);
            this.dataFrequency(model.dataFrequency);
            this.schema(model.schema);
            this.encryptionConfig(model.encryptionConfig);
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        public final String getDataFrequency() {
            return this.dataFrequency;
        }

        @Override
        public final Builder dataFrequency(String dataFrequency) {
            this.dataFrequency = dataFrequency;
            return this;
        }

        public final void setDataFrequency(String dataFrequency) {
            this.dataFrequency = dataFrequency;
        }

        public final Schema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return this.encryptionConfig != null ? this.encryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetRequest> {
        public Builder datasetName(String var1);

        public Builder domain(String var1);

        public Builder domain(Domain var1);

        public Builder datasetType(String var1);

        public Builder datasetType(DatasetType var1);

        public Builder dataFrequency(String var1);

        public Builder schema(Schema var1);

        default public Builder schema(Consumer<Schema.Builder> schema) {
            return this.schema((Schema)((Schema.Builder)Schema.builder().applyMutation(schema)).build());
        }

        public Builder encryptionConfig(EncryptionConfig var1);

        default public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return this.encryptionConfig((EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation(encryptionConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

