/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter for choosing a subset of objects. Each filter consists of a condition and a match statement. The
 * condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include or exclude the objects
 * that match the statement, respectively. The match statement consists of a key and a value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Filter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Filter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Filter::conditionAsString)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private final String condition;

    private Filter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * The name of the parameter to filter on.
     * </p>
     * 
     * @return The name of the parameter to filter on.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The value to match.
     * </p>
     * 
     * @return The value to match.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude
     * matching objects, specify <code>IS_NOT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterConditionString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #conditionAsString}.
     * </p>
     * 
     * @return The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To
     *         exclude matching objects, specify <code>IS_NOT</code>.
     * @see FilterConditionString
     */
    public FilterConditionString condition() {
        return FilterConditionString.fromValue(condition);
    }

    /**
     * <p>
     * The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude
     * matching objects, specify <code>IS_NOT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterConditionString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #conditionAsString}.
     * </p>
     * 
     * @return The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To
     *         exclude matching objects, specify <code>IS_NOT</code>.
     * @see FilterConditionString
     */
    public String conditionAsString() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(conditionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(conditionAsString(), other.conditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Filter").add("Key", key()).add("Value", value()).add("Condition", conditionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(conditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The name of the parameter to filter on.
         * </p>
         * 
         * @param key
         *        The name of the parameter to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value to match.
         * </p>
         * 
         * @param value
         *        The value to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude
         * matching objects, specify <code>IS_NOT</code>.
         * </p>
         * 
         * @param condition
         *        The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To
         *        exclude matching objects, specify <code>IS_NOT</code>.
         * @see FilterConditionString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterConditionString
         */
        Builder condition(String condition);

        /**
         * <p>
         * The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude
         * matching objects, specify <code>IS_NOT</code>.
         * </p>
         * 
         * @param condition
         *        The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To
         *        exclude matching objects, specify <code>IS_NOT</code>.
         * @see FilterConditionString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterConditionString
         */
        Builder condition(FilterConditionString condition);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            key(model.key);
            value(model.value);
            condition(model.condition);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getConditionAsString() {
            return condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(FilterConditionString condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
