/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetGroupResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeDatasetGroupResponse.Builder, DescribeDatasetGroupResponse> {
    private static final SdkField<String> DATASET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetGroupResponse::datasetGroupName)).setter(setter(Builder::datasetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupName").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetGroupResponse::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()).build();

    private static final SdkField<List<String>> DATASET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDatasetGroupResponse::datasetArns))
            .setter(setter(Builder::datasetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetGroupResponse::domainAsString)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetGroupResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeDatasetGroupResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeDatasetGroupResponse::lastModificationTime)).setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_NAME_FIELD,
            DATASET_GROUP_ARN_FIELD, DATASET_ARNS_FIELD, DOMAIN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD));

    private final String datasetGroupName;

    private final String datasetGroupArn;

    private final List<String> datasetArns;

    private final String domain;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private DescribeDatasetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.datasetGroupName = builder.datasetGroupName;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.datasetArns = builder.datasetArns;
        this.domain = builder.domain;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The name of the dataset group.
     * </p>
     * 
     * @return The name of the dataset group.
     */
    public String datasetGroupName() {
        return datasetGroupName;
    }

    /**
     * <p>
     * The ARN of the dataset group.
     * </p>
     * 
     * @return The ARN of the dataset group.
     */
    public String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * Returns true if the DatasetArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDatasetArns() {
        return datasetArns != null && !(datasetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDatasetArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset group.
     */
    public List<String> datasetArns() {
        return datasetArns;
    }

    /**
     * <p>
     * The domain associated with the dataset group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset group.
     * @see Domain
     */
    public Domain domain() {
        return Domain.fromValue(domain);
    }

    /**
     * <p>
     * The domain associated with the dataset group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset group.
     * @see Domain
     */
    public String domainAsString() {
        return domain;
    }

    /**
     * <p>
     * The status of the dataset group. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can use the dataset group to
     * create a predictor.
     * </p>
     * </note>
     * 
     * @return The status of the dataset group. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can use the dataset
     *         group to create a predictor.
     *         </p>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * When the dataset group was created.
     * </p>
     * 
     * @return When the dataset group was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation. While
     * the dataset group is being updated, <code>LastModificationTime</code> is the current time of the
     * <code>DescribeDatasetGroup</code> call.
     * </p>
     * 
     * @return When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a>
     *         operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current
     *         time of the <code>DescribeDatasetGroup</code> call.
     */
    public Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArns());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetGroupResponse)) {
            return false;
        }
        DescribeDatasetGroupResponse other = (DescribeDatasetGroupResponse) obj;
        return Objects.equals(datasetGroupName(), other.datasetGroupName())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(datasetArns(), other.datasetArns()) && Objects.equals(domainAsString(), other.domainAsString())
                && Objects.equals(status(), other.status()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDatasetGroupResponse").add("DatasetGroupName", datasetGroupName())
                .add("DatasetGroupArn", datasetGroupArn()).add("DatasetArns", datasetArns()).add("Domain", domainAsString())
                .add("Status", status()).add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetGroupName":
            return Optional.ofNullable(clazz.cast(datasetGroupName()));
        case "DatasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "DatasetArns":
            return Optional.ofNullable(clazz.cast(datasetArns()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetGroupResponse, T> g) {
        return obj -> g.apply((DescribeDatasetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetGroupResponse> {
        /**
         * <p>
         * The name of the dataset group.
         * </p>
         * 
         * @param datasetGroupName
         *        The name of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupName(String datasetGroupName);

        /**
         * <p>
         * The ARN of the dataset group.
         * </p>
         * 
         * @param datasetGroupArn
         *        The ARN of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset group.
         * </p>
         * 
         * @param datasetArns
         *        An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArns(Collection<String> datasetArns);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset group.
         * </p>
         * 
         * @param datasetArns
         *        An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArns(String... datasetArns);

        /**
         * <p>
         * The domain associated with the dataset group.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset group.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(String domain);

        /**
         * <p>
         * The domain associated with the dataset group.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset group.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(Domain domain);

        /**
         * <p>
         * The status of the dataset group. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.
         * </p>
         * <note>
         * <p>
         * The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can use the dataset group
         * to create a predictor.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the dataset group. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can use the
         *        dataset group to create a predictor.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * When the dataset group was created.
         * </p>
         * 
         * @param creationTime
         *        When the dataset group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation.
         * While the dataset group is being updated, <code>LastModificationTime</code> is the current time of the
         * <code>DescribeDatasetGroup</code> call.
         * </p>
         * 
         * @param lastModificationTime
         *        When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a>
         *        operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current
         *        time of the <code>DescribeDatasetGroup</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String datasetGroupName;

        private String datasetGroupArn;

        private List<String> datasetArns = DefaultSdkAutoConstructList.getInstance();

        private String domain;

        private String status;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetGroupResponse model) {
            super(model);
            datasetGroupName(model.datasetGroupName);
            datasetGroupArn(model.datasetGroupArn);
            datasetArns(model.datasetArns);
            domain(model.domain);
            status(model.status);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getDatasetGroupName() {
            return datasetGroupName;
        }

        @Override
        public final Builder datasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
            return this;
        }

        public final void setDatasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final Collection<String> getDatasetArns() {
            return datasetArns;
        }

        @Override
        public final Builder datasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetArns(String... datasetArns) {
            datasetArns(Arrays.asList(datasetArns));
            return this;
        }

        public final void setDatasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
        }

        public final String getDomainAsString() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DescribeDatasetGroupResponse build() {
            return new DescribeDatasetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
