/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeDatasetResponse.Builder, DescribeDatasetResponse> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetResponse::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetResponse::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetResponse::domainAsString)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetResponse::datasetTypeAsString)).setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()).build();

    private static final SdkField<String> DATA_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetResponse::dataFrequency)).setter(setter(Builder::dataFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFrequency").build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeDatasetResponse::schema)).setter(setter(Builder::schema)).constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).getter(getter(DescribeDatasetResponse::encryptionConfig))
            .setter(setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDatasetResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeDatasetResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeDatasetResponse::lastModificationTime)).setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD,
            DATASET_NAME_FIELD, DOMAIN_FIELD, DATASET_TYPE_FIELD, DATA_FREQUENCY_FIELD, SCHEMA_FIELD, ENCRYPTION_CONFIG_FIELD,
            STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private final String datasetArn;

    private final String datasetName;

    private final String domain;

    private final String datasetType;

    private final String dataFrequency;

    private final Schema schema;

    private final EncryptionConfig encryptionConfig;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.domain = builder.domain;
        this.datasetType = builder.datasetType;
        this.dataFrequency = builder.dataFrequency;
        this.schema = builder.schema;
        this.encryptionConfig = builder.encryptionConfig;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The domain associated with the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset.
     * @see Domain
     */
    public Domain domain() {
        return Domain.fromValue(domain);
    }

    /**
     * <p>
     * The domain associated with the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset.
     * @see Domain
     */
    public String domainAsString() {
        return domain;
    }

    /**
     * <p>
     * The dataset type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The dataset type.
     * @see DatasetType
     */
    public DatasetType datasetType() {
        return DatasetType.fromValue(datasetType);
    }

    /**
     * <p>
     * The dataset type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The dataset type.
     * @see DatasetType
     */
    public String datasetTypeAsString() {
        return datasetType;
    }

    /**
     * <p>
     * The frequency of data collection.
     * </p>
     * <p>
     * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes),
     * 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "M" indicates every month and "30min"
     * indicates every 30 minutes.
     * </p>
     * 
     * @return The frequency of data collection.</p>
     *         <p>
     *         Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15
     *         minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "M" indicates every
     *         month and "30min" indicates every 30 minutes.
     */
    public String dataFrequency() {
        return dataFrequency;
    }

    /**
     * <p>
     * An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
     * <code>SchemaAttribute</code> specifies the name and data type of a field.
     * </p>
     * 
     * @return An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
     *         <code>SchemaAttribute</code> specifies the name and data type of a field.
     */
    public Schema schema() {
        return schema;
    }

    /**
     * <p>
     * The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon
     * Forecast can assume to access the key.
     * </p>
     * 
     * @return The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that
     *         Amazon Forecast can assume to access the key.
     */
    public EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    /**
     * <p>
     * The status of the dataset. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>UPDATE</code> states apply while data is imported to the dataset from a call to the
     * <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset import job. For example, when the
     * import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is
     * <code>UPDATE_IN_PROGRESS</code>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import training data.
     * </p>
     * </note>
     * 
     * @return The status of the dataset. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The <code>UPDATE</code> states apply while data is imported to the dataset from a call to the
     *         <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset import job. For example,
     *         when the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is
     *         <code>UPDATE_IN_PROGRESS</code>.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import training data.
     *         </p>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * When the dataset was created.
     * </p>
     * 
     * @return When the dataset was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While data
     * is being imported to the dataset, <code>LastModificationTime</code> is the current time of the
     * <code>DescribeDataset</code> call. After a <a>CreateDatasetImportJob</a> operation has finished,
     * <code>LastModificationTime</code> is when the import job completed or failed.
     * </p>
     * 
     * @return When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>.
     *         While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the
     *         <code>DescribeDataset</code> call. After a <a>CreateDatasetImportJob</a> operation has finished,
     *         <code>LastModificationTime</code> is when the import job completed or failed.
     */
    public Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse) obj;
        return Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(domainAsString(), other.domainAsString())
                && Objects.equals(datasetTypeAsString(), other.datasetTypeAsString())
                && Objects.equals(dataFrequency(), other.dataFrequency()) && Objects.equals(schema(), other.schema())
                && Objects.equals(encryptionConfig(), other.encryptionConfig()) && Objects.equals(status(), other.status())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDatasetResponse").add("DatasetArn", datasetArn()).add("DatasetName", datasetName())
                .add("Domain", domainAsString()).add("DatasetType", datasetTypeAsString()).add("DataFrequency", dataFrequency())
                .add("Schema", schema()).add("EncryptionConfig", encryptionConfig()).add("Status", status())
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetTypeAsString()));
        case "DataFrequency":
            return Optional.ofNullable(clazz.cast(dataFrequency()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "EncryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The domain associated with the dataset.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(String domain);

        /**
         * <p>
         * The domain associated with the dataset.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(Domain domain);

        /**
         * <p>
         * The dataset type.
         * </p>
         * 
         * @param datasetType
         *        The dataset type.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The dataset type.
         * </p>
         * 
         * @param datasetType
         *        The dataset type.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(DatasetType datasetType);

        /**
         * <p>
         * The frequency of data collection.
         * </p>
         * <p>
         * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes),
         * 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "M" indicates every month and "30min"
         * indicates every 30 minutes.
         * </p>
         * 
         * @param dataFrequency
         *        The frequency of data collection.</p>
         *        <p>
         *        Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15
         *        minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "M" indicates every
         *        month and "30min" indicates every 30 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFrequency(String dataFrequency);

        /**
         * <p>
         * An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
         * <code>SchemaAttribute</code> specifies the name and data type of a field.
         * </p>
         * 
         * @param schema
         *        An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
         *        <code>SchemaAttribute</code> specifies the name and data type of a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * <p>
         * An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
         * <code>SchemaAttribute</code> specifies the name and data type of a field.
         * </p>
         * This is a convenience that creates an instance of the {@link Schema.Builder} avoiding the need to create one
         * manually via {@link Schema#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the key.
         * </p>
         * 
         * @param encryptionConfig
         *        The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that
         *        Amazon Forecast can assume to access the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * <p>
         * The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the key.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionConfig.Builder} avoiding the need to
         * create one manually via {@link EncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }

        /**
         * <p>
         * The status of the dataset. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>UPDATE</code> states apply while data is imported to the dataset from a call to the
         * <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset import job. For example, when
         * the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is
         * <code>UPDATE_IN_PROGRESS</code>.
         * </p>
         * <note>
         * <p>
         * The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import training data.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the dataset. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The <code>UPDATE</code> states apply while data is imported to the dataset from a call to the
         *        <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset import job. For example,
         *        when the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is
         *        <code>UPDATE_IN_PROGRESS</code>.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import training
         *        data.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * When the dataset was created.
         * </p>
         * 
         * @param creationTime
         *        When the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While
         * data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the
         * <code>DescribeDataset</code> call. After a <a>CreateDatasetImportJob</a> operation has finished,
         * <code>LastModificationTime</code> is when the import job completed or failed.
         * </p>
         * 
         * @param lastModificationTime
         *        When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>.
         *        While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of
         *        the <code>DescribeDataset</code> call. After a <a>CreateDatasetImportJob</a> operation has finished,
         *        <code>LastModificationTime</code> is when the import job completed or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String datasetArn;

        private String datasetName;

        private String domain;

        private String datasetType;

        private String dataFrequency;

        private Schema schema;

        private EncryptionConfig encryptionConfig;

        private String status;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            datasetArn(model.datasetArn);
            datasetName(model.datasetName);
            domain(model.domain);
            datasetType(model.datasetType);
            dataFrequency(model.dataFrequency);
            schema(model.schema);
            encryptionConfig(model.encryptionConfig);
            status(model.status);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getDomainAsString() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDatasetTypeAsString() {
            return datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        public final String getDataFrequency() {
            return dataFrequency;
        }

        @Override
        public final Builder dataFrequency(String dataFrequency) {
            this.dataFrequency = dataFrequency;
            return this;
        }

        public final void setDataFrequency(String dataFrequency) {
            this.dataFrequency = dataFrequency;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
