/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.PartialMatch;
import software.amazon.awssdk.services.fms.model.PartialMatchesCopier;
import software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction;
import software.amazon.awssdk.services.fms.model.SecurityGroupRemediationActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsVPCSecurityGroupViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsVPCSecurityGroupViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationTarget").getter(AwsVPCSecurityGroupViolation.getter(AwsVPCSecurityGroupViolation::violationTarget)).setter(AwsVPCSecurityGroupViolation.setter(Builder::violationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()}).build();
    private static final SdkField<String> VIOLATION_TARGET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationTargetDescription").getter(AwsVPCSecurityGroupViolation.getter(AwsVPCSecurityGroupViolation::violationTargetDescription)).setter(AwsVPCSecurityGroupViolation.setter(Builder::violationTargetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTargetDescription").build()}).build();
    private static final SdkField<List<PartialMatch>> PARTIAL_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartialMatches").getter(AwsVPCSecurityGroupViolation.getter(AwsVPCSecurityGroupViolation::partialMatches)).setter(AwsVPCSecurityGroupViolation.setter(Builder::partialMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartialMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SecurityGroupRemediationAction>> POSSIBLE_SECURITY_GROUP_REMEDIATION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PossibleSecurityGroupRemediationActions").getter(AwsVPCSecurityGroupViolation.getter(AwsVPCSecurityGroupViolation::possibleSecurityGroupRemediationActions)).setter(AwsVPCSecurityGroupViolation.setter(Builder::possibleSecurityGroupRemediationActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PossibleSecurityGroupRemediationActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupRemediationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD, VIOLATION_TARGET_DESCRIPTION_FIELD, PARTIAL_MATCHES_FIELD, POSSIBLE_SECURITY_GROUP_REMEDIATION_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsVPCSecurityGroupViolation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String violationTarget;
    private final String violationTargetDescription;
    private final List<PartialMatch> partialMatches;
    private final List<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions;

    private AwsVPCSecurityGroupViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.violationTargetDescription = builder.violationTargetDescription;
        this.partialMatches = builder.partialMatches;
        this.possibleSecurityGroupRemediationActions = builder.possibleSecurityGroupRemediationActions;
    }

    public final String violationTarget() {
        return this.violationTarget;
    }

    public final String violationTargetDescription() {
        return this.violationTargetDescription;
    }

    public final boolean hasPartialMatches() {
        return this.partialMatches != null && !(this.partialMatches instanceof SdkAutoConstructList);
    }

    public final List<PartialMatch> partialMatches() {
        return this.partialMatches;
    }

    public final boolean hasPossibleSecurityGroupRemediationActions() {
        return this.possibleSecurityGroupRemediationActions != null && !(this.possibleSecurityGroupRemediationActions instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions() {
        return this.possibleSecurityGroupRemediationActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationTargetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartialMatches() ? this.partialMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPossibleSecurityGroupRemediationActions() ? this.possibleSecurityGroupRemediationActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsVPCSecurityGroupViolation)) {
            return false;
        }
        AwsVPCSecurityGroupViolation other = (AwsVPCSecurityGroupViolation)obj;
        return Objects.equals(this.violationTarget(), other.violationTarget()) && Objects.equals(this.violationTargetDescription(), other.violationTargetDescription()) && this.hasPartialMatches() == other.hasPartialMatches() && Objects.equals(this.partialMatches(), other.partialMatches()) && this.hasPossibleSecurityGroupRemediationActions() == other.hasPossibleSecurityGroupRemediationActions() && Objects.equals(this.possibleSecurityGroupRemediationActions(), other.possibleSecurityGroupRemediationActions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsVPCSecurityGroupViolation").add("ViolationTarget", (Object)this.violationTarget()).add("ViolationTargetDescription", (Object)this.violationTargetDescription()).add("PartialMatches", this.hasPartialMatches() ? this.partialMatches() : null).add("PossibleSecurityGroupRemediationActions", this.hasPossibleSecurityGroupRemediationActions() ? this.possibleSecurityGroupRemediationActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ViolationTarget": {
                return Optional.ofNullable(clazz.cast(this.violationTarget()));
            }
            case "ViolationTargetDescription": {
                return Optional.ofNullable(clazz.cast(this.violationTargetDescription()));
            }
            case "PartialMatches": {
                return Optional.ofNullable(clazz.cast(this.partialMatches()));
            }
            case "PossibleSecurityGroupRemediationActions": {
                return Optional.ofNullable(clazz.cast(this.possibleSecurityGroupRemediationActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ViolationTarget", VIOLATION_TARGET_FIELD);
        map.put("ViolationTargetDescription", VIOLATION_TARGET_DESCRIPTION_FIELD);
        map.put("PartialMatches", PARTIAL_MATCHES_FIELD);
        map.put("PossibleSecurityGroupRemediationActions", POSSIBLE_SECURITY_GROUP_REMEDIATION_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsVPCSecurityGroupViolation, T> g) {
        return obj -> g.apply((AwsVPCSecurityGroupViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationTarget;
        private String violationTargetDescription;
        private List<PartialMatch> partialMatches = DefaultSdkAutoConstructList.getInstance();
        private List<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsVPCSecurityGroupViolation model) {
            this.violationTarget(model.violationTarget);
            this.violationTargetDescription(model.violationTargetDescription);
            this.partialMatches(model.partialMatches);
            this.possibleSecurityGroupRemediationActions(model.possibleSecurityGroupRemediationActions);
        }

        public final String getViolationTarget() {
            return this.violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final String getViolationTargetDescription() {
            return this.violationTargetDescription;
        }

        public final void setViolationTargetDescription(String violationTargetDescription) {
            this.violationTargetDescription = violationTargetDescription;
        }

        @Override
        public final Builder violationTargetDescription(String violationTargetDescription) {
            this.violationTargetDescription = violationTargetDescription;
            return this;
        }

        public final List<PartialMatch.Builder> getPartialMatches() {
            List<PartialMatch.Builder> result = PartialMatchesCopier.copyToBuilder(this.partialMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartialMatches(Collection<PartialMatch.BuilderImpl> partialMatches) {
            this.partialMatches = PartialMatchesCopier.copyFromBuilder(partialMatches);
        }

        @Override
        public final Builder partialMatches(Collection<PartialMatch> partialMatches) {
            this.partialMatches = PartialMatchesCopier.copy(partialMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialMatches(PartialMatch ... partialMatches) {
            this.partialMatches(Arrays.asList(partialMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialMatches(Consumer<PartialMatch.Builder> ... partialMatches) {
            this.partialMatches(Stream.of(partialMatches).map(c -> (PartialMatch)((PartialMatch.Builder)PartialMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SecurityGroupRemediationAction.Builder> getPossibleSecurityGroupRemediationActions() {
            List<SecurityGroupRemediationAction.Builder> result = SecurityGroupRemediationActionsCopier.copyToBuilder(this.possibleSecurityGroupRemediationActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPossibleSecurityGroupRemediationActions(Collection<SecurityGroupRemediationAction.BuilderImpl> possibleSecurityGroupRemediationActions) {
            this.possibleSecurityGroupRemediationActions = SecurityGroupRemediationActionsCopier.copyFromBuilder(possibleSecurityGroupRemediationActions);
        }

        @Override
        public final Builder possibleSecurityGroupRemediationActions(Collection<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions) {
            this.possibleSecurityGroupRemediationActions = SecurityGroupRemediationActionsCopier.copy(possibleSecurityGroupRemediationActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder possibleSecurityGroupRemediationActions(SecurityGroupRemediationAction ... possibleSecurityGroupRemediationActions) {
            this.possibleSecurityGroupRemediationActions(Arrays.asList(possibleSecurityGroupRemediationActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder possibleSecurityGroupRemediationActions(Consumer<SecurityGroupRemediationAction.Builder> ... possibleSecurityGroupRemediationActions) {
            this.possibleSecurityGroupRemediationActions(Stream.of(possibleSecurityGroupRemediationActions).map(c -> (SecurityGroupRemediationAction)((SecurityGroupRemediationAction.Builder)SecurityGroupRemediationAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsVPCSecurityGroupViolation build() {
            return new AwsVPCSecurityGroupViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsVPCSecurityGroupViolation> {
        public Builder violationTarget(String var1);

        public Builder violationTargetDescription(String var1);

        public Builder partialMatches(Collection<PartialMatch> var1);

        public Builder partialMatches(PartialMatch ... var1);

        public Builder partialMatches(Consumer<PartialMatch.Builder> ... var1);

        public Builder possibleSecurityGroupRemediationActions(Collection<SecurityGroupRemediationAction> var1);

        public Builder possibleSecurityGroupRemediationActions(SecurityGroupRemediationAction ... var1);

        public Builder possibleSecurityGroupRemediationActions(Consumer<SecurityGroupRemediationAction.Builder> ... var1);
    }
}

