/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the <code>ReplaceNetworkAclAssociation</code> action in Amazon EC2. This is a remediation option in
 * <code>RemediationAction</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceNetworkAclAssociationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplaceNetworkAclAssociationAction.Builder, ReplaceNetworkAclAssociationAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ReplaceNetworkAclAssociationAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ActionTarget> ASSOCIATION_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("AssociationId").getter(getter(ReplaceNetworkAclAssociationAction::associationId))
            .setter(setter(Builder::associationId)).constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<ActionTarget> NETWORK_ACL_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkAclId").getter(getter(ReplaceNetworkAclAssociationAction::networkAclId))
            .setter(setter(Builder::networkAclId)).constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").build()).build();

    private static final SdkField<Boolean> FMS_CAN_REMEDIATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FMSCanRemediate").getter(getter(ReplaceNetworkAclAssociationAction::fmsCanRemediate))
            .setter(setter(Builder::fmsCanRemediate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FMSCanRemediate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ASSOCIATION_ID_FIELD, NETWORK_ACL_ID_FIELD, FMS_CAN_REMEDIATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final ActionTarget associationId;

    private final ActionTarget networkAclId;

    private final Boolean fmsCanRemediate;

    private ReplaceNetworkAclAssociationAction(BuilderImpl builder) {
        this.description = builder.description;
        this.associationId = builder.associationId;
        this.networkAclId = builder.networkAclId;
        this.fmsCanRemediate = builder.fmsCanRemediate;
    }

    /**
     * <p>
     * Brief description of this remediation action.
     * </p>
     * 
     * @return Brief description of this remediation action.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the AssociationId property for this object.
     * 
     * @return The value of the AssociationId property for this object.
     */
    public final ActionTarget associationId() {
        return associationId;
    }

    /**
     * <p>
     * The network ACL that's associated with the remediation action.
     * </p>
     * 
     * @return The network ACL that's associated with the remediation action.
     */
    public final ActionTarget networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value indicates
     * that auto remediation is disabled or Firewall Manager is unable to perform the action due to a conflict of some
     * kind.
     * </p>
     * 
     * @return Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value
     *         indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a
     *         conflict of some kind.
     */
    public final Boolean fmsCanRemediate() {
        return fmsCanRemediate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(fmsCanRemediate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclAssociationAction)) {
            return false;
        }
        ReplaceNetworkAclAssociationAction other = (ReplaceNetworkAclAssociationAction) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(networkAclId(), other.networkAclId())
                && Objects.equals(fmsCanRemediate(), other.fmsCanRemediate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplaceNetworkAclAssociationAction").add("Description", description())
                .add("AssociationId", associationId()).add("NetworkAclId", networkAclId())
                .add("FMSCanRemediate", fmsCanRemediate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "NetworkAclId":
            return Optional.ofNullable(clazz.cast(networkAclId()));
        case "FMSCanRemediate":
            return Optional.ofNullable(clazz.cast(fmsCanRemediate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("NetworkAclId", NETWORK_ACL_ID_FIELD);
        map.put("FMSCanRemediate", FMS_CAN_REMEDIATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplaceNetworkAclAssociationAction, T> g) {
        return obj -> g.apply((ReplaceNetworkAclAssociationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplaceNetworkAclAssociationAction> {
        /**
         * <p>
         * Brief description of this remediation action.
         * </p>
         * 
         * @param description
         *        Brief description of this remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the AssociationId property for this object.
         *
         * @param associationId
         *        The new value for the AssociationId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(ActionTarget associationId);

        /**
         * Sets the value of the AssociationId property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #associationId(ActionTarget)}.
         * 
         * @param associationId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationId(ActionTarget)
         */
        default Builder associationId(Consumer<ActionTarget.Builder> associationId) {
            return associationId(ActionTarget.builder().applyMutation(associationId).build());
        }

        /**
         * <p>
         * The network ACL that's associated with the remediation action.
         * </p>
         * 
         * @param networkAclId
         *        The network ACL that's associated with the remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(ActionTarget networkAclId);

        /**
         * <p>
         * The network ACL that's associated with the remediation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #networkAclId(ActionTarget)}.
         * 
         * @param networkAclId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAclId(ActionTarget)
         */
        default Builder networkAclId(Consumer<ActionTarget.Builder> networkAclId) {
            return networkAclId(ActionTarget.builder().applyMutation(networkAclId).build());
        }

        /**
         * <p>
         * Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value
         * indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a
         * conflict of some kind.
         * </p>
         * 
         * @param fmsCanRemediate
         *        Indicates whether it is possible for Firewall Manager to perform this remediation action. A false
         *        value indicates that auto remediation is disabled or Firewall Manager is unable to perform the action
         *        due to a conflict of some kind.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fmsCanRemediate(Boolean fmsCanRemediate);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private ActionTarget associationId;

        private ActionTarget networkAclId;

        private Boolean fmsCanRemediate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclAssociationAction model) {
            description(model.description);
            associationId(model.associationId);
            networkAclId(model.networkAclId);
            fmsCanRemediate(model.fmsCanRemediate);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getAssociationId() {
            return associationId != null ? associationId.toBuilder() : null;
        }

        public final void setAssociationId(ActionTarget.BuilderImpl associationId) {
            this.associationId = associationId != null ? associationId.build() : null;
        }

        @Override
        public final Builder associationId(ActionTarget associationId) {
            this.associationId = associationId;
            return this;
        }

        public final ActionTarget.Builder getNetworkAclId() {
            return networkAclId != null ? networkAclId.toBuilder() : null;
        }

        public final void setNetworkAclId(ActionTarget.BuilderImpl networkAclId) {
            this.networkAclId = networkAclId != null ? networkAclId.build() : null;
        }

        @Override
        public final Builder networkAclId(ActionTarget networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final Boolean getFmsCanRemediate() {
            return fmsCanRemediate;
        }

        public final void setFmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
        }

        @Override
        public final Builder fmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
            return this;
        }

        @Override
        public ReplaceNetworkAclAssociationAction build() {
            return new ReplaceNetworkAclAssociationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
