/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether the account is compliant with the specified policy. An account is considered noncompliant if it
 * includes resources that are not protected by the policy, for WAF and Shield Advanced policies, or that are
 * noncompliant with the policy, for security group policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyComplianceStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyComplianceStatus.Builder, PolicyComplianceStatus> {
    private static final SdkField<String> POLICY_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyOwner").getter(getter(PolicyComplianceStatus::policyOwner)).setter(setter(Builder::policyOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyOwner").build()).build();

    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(PolicyComplianceStatus::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(PolicyComplianceStatus::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> MEMBER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberAccount").getter(getter(PolicyComplianceStatus::memberAccount))
            .setter(setter(Builder::memberAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccount").build()).build();

    private static final SdkField<List<EvaluationResult>> EVALUATION_RESULTS_FIELD = SdkField
            .<List<EvaluationResult>> builder(MarshallingType.LIST)
            .memberName("EvaluationResults")
            .getter(getter(PolicyComplianceStatus::evaluationResults))
            .setter(setter(Builder::evaluationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(PolicyComplianceStatus::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<Map<String, String>> ISSUE_INFO_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("IssueInfoMap")
            .getter(getter(PolicyComplianceStatus::issueInfoMapAsStrings))
            .setter(setter(Builder::issueInfoMapWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueInfoMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_OWNER_FIELD,
            POLICY_ID_FIELD, POLICY_NAME_FIELD, MEMBER_ACCOUNT_FIELD, EVALUATION_RESULTS_FIELD, LAST_UPDATED_FIELD,
            ISSUE_INFO_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyOwner;

    private final String policyId;

    private final String policyName;

    private final String memberAccount;

    private final List<EvaluationResult> evaluationResults;

    private final Instant lastUpdated;

    private final Map<String, String> issueInfoMap;

    private PolicyComplianceStatus(BuilderImpl builder) {
        this.policyOwner = builder.policyOwner;
        this.policyId = builder.policyId;
        this.policyName = builder.policyName;
        this.memberAccount = builder.memberAccount;
        this.evaluationResults = builder.evaluationResults;
        this.lastUpdated = builder.lastUpdated;
        this.issueInfoMap = builder.issueInfoMap;
    }

    /**
     * <p>
     * The Amazon Web Services account that created the Firewall Manager policy.
     * </p>
     * 
     * @return The Amazon Web Services account that created the Firewall Manager policy.
     */
    public final String policyOwner() {
        return policyOwner;
    }

    /**
     * <p>
     * The ID of the Firewall Manager policy.
     * </p>
     * 
     * @return The ID of the Firewall Manager policy.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The name of the Firewall Manager policy.
     * </p>
     * 
     * @return The name of the Firewall Manager policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The member account ID.
     * </p>
     * 
     * @return The member account ID.
     */
    public final String memberAccount() {
        return memberAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluationResults property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluationResults() {
        return evaluationResults != null && !(evaluationResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>EvaluationResult</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluationResults} method.
     * </p>
     * 
     * @return An array of <code>EvaluationResult</code> objects.
     */
    public final List<EvaluationResult> evaluationResults() {
        return evaluationResults;
    }

    /**
     * <p>
     * Timestamp of the last update to the <code>EvaluationResult</code> objects.
     * </p>
     * 
     * @return Timestamp of the last update to the <code>EvaluationResult</code> objects.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * Details about problems with dependent services, such as WAF or Config, and the error message received that
     * indicates the problem with the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssueInfoMap} method.
     * </p>
     * 
     * @return Details about problems with dependent services, such as WAF or Config, and the error message received
     *         that indicates the problem with the service.
     */
    public final Map<DependentServiceName, String> issueInfoMap() {
        return IssueInfoMapCopier.copyStringToEnum(issueInfoMap);
    }

    /**
     * For responses, this returns true if the service returned a value for the IssueInfoMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIssueInfoMap() {
        return issueInfoMap != null && !(issueInfoMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details about problems with dependent services, such as WAF or Config, and the error message received that
     * indicates the problem with the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssueInfoMap} method.
     * </p>
     * 
     * @return Details about problems with dependent services, such as WAF or Config, and the error message received
     *         that indicates the problem with the service.
     */
    public final Map<String, String> issueInfoMapAsStrings() {
        return issueInfoMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyOwner());
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluationResults() ? evaluationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(hasIssueInfoMap() ? issueInfoMapAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyComplianceStatus)) {
            return false;
        }
        PolicyComplianceStatus other = (PolicyComplianceStatus) obj;
        return Objects.equals(policyOwner(), other.policyOwner()) && Objects.equals(policyId(), other.policyId())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(memberAccount(), other.memberAccount())
                && hasEvaluationResults() == other.hasEvaluationResults()
                && Objects.equals(evaluationResults(), other.evaluationResults())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && hasIssueInfoMap() == other.hasIssueInfoMap()
                && Objects.equals(issueInfoMapAsStrings(), other.issueInfoMapAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyComplianceStatus").add("PolicyOwner", policyOwner()).add("PolicyId", policyId())
                .add("PolicyName", policyName()).add("MemberAccount", memberAccount())
                .add("EvaluationResults", hasEvaluationResults() ? evaluationResults() : null).add("LastUpdated", lastUpdated())
                .add("IssueInfoMap", hasIssueInfoMap() ? issueInfoMapAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyOwner":
            return Optional.ofNullable(clazz.cast(policyOwner()));
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "MemberAccount":
            return Optional.ofNullable(clazz.cast(memberAccount()));
        case "EvaluationResults":
            return Optional.ofNullable(clazz.cast(evaluationResults()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "IssueInfoMap":
            return Optional.ofNullable(clazz.cast(issueInfoMapAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyOwner", POLICY_OWNER_FIELD);
        map.put("PolicyId", POLICY_ID_FIELD);
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("MemberAccount", MEMBER_ACCOUNT_FIELD);
        map.put("EvaluationResults", EVALUATION_RESULTS_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("IssueInfoMap", ISSUE_INFO_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyComplianceStatus, T> g) {
        return obj -> g.apply((PolicyComplianceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyComplianceStatus> {
        /**
         * <p>
         * The Amazon Web Services account that created the Firewall Manager policy.
         * </p>
         * 
         * @param policyOwner
         *        The Amazon Web Services account that created the Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyOwner(String policyOwner);

        /**
         * <p>
         * The ID of the Firewall Manager policy.
         * </p>
         * 
         * @param policyId
         *        The ID of the Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The name of the Firewall Manager policy.
         * </p>
         * 
         * @param policyName
         *        The name of the Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The member account ID.
         * </p>
         * 
         * @param memberAccount
         *        The member account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccount(String memberAccount);

        /**
         * <p>
         * An array of <code>EvaluationResult</code> objects.
         * </p>
         * 
         * @param evaluationResults
         *        An array of <code>EvaluationResult</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResults(Collection<EvaluationResult> evaluationResults);

        /**
         * <p>
         * An array of <code>EvaluationResult</code> objects.
         * </p>
         * 
         * @param evaluationResults
         *        An array of <code>EvaluationResult</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResults(EvaluationResult... evaluationResults);

        /**
         * <p>
         * An array of <code>EvaluationResult</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.EvaluationResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.fms.model.EvaluationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.EvaluationResult.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluationResults(List<EvaluationResult>)}.
         * 
         * @param evaluationResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.EvaluationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResults(java.util.Collection<EvaluationResult>)
         */
        Builder evaluationResults(Consumer<EvaluationResult.Builder>... evaluationResults);

        /**
         * <p>
         * Timestamp of the last update to the <code>EvaluationResult</code> objects.
         * </p>
         * 
         * @param lastUpdated
         *        Timestamp of the last update to the <code>EvaluationResult</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * Details about problems with dependent services, such as WAF or Config, and the error message received that
         * indicates the problem with the service.
         * </p>
         * 
         * @param issueInfoMap
         *        Details about problems with dependent services, such as WAF or Config, and the error message received
         *        that indicates the problem with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueInfoMapWithStrings(Map<String, String> issueInfoMap);

        /**
         * <p>
         * Details about problems with dependent services, such as WAF or Config, and the error message received that
         * indicates the problem with the service.
         * </p>
         * 
         * @param issueInfoMap
         *        Details about problems with dependent services, such as WAF or Config, and the error message received
         *        that indicates the problem with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueInfoMap(Map<DependentServiceName, String> issueInfoMap);
    }

    static final class BuilderImpl implements Builder {
        private String policyOwner;

        private String policyId;

        private String policyName;

        private String memberAccount;

        private List<EvaluationResult> evaluationResults = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdated;

        private Map<String, String> issueInfoMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyComplianceStatus model) {
            policyOwner(model.policyOwner);
            policyId(model.policyId);
            policyName(model.policyName);
            memberAccount(model.memberAccount);
            evaluationResults(model.evaluationResults);
            lastUpdated(model.lastUpdated);
            issueInfoMapWithStrings(model.issueInfoMap);
        }

        public final String getPolicyOwner() {
            return policyOwner;
        }

        public final void setPolicyOwner(String policyOwner) {
            this.policyOwner = policyOwner;
        }

        @Override
        public final Builder policyOwner(String policyOwner) {
            this.policyOwner = policyOwner;
            return this;
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getMemberAccount() {
            return memberAccount;
        }

        public final void setMemberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
        }

        @Override
        public final Builder memberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
            return this;
        }

        public final List<EvaluationResult.Builder> getEvaluationResults() {
            List<EvaluationResult.Builder> result = EvaluationResultsCopier.copyToBuilder(this.evaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationResults(Collection<EvaluationResult.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copyFromBuilder(evaluationResults);
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult... evaluationResults) {
            evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(Consumer<EvaluationResult.Builder>... evaluationResults) {
            evaluationResults(Stream.of(evaluationResults).map(c -> EvaluationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Map<String, String> getIssueInfoMap() {
            if (issueInfoMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return issueInfoMap;
        }

        public final void setIssueInfoMap(Map<String, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copy(issueInfoMap);
        }

        @Override
        public final Builder issueInfoMapWithStrings(Map<String, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copy(issueInfoMap);
            return this;
        }

        @Override
        public final Builder issueInfoMap(Map<DependentServiceName, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copyEnumToString(issueInfoMap);
            return this;
        }

        @Override
        public PolicyComplianceStatus build() {
            return new PolicyComplianceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
