/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for Network Firewall for an Availability Zone that's missing the expected Firewall Manager managed
 * subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallMissingSubnetViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFirewallMissingSubnetViolation.Builder, NetworkFirewallMissingSubnetViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(NetworkFirewallMissingSubnetViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<String> VPC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VPC")
            .getter(getter(NetworkFirewallMissingSubnetViolation::vpc)).setter(setter(Builder::vpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(NetworkFirewallMissingSubnetViolation::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> TARGET_VIOLATION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetViolationReason").getter(getter(NetworkFirewallMissingSubnetViolation::targetViolationReason))
            .setter(setter(Builder::targetViolationReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetViolationReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            VPC_FIELD, AVAILABILITY_ZONE_FIELD, TARGET_VIOLATION_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final String vpc;

    private final String availabilityZone;

    private final String targetViolationReason;

    private NetworkFirewallMissingSubnetViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.vpc = builder.vpc;
        this.availabilityZone = builder.availabilityZone;
        this.targetViolationReason = builder.targetViolationReason;
    }

    /**
     * <p>
     * The ID of the Network Firewall or VPC resource that's in violation.
     * </p>
     * 
     * @return The ID of the Network Firewall or VPC resource that's in violation.
     */
    public final String violationTarget() {
        return violationTarget;
    }

    /**
     * <p>
     * The resource ID of the VPC associated with a violating subnet.
     * </p>
     * 
     * @return The resource ID of the VPC associated with a violating subnet.
     */
    public final String vpc() {
        return vpc;
    }

    /**
     * <p>
     * The Availability Zone of a violating subnet.
     * </p>
     * 
     * @return The Availability Zone of a violating subnet.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The reason the resource has this violation, if one is available.
     * </p>
     * 
     * @return The reason the resource has this violation, if one is available.
     */
    public final String targetViolationReason() {
        return targetViolationReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(targetViolationReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallMissingSubnetViolation)) {
            return false;
        }
        NetworkFirewallMissingSubnetViolation other = (NetworkFirewallMissingSubnetViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget()) && Objects.equals(vpc(), other.vpc())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(targetViolationReason(), other.targetViolationReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFirewallMissingSubnetViolation").add("ViolationTarget", violationTarget())
                .add("VPC", vpc()).add("AvailabilityZone", availabilityZone())
                .add("TargetViolationReason", targetViolationReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "VPC":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "TargetViolationReason":
            return Optional.ofNullable(clazz.cast(targetViolationReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ViolationTarget", VIOLATION_TARGET_FIELD);
        map.put("VPC", VPC_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("TargetViolationReason", TARGET_VIOLATION_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallMissingSubnetViolation, T> g) {
        return obj -> g.apply((NetworkFirewallMissingSubnetViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallMissingSubnetViolation> {
        /**
         * <p>
         * The ID of the Network Firewall or VPC resource that's in violation.
         * </p>
         * 
         * @param violationTarget
         *        The ID of the Network Firewall or VPC resource that's in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * The resource ID of the VPC associated with a violating subnet.
         * </p>
         * 
         * @param vpc
         *        The resource ID of the VPC associated with a violating subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(String vpc);

        /**
         * <p>
         * The Availability Zone of a violating subnet.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of a violating subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The reason the resource has this violation, if one is available.
         * </p>
         * 
         * @param targetViolationReason
         *        The reason the resource has this violation, if one is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetViolationReason(String targetViolationReason);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private String vpc;

        private String availabilityZone;

        private String targetViolationReason;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallMissingSubnetViolation model) {
            violationTarget(model.violationTarget);
            vpc(model.vpc);
            availabilityZone(model.availabilityZone);
            targetViolationReason(model.targetViolationReason);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final String getVpc() {
            return vpc;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getTargetViolationReason() {
            return targetViolationReason;
        }

        public final void setTargetViolationReason(String targetViolationReason) {
            this.targetViolationReason = targetViolationReason;
        }

        @Override
        public final Builder targetViolationReason(String targetViolationReason) {
            this.targetViolationReason = targetViolationReason;
            return this;
        }

        @Override
        public NetworkFirewallMissingSubnetViolation build() {
            return new NetworkFirewallMissingSubnetViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
