/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for the subnet for which internet traffic that hasn't been inspected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallInternetTrafficNotInspectedViolation
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<NetworkFirewallInternetTrafficNotInspectedViolation.Builder, NetworkFirewallInternetTrafficNotInspectedViolation> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetAvailabilityZone")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::subnetAvailabilityZone))
            .setter(setter(Builder::subnetAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build())
            .build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId").getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("ViolatingRoutes")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::violatingRoutes))
            .setter(setter(Builder::violatingRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRouteTableUsedInDifferentAZ")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::isRouteTableUsedInDifferentAZ))
            .setter(setter(Builder::isRouteTableUsedInDifferentAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRouteTableUsedInDifferentAZ")
                    .build()).build();

    private static final SdkField<String> CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentFirewallSubnetRouteTable")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::currentFirewallSubnetRouteTable))
            .setter(setter(Builder::currentFirewallSubnetRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFirewallSubnetRouteTable")
                    .build()).build();

    private static final SdkField<String> EXPECTED_FIREWALL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedFirewallEndpoint")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::expectedFirewallEndpoint))
            .setter(setter(Builder::expectedFirewallEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallEndpoint").build())
            .build();

    private static final SdkField<String> FIREWALL_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallSubnetId").getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::firewallSubnetId))
            .setter(setter(Builder::firewallSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetId").build()).build();

    private static final SdkField<List<ExpectedRoute>> EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD = SdkField
            .<List<ExpectedRoute>> builder(MarshallingType.LIST)
            .memberName("ExpectedFirewallSubnetRoutes")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::expectedFirewallSubnetRoutes))
            .setter(setter(Builder::expectedFirewallSubnetRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallSubnetRoutes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Route>> ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("ActualFirewallSubnetRoutes")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::actualFirewallSubnetRoutes))
            .setter(setter(Builder::actualFirewallSubnetRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualFirewallSubnetRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INTERNET_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InternetGatewayId")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::internetGatewayId))
            .setter(setter(Builder::internetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayId").build()).build();

    private static final SdkField<String> CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentInternetGatewayRouteTable")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::currentInternetGatewayRouteTable))
            .setter(setter(Builder::currentInternetGatewayRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInternetGatewayRouteTable")
                    .build()).build();

    private static final SdkField<List<ExpectedRoute>> EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD = SdkField
            .<List<ExpectedRoute>> builder(MarshallingType.LIST)
            .memberName("ExpectedInternetGatewayRoutes")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::expectedInternetGatewayRoutes))
            .setter(setter(Builder::expectedInternetGatewayRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedInternetGatewayRoutes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Route>> ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("ActualInternetGatewayRoutes")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::actualInternetGatewayRoutes))
            .setter(setter(Builder::actualInternetGatewayRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualInternetGatewayRoutes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(NetworkFirewallInternetTrafficNotInspectedViolation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD,
            SUBNET_AVAILABILITY_ZONE_FIELD, ROUTE_TABLE_ID_FIELD, VIOLATING_ROUTES_FIELD,
            IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD, CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD,
            EXPECTED_FIREWALL_ENDPOINT_FIELD, FIREWALL_SUBNET_ID_FIELD, EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD,
            ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD, INTERNET_GATEWAY_ID_FIELD, CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD,
            EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD, ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final String subnetAvailabilityZone;

    private final String routeTableId;

    private final List<Route> violatingRoutes;

    private final Boolean isRouteTableUsedInDifferentAZ;

    private final String currentFirewallSubnetRouteTable;

    private final String expectedFirewallEndpoint;

    private final String firewallSubnetId;

    private final List<ExpectedRoute> expectedFirewallSubnetRoutes;

    private final List<Route> actualFirewallSubnetRoutes;

    private final String internetGatewayId;

    private final String currentInternetGatewayRouteTable;

    private final List<ExpectedRoute> expectedInternetGatewayRoutes;

    private final List<Route> actualInternetGatewayRoutes;

    private final String vpcId;

    private NetworkFirewallInternetTrafficNotInspectedViolation(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.routeTableId = builder.routeTableId;
        this.violatingRoutes = builder.violatingRoutes;
        this.isRouteTableUsedInDifferentAZ = builder.isRouteTableUsedInDifferentAZ;
        this.currentFirewallSubnetRouteTable = builder.currentFirewallSubnetRouteTable;
        this.expectedFirewallEndpoint = builder.expectedFirewallEndpoint;
        this.firewallSubnetId = builder.firewallSubnetId;
        this.expectedFirewallSubnetRoutes = builder.expectedFirewallSubnetRoutes;
        this.actualFirewallSubnetRoutes = builder.actualFirewallSubnetRoutes;
        this.internetGatewayId = builder.internetGatewayId;
        this.currentInternetGatewayRouteTable = builder.currentInternetGatewayRouteTable;
        this.expectedInternetGatewayRoutes = builder.expectedInternetGatewayRoutes;
        this.actualInternetGatewayRoutes = builder.actualInternetGatewayRoutes;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The subnet ID.
     * </p>
     * 
     * @return The subnet ID.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The subnet Availability Zone.
     * </p>
     * 
     * @return The subnet Availability Zone.
     */
    public final String subnetAvailabilityZone() {
        return subnetAvailabilityZone;
    }

    /**
     * <p>
     * Information about the route table ID.
     * </p>
     * 
     * @return Information about the route table ID.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViolatingRoutes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasViolatingRoutes() {
        return violatingRoutes != null && !(violatingRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The route or routes that are in violation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolatingRoutes} method.
     * </p>
     * 
     * @return The route or routes that are in violation.
     */
    public final List<Route> violatingRoutes() {
        return violatingRoutes;
    }

    /**
     * <p>
     * Information about whether the route table is used in another Availability Zone.
     * </p>
     * 
     * @return Information about whether the route table is used in another Availability Zone.
     */
    public final Boolean isRouteTableUsedInDifferentAZ() {
        return isRouteTableUsedInDifferentAZ;
    }

    /**
     * <p>
     * Information about the subnet route table for the current firewall.
     * </p>
     * 
     * @return Information about the subnet route table for the current firewall.
     */
    public final String currentFirewallSubnetRouteTable() {
        return currentFirewallSubnetRouteTable;
    }

    /**
     * <p>
     * The expected endpoint for the current firewall.
     * </p>
     * 
     * @return The expected endpoint for the current firewall.
     */
    public final String expectedFirewallEndpoint() {
        return expectedFirewallEndpoint;
    }

    /**
     * <p>
     * The firewall subnet ID.
     * </p>
     * 
     * @return The firewall subnet ID.
     */
    public final String firewallSubnetId() {
        return firewallSubnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedFirewallSubnetRoutes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedFirewallSubnetRoutes() {
        return expectedFirewallSubnetRoutes != null && !(expectedFirewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The firewall subnet routes that are expected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedFirewallSubnetRoutes} method.
     * </p>
     * 
     * @return The firewall subnet routes that are expected.
     */
    public final List<ExpectedRoute> expectedFirewallSubnetRoutes() {
        return expectedFirewallSubnetRoutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActualFirewallSubnetRoutes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasActualFirewallSubnetRoutes() {
        return actualFirewallSubnetRoutes != null && !(actualFirewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actual firewall subnet routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActualFirewallSubnetRoutes} method.
     * </p>
     * 
     * @return The actual firewall subnet routes.
     */
    public final List<Route> actualFirewallSubnetRoutes() {
        return actualFirewallSubnetRoutes;
    }

    /**
     * <p>
     * The internet gateway ID.
     * </p>
     * 
     * @return The internet gateway ID.
     */
    public final String internetGatewayId() {
        return internetGatewayId;
    }

    /**
     * <p>
     * The current route table for the internet gateway.
     * </p>
     * 
     * @return The current route table for the internet gateway.
     */
    public final String currentInternetGatewayRouteTable() {
        return currentInternetGatewayRouteTable;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedInternetGatewayRoutes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedInternetGatewayRoutes() {
        return expectedInternetGatewayRoutes != null && !(expectedInternetGatewayRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The internet gateway routes that are expected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedInternetGatewayRoutes} method.
     * </p>
     * 
     * @return The internet gateway routes that are expected.
     */
    public final List<ExpectedRoute> expectedInternetGatewayRoutes() {
        return expectedInternetGatewayRoutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActualInternetGatewayRoutes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasActualInternetGatewayRoutes() {
        return actualInternetGatewayRoutes != null && !(actualInternetGatewayRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actual internet gateway routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActualInternetGatewayRoutes} method.
     * </p>
     * 
     * @return The actual internet gateway routes.
     */
    public final List<Route> actualInternetGatewayRoutes() {
        return actualInternetGatewayRoutes;
    }

    /**
     * <p>
     * Information about the VPC ID.
     * </p>
     * 
     * @return Information about the VPC ID.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(hasViolatingRoutes() ? violatingRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isRouteTableUsedInDifferentAZ());
        hashCode = 31 * hashCode + Objects.hashCode(currentFirewallSubnetRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(expectedFirewallEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(firewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedFirewallSubnetRoutes() ? expectedFirewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActualFirewallSubnetRoutes() ? actualFirewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(currentInternetGatewayRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedInternetGatewayRoutes() ? expectedInternetGatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActualInternetGatewayRoutes() ? actualInternetGatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallInternetTrafficNotInspectedViolation)) {
            return false;
        }
        NetworkFirewallInternetTrafficNotInspectedViolation other = (NetworkFirewallInternetTrafficNotInspectedViolation) obj;
        return Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(subnetAvailabilityZone(), other.subnetAvailabilityZone())
                && Objects.equals(routeTableId(), other.routeTableId()) && hasViolatingRoutes() == other.hasViolatingRoutes()
                && Objects.equals(violatingRoutes(), other.violatingRoutes())
                && Objects.equals(isRouteTableUsedInDifferentAZ(), other.isRouteTableUsedInDifferentAZ())
                && Objects.equals(currentFirewallSubnetRouteTable(), other.currentFirewallSubnetRouteTable())
                && Objects.equals(expectedFirewallEndpoint(), other.expectedFirewallEndpoint())
                && Objects.equals(firewallSubnetId(), other.firewallSubnetId())
                && hasExpectedFirewallSubnetRoutes() == other.hasExpectedFirewallSubnetRoutes()
                && Objects.equals(expectedFirewallSubnetRoutes(), other.expectedFirewallSubnetRoutes())
                && hasActualFirewallSubnetRoutes() == other.hasActualFirewallSubnetRoutes()
                && Objects.equals(actualFirewallSubnetRoutes(), other.actualFirewallSubnetRoutes())
                && Objects.equals(internetGatewayId(), other.internetGatewayId())
                && Objects.equals(currentInternetGatewayRouteTable(), other.currentInternetGatewayRouteTable())
                && hasExpectedInternetGatewayRoutes() == other.hasExpectedInternetGatewayRoutes()
                && Objects.equals(expectedInternetGatewayRoutes(), other.expectedInternetGatewayRoutes())
                && hasActualInternetGatewayRoutes() == other.hasActualInternetGatewayRoutes()
                && Objects.equals(actualInternetGatewayRoutes(), other.actualInternetGatewayRoutes())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("NetworkFirewallInternetTrafficNotInspectedViolation")
                .add("SubnetId", subnetId())
                .add("SubnetAvailabilityZone", subnetAvailabilityZone())
                .add("RouteTableId", routeTableId())
                .add("ViolatingRoutes", hasViolatingRoutes() ? violatingRoutes() : null)
                .add("IsRouteTableUsedInDifferentAZ", isRouteTableUsedInDifferentAZ())
                .add("CurrentFirewallSubnetRouteTable", currentFirewallSubnetRouteTable())
                .add("ExpectedFirewallEndpoint", expectedFirewallEndpoint())
                .add("FirewallSubnetId", firewallSubnetId())
                .add("ExpectedFirewallSubnetRoutes", hasExpectedFirewallSubnetRoutes() ? expectedFirewallSubnetRoutes() : null)
                .add("ActualFirewallSubnetRoutes", hasActualFirewallSubnetRoutes() ? actualFirewallSubnetRoutes() : null)
                .add("InternetGatewayId", internetGatewayId())
                .add("CurrentInternetGatewayRouteTable", currentInternetGatewayRouteTable())
                .add("ExpectedInternetGatewayRoutes", hasExpectedInternetGatewayRoutes() ? expectedInternetGatewayRoutes() : null)
                .add("ActualInternetGatewayRoutes", hasActualInternetGatewayRoutes() ? actualInternetGatewayRoutes() : null)
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "SubnetAvailabilityZone":
            return Optional.ofNullable(clazz.cast(subnetAvailabilityZone()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "ViolatingRoutes":
            return Optional.ofNullable(clazz.cast(violatingRoutes()));
        case "IsRouteTableUsedInDifferentAZ":
            return Optional.ofNullable(clazz.cast(isRouteTableUsedInDifferentAZ()));
        case "CurrentFirewallSubnetRouteTable":
            return Optional.ofNullable(clazz.cast(currentFirewallSubnetRouteTable()));
        case "ExpectedFirewallEndpoint":
            return Optional.ofNullable(clazz.cast(expectedFirewallEndpoint()));
        case "FirewallSubnetId":
            return Optional.ofNullable(clazz.cast(firewallSubnetId()));
        case "ExpectedFirewallSubnetRoutes":
            return Optional.ofNullable(clazz.cast(expectedFirewallSubnetRoutes()));
        case "ActualFirewallSubnetRoutes":
            return Optional.ofNullable(clazz.cast(actualFirewallSubnetRoutes()));
        case "InternetGatewayId":
            return Optional.ofNullable(clazz.cast(internetGatewayId()));
        case "CurrentInternetGatewayRouteTable":
            return Optional.ofNullable(clazz.cast(currentInternetGatewayRouteTable()));
        case "ExpectedInternetGatewayRoutes":
            return Optional.ofNullable(clazz.cast(expectedInternetGatewayRoutes()));
        case "ActualInternetGatewayRoutes":
            return Optional.ofNullable(clazz.cast(actualInternetGatewayRoutes()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("ViolatingRoutes", VIOLATING_ROUTES_FIELD);
        map.put("IsRouteTableUsedInDifferentAZ", IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD);
        map.put("CurrentFirewallSubnetRouteTable", CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD);
        map.put("ExpectedFirewallEndpoint", EXPECTED_FIREWALL_ENDPOINT_FIELD);
        map.put("FirewallSubnetId", FIREWALL_SUBNET_ID_FIELD);
        map.put("ExpectedFirewallSubnetRoutes", EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD);
        map.put("ActualFirewallSubnetRoutes", ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD);
        map.put("InternetGatewayId", INTERNET_GATEWAY_ID_FIELD);
        map.put("CurrentInternetGatewayRouteTable", CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD);
        map.put("ExpectedInternetGatewayRoutes", EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD);
        map.put("ActualInternetGatewayRoutes", ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallInternetTrafficNotInspectedViolation, T> g) {
        return obj -> g.apply((NetworkFirewallInternetTrafficNotInspectedViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallInternetTrafficNotInspectedViolation> {
        /**
         * <p>
         * The subnet ID.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The subnet Availability Zone.
         * </p>
         * 
         * @param subnetAvailabilityZone
         *        The subnet Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetAvailabilityZone(String subnetAvailabilityZone);

        /**
         * <p>
         * Information about the route table ID.
         * </p>
         * 
         * @param routeTableId
         *        Information about the route table ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The route or routes that are in violation.
         * </p>
         * 
         * @param violatingRoutes
         *        The route or routes that are in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoutes(Collection<Route> violatingRoutes);

        /**
         * <p>
         * The route or routes that are in violation.
         * </p>
         * 
         * @param violatingRoutes
         *        The route or routes that are in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoutes(Route... violatingRoutes);

        /**
         * <p>
         * The route or routes that are in violation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.Route.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.Route.Builder#build()}
         * is called immediately and its result is passed to {@link #violatingRoutes(List<Route>)}.
         * 
         * @param violatingRoutes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violatingRoutes(java.util.Collection<Route>)
         */
        Builder violatingRoutes(Consumer<Route.Builder>... violatingRoutes);

        /**
         * <p>
         * Information about whether the route table is used in another Availability Zone.
         * </p>
         * 
         * @param isRouteTableUsedInDifferentAZ
         *        Information about whether the route table is used in another Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ);

        /**
         * <p>
         * Information about the subnet route table for the current firewall.
         * </p>
         * 
         * @param currentFirewallSubnetRouteTable
         *        Information about the subnet route table for the current firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable);

        /**
         * <p>
         * The expected endpoint for the current firewall.
         * </p>
         * 
         * @param expectedFirewallEndpoint
         *        The expected endpoint for the current firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedFirewallEndpoint(String expectedFirewallEndpoint);

        /**
         * <p>
         * The firewall subnet ID.
         * </p>
         * 
         * @param firewallSubnetId
         *        The firewall subnet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallSubnetId(String firewallSubnetId);

        /**
         * <p>
         * The firewall subnet routes that are expected.
         * </p>
         * 
         * @param expectedFirewallSubnetRoutes
         *        The firewall subnet routes that are expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedFirewallSubnetRoutes(Collection<ExpectedRoute> expectedFirewallSubnetRoutes);

        /**
         * <p>
         * The firewall subnet routes that are expected.
         * </p>
         * 
         * @param expectedFirewallSubnetRoutes
         *        The firewall subnet routes that are expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedFirewallSubnetRoutes(ExpectedRoute... expectedFirewallSubnetRoutes);

        /**
         * <p>
         * The firewall subnet routes that are expected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.ExpectedRoute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.fms.model.ExpectedRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.ExpectedRoute.Builder#build()} is called immediately and its
         * result is passed to {@link #expectedFirewallSubnetRoutes(List<ExpectedRoute>)}.
         * 
         * @param expectedFirewallSubnetRoutes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.ExpectedRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedFirewallSubnetRoutes(java.util.Collection<ExpectedRoute>)
         */
        Builder expectedFirewallSubnetRoutes(Consumer<ExpectedRoute.Builder>... expectedFirewallSubnetRoutes);

        /**
         * <p>
         * The actual firewall subnet routes.
         * </p>
         * 
         * @param actualFirewallSubnetRoutes
         *        The actual firewall subnet routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualFirewallSubnetRoutes(Collection<Route> actualFirewallSubnetRoutes);

        /**
         * <p>
         * The actual firewall subnet routes.
         * </p>
         * 
         * @param actualFirewallSubnetRoutes
         *        The actual firewall subnet routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualFirewallSubnetRoutes(Route... actualFirewallSubnetRoutes);

        /**
         * <p>
         * The actual firewall subnet routes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.Route.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.Route.Builder#build()}
         * is called immediately and its result is passed to {@link #actualFirewallSubnetRoutes(List<Route>)}.
         * 
         * @param actualFirewallSubnetRoutes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualFirewallSubnetRoutes(java.util.Collection<Route>)
         */
        Builder actualFirewallSubnetRoutes(Consumer<Route.Builder>... actualFirewallSubnetRoutes);

        /**
         * <p>
         * The internet gateway ID.
         * </p>
         * 
         * @param internetGatewayId
         *        The internet gateway ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayId(String internetGatewayId);

        /**
         * <p>
         * The current route table for the internet gateway.
         * </p>
         * 
         * @param currentInternetGatewayRouteTable
         *        The current route table for the internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable);

        /**
         * <p>
         * The internet gateway routes that are expected.
         * </p>
         * 
         * @param expectedInternetGatewayRoutes
         *        The internet gateway routes that are expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedInternetGatewayRoutes(Collection<ExpectedRoute> expectedInternetGatewayRoutes);

        /**
         * <p>
         * The internet gateway routes that are expected.
         * </p>
         * 
         * @param expectedInternetGatewayRoutes
         *        The internet gateway routes that are expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedInternetGatewayRoutes(ExpectedRoute... expectedInternetGatewayRoutes);

        /**
         * <p>
         * The internet gateway routes that are expected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.ExpectedRoute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.fms.model.ExpectedRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.ExpectedRoute.Builder#build()} is called immediately and its
         * result is passed to {@link #expectedInternetGatewayRoutes(List<ExpectedRoute>)}.
         * 
         * @param expectedInternetGatewayRoutes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.ExpectedRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedInternetGatewayRoutes(java.util.Collection<ExpectedRoute>)
         */
        Builder expectedInternetGatewayRoutes(Consumer<ExpectedRoute.Builder>... expectedInternetGatewayRoutes);

        /**
         * <p>
         * The actual internet gateway routes.
         * </p>
         * 
         * @param actualInternetGatewayRoutes
         *        The actual internet gateway routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualInternetGatewayRoutes(Collection<Route> actualInternetGatewayRoutes);

        /**
         * <p>
         * The actual internet gateway routes.
         * </p>
         * 
         * @param actualInternetGatewayRoutes
         *        The actual internet gateway routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualInternetGatewayRoutes(Route... actualInternetGatewayRoutes);

        /**
         * <p>
         * The actual internet gateway routes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.Route.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.Route.Builder#build()}
         * is called immediately and its result is passed to {@link #actualInternetGatewayRoutes(List<Route>)}.
         * 
         * @param actualInternetGatewayRoutes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualInternetGatewayRoutes(java.util.Collection<Route>)
         */
        Builder actualInternetGatewayRoutes(Consumer<Route.Builder>... actualInternetGatewayRoutes);

        /**
         * <p>
         * Information about the VPC ID.
         * </p>
         * 
         * @param vpcId
         *        Information about the VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private String subnetAvailabilityZone;

        private String routeTableId;

        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();

        private Boolean isRouteTableUsedInDifferentAZ;

        private String currentFirewallSubnetRouteTable;

        private String expectedFirewallEndpoint;

        private String firewallSubnetId;

        private List<ExpectedRoute> expectedFirewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();

        private List<Route> actualFirewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();

        private String internetGatewayId;

        private String currentInternetGatewayRouteTable;

        private List<ExpectedRoute> expectedInternetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();

        private List<Route> actualInternetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallInternetTrafficNotInspectedViolation model) {
            subnetId(model.subnetId);
            subnetAvailabilityZone(model.subnetAvailabilityZone);
            routeTableId(model.routeTableId);
            violatingRoutes(model.violatingRoutes);
            isRouteTableUsedInDifferentAZ(model.isRouteTableUsedInDifferentAZ);
            currentFirewallSubnetRouteTable(model.currentFirewallSubnetRouteTable);
            expectedFirewallEndpoint(model.expectedFirewallEndpoint);
            firewallSubnetId(model.firewallSubnetId);
            expectedFirewallSubnetRoutes(model.expectedFirewallSubnetRoutes);
            actualFirewallSubnetRoutes(model.actualFirewallSubnetRoutes);
            internetGatewayId(model.internetGatewayId);
            currentInternetGatewayRouteTable(model.currentInternetGatewayRouteTable);
            expectedInternetGatewayRoutes(model.expectedInternetGatewayRoutes);
            actualInternetGatewayRoutes(model.actualInternetGatewayRoutes);
            vpcId(model.vpcId);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getSubnetAvailabilityZone() {
            return subnetAvailabilityZone;
        }

        public final void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route... violatingRoutes) {
            violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder>... violatingRoutes) {
            violatingRoutes(Stream.of(violatingRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsRouteTableUsedInDifferentAZ() {
            return isRouteTableUsedInDifferentAZ;
        }

        public final void setIsRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ) {
            this.isRouteTableUsedInDifferentAZ = isRouteTableUsedInDifferentAZ;
        }

        @Override
        public final Builder isRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ) {
            this.isRouteTableUsedInDifferentAZ = isRouteTableUsedInDifferentAZ;
            return this;
        }

        public final String getCurrentFirewallSubnetRouteTable() {
            return currentFirewallSubnetRouteTable;
        }

        public final void setCurrentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
        }

        @Override
        public final Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
            return this;
        }

        public final String getExpectedFirewallEndpoint() {
            return expectedFirewallEndpoint;
        }

        public final void setExpectedFirewallEndpoint(String expectedFirewallEndpoint) {
            this.expectedFirewallEndpoint = expectedFirewallEndpoint;
        }

        @Override
        public final Builder expectedFirewallEndpoint(String expectedFirewallEndpoint) {
            this.expectedFirewallEndpoint = expectedFirewallEndpoint;
            return this;
        }

        public final String getFirewallSubnetId() {
            return firewallSubnetId;
        }

        public final void setFirewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
        }

        @Override
        public final Builder firewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
            return this;
        }

        public final List<ExpectedRoute.Builder> getExpectedFirewallSubnetRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedFirewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedFirewallSubnetRoutes(Collection<ExpectedRoute.BuilderImpl> expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedFirewallSubnetRoutes);
        }

        @Override
        public final Builder expectedFirewallSubnetRoutes(Collection<ExpectedRoute> expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes = ExpectedRoutesCopier.copy(expectedFirewallSubnetRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedFirewallSubnetRoutes(ExpectedRoute... expectedFirewallSubnetRoutes) {
            expectedFirewallSubnetRoutes(Arrays.asList(expectedFirewallSubnetRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedFirewallSubnetRoutes(Consumer<ExpectedRoute.Builder>... expectedFirewallSubnetRoutes) {
            expectedFirewallSubnetRoutes(Stream.of(expectedFirewallSubnetRoutes)
                    .map(c -> ExpectedRoute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Route.Builder> getActualFirewallSubnetRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.actualFirewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActualFirewallSubnetRoutes(Collection<Route.BuilderImpl> actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes = RoutesCopier.copyFromBuilder(actualFirewallSubnetRoutes);
        }

        @Override
        public final Builder actualFirewallSubnetRoutes(Collection<Route> actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes = RoutesCopier.copy(actualFirewallSubnetRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualFirewallSubnetRoutes(Route... actualFirewallSubnetRoutes) {
            actualFirewallSubnetRoutes(Arrays.asList(actualFirewallSubnetRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualFirewallSubnetRoutes(Consumer<Route.Builder>... actualFirewallSubnetRoutes) {
            actualFirewallSubnetRoutes(Stream.of(actualFirewallSubnetRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInternetGatewayId() {
            return internetGatewayId;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final String getCurrentInternetGatewayRouteTable() {
            return currentInternetGatewayRouteTable;
        }

        public final void setCurrentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
        }

        @Override
        public final Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
            return this;
        }

        public final List<ExpectedRoute.Builder> getExpectedInternetGatewayRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedInternetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedInternetGatewayRoutes(Collection<ExpectedRoute.BuilderImpl> expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedInternetGatewayRoutes);
        }

        @Override
        public final Builder expectedInternetGatewayRoutes(Collection<ExpectedRoute> expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes = ExpectedRoutesCopier.copy(expectedInternetGatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedInternetGatewayRoutes(ExpectedRoute... expectedInternetGatewayRoutes) {
            expectedInternetGatewayRoutes(Arrays.asList(expectedInternetGatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedInternetGatewayRoutes(Consumer<ExpectedRoute.Builder>... expectedInternetGatewayRoutes) {
            expectedInternetGatewayRoutes(Stream.of(expectedInternetGatewayRoutes)
                    .map(c -> ExpectedRoute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Route.Builder> getActualInternetGatewayRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.actualInternetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActualInternetGatewayRoutes(Collection<Route.BuilderImpl> actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes = RoutesCopier.copyFromBuilder(actualInternetGatewayRoutes);
        }

        @Override
        public final Builder actualInternetGatewayRoutes(Collection<Route> actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes = RoutesCopier.copy(actualInternetGatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualInternetGatewayRoutes(Route... actualInternetGatewayRoutes) {
            actualInternetGatewayRoutes(Arrays.asList(actualInternetGatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualInternetGatewayRoutes(Consumer<Route.Builder>... actualInternetGatewayRoutes) {
            actualInternetGatewayRoutes(Stream.of(actualInternetGatewayRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public NetworkFirewallInternetTrafficNotInspectedViolation build() {
            return new NetworkFirewallInternetTrafficNotInspectedViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
