/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for an internet gateway route with an inactive state in the customer subnet route table or Network
 * Firewall subnet route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallBlackHoleRouteDetectedViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFirewallBlackHoleRouteDetectedViolation.Builder, NetworkFirewallBlackHoleRouteDetectedViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(NetworkFirewallBlackHoleRouteDetectedViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId").getter(getter(NetworkFirewallBlackHoleRouteDetectedViolation::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(NetworkFirewallBlackHoleRouteDetectedViolation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("ViolatingRoutes")
            .getter(getter(NetworkFirewallBlackHoleRouteDetectedViolation::violatingRoutes))
            .setter(setter(Builder::violatingRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            ROUTE_TABLE_ID_FIELD, VPC_ID_FIELD, VIOLATING_ROUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final String routeTableId;

    private final String vpcId;

    private final List<Route> violatingRoutes;

    private NetworkFirewallBlackHoleRouteDetectedViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.routeTableId = builder.routeTableId;
        this.vpcId = builder.vpcId;
        this.violatingRoutes = builder.violatingRoutes;
    }

    /**
     * <p>
     * The subnet that has an inactive state.
     * </p>
     * 
     * @return The subnet that has an inactive state.
     */
    public final String violationTarget() {
        return violationTarget;
    }

    /**
     * <p>
     * Information about the route table ID.
     * </p>
     * 
     * @return Information about the route table ID.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * Information about the VPC ID.
     * </p>
     * 
     * @return Information about the VPC ID.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViolatingRoutes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasViolatingRoutes() {
        return violatingRoutes != null && !(violatingRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the route or routes that are in violation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolatingRoutes} method.
     * </p>
     * 
     * @return Information about the route or routes that are in violation.
     */
    public final List<Route> violatingRoutes() {
        return violatingRoutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasViolatingRoutes() ? violatingRoutes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallBlackHoleRouteDetectedViolation)) {
            return false;
        }
        NetworkFirewallBlackHoleRouteDetectedViolation other = (NetworkFirewallBlackHoleRouteDetectedViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget()) && Objects.equals(routeTableId(), other.routeTableId())
                && Objects.equals(vpcId(), other.vpcId()) && hasViolatingRoutes() == other.hasViolatingRoutes()
                && Objects.equals(violatingRoutes(), other.violatingRoutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFirewallBlackHoleRouteDetectedViolation").add("ViolationTarget", violationTarget())
                .add("RouteTableId", routeTableId()).add("VpcId", vpcId())
                .add("ViolatingRoutes", hasViolatingRoutes() ? violatingRoutes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ViolatingRoutes":
            return Optional.ofNullable(clazz.cast(violatingRoutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ViolationTarget", VIOLATION_TARGET_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("ViolatingRoutes", VIOLATING_ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallBlackHoleRouteDetectedViolation, T> g) {
        return obj -> g.apply((NetworkFirewallBlackHoleRouteDetectedViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallBlackHoleRouteDetectedViolation> {
        /**
         * <p>
         * The subnet that has an inactive state.
         * </p>
         * 
         * @param violationTarget
         *        The subnet that has an inactive state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * Information about the route table ID.
         * </p>
         * 
         * @param routeTableId
         *        Information about the route table ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * Information about the VPC ID.
         * </p>
         * 
         * @param vpcId
         *        Information about the VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Information about the route or routes that are in violation.
         * </p>
         * 
         * @param violatingRoutes
         *        Information about the route or routes that are in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoutes(Collection<Route> violatingRoutes);

        /**
         * <p>
         * Information about the route or routes that are in violation.
         * </p>
         * 
         * @param violatingRoutes
         *        Information about the route or routes that are in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoutes(Route... violatingRoutes);

        /**
         * <p>
         * Information about the route or routes that are in violation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.Route.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.Route.Builder#build()}
         * is called immediately and its result is passed to {@link #violatingRoutes(List<Route>)}.
         * 
         * @param violatingRoutes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violatingRoutes(java.util.Collection<Route>)
         */
        Builder violatingRoutes(Consumer<Route.Builder>... violatingRoutes);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private String routeTableId;

        private String vpcId;

        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallBlackHoleRouteDetectedViolation model) {
            violationTarget(model.violationTarget);
            routeTableId(model.routeTableId);
            vpcId(model.vpcId);
            violatingRoutes(model.violatingRoutes);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route... violatingRoutes) {
            violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder>... violatingRoutes) {
            violatingRoutes(Stream.of(violatingRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public NetworkFirewallBlackHoleRouteDetectedViolation build() {
            return new NetworkFirewallBlackHoleRouteDetectedViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
