/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a resource that failed when trying to update it's association to a resource set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedItem implements SdkPojo, Serializable, ToCopyableBuilder<FailedItem.Builder, FailedItem> {
    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("URI")
            .getter(getter(FailedItem::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URI").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(FailedItem::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String uri;

    private final String reason;

    private FailedItem(BuilderImpl builder) {
        this.uri = builder.uri;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The univeral resource indicator (URI) of the resource that failed.
     * </p>
     * 
     * @return The univeral resource indicator (URI) of the resource that failed.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The reason the resource's association could not be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link FailedItemReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason the resource's association could not be updated.
     * @see FailedItemReason
     */
    public final FailedItemReason reason() {
        return FailedItemReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason the resource's association could not be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link FailedItemReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason the resource's association could not be updated.
     * @see FailedItemReason
     */
    public final String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedItem)) {
            return false;
        }
        FailedItem other = (FailedItem) obj;
        return Objects.equals(uri(), other.uri()) && Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedItem").add("URI", uri()).add("Reason", reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "URI":
            return Optional.ofNullable(clazz.cast(uri()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("URI", URI_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedItem, T> g) {
        return obj -> g.apply((FailedItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedItem> {
        /**
         * <p>
         * The univeral resource indicator (URI) of the resource that failed.
         * </p>
         * 
         * @param uri
         *        The univeral resource indicator (URI) of the resource that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The reason the resource's association could not be updated.
         * </p>
         * 
         * @param reason
         *        The reason the resource's association could not be updated.
         * @see FailedItemReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailedItemReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason the resource's association could not be updated.
         * </p>
         * 
         * @param reason
         *        The reason the resource's association could not be updated.
         * @see FailedItemReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailedItemReason
         */
        Builder reason(FailedItemReason reason);
    }

    static final class BuilderImpl implements Builder {
        private String uri;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedItem model) {
            uri(model.uri);
            reason(model.reason);
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(FailedItemReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public FailedItem build() {
            return new FailedItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
