/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the <code>DeleteNetworkAclEntries</code> action in Amazon EC2. This is a remediation option in
 * <code>RemediationAction</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteNetworkAclEntriesAction implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteNetworkAclEntriesAction.Builder, DeleteNetworkAclEntriesAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DeleteNetworkAclEntriesAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ActionTarget> NETWORK_ACL_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkAclId").getter(getter(DeleteNetworkAclEntriesAction::networkAclId))
            .setter(setter(Builder::networkAclId)).constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").build()).build();

    private static final SdkField<List<EntryDescription>> NETWORK_ACL_ENTRIES_TO_BE_DELETED_FIELD = SdkField
            .<List<EntryDescription>> builder(MarshallingType.LIST)
            .memberName("NetworkAclEntriesToBeDeleted")
            .getter(getter(DeleteNetworkAclEntriesAction::networkAclEntriesToBeDeleted))
            .setter(setter(Builder::networkAclEntriesToBeDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclEntriesToBeDeleted")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntryDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntryDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> FMS_CAN_REMEDIATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FMSCanRemediate").getter(getter(DeleteNetworkAclEntriesAction::fmsCanRemediate))
            .setter(setter(Builder::fmsCanRemediate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FMSCanRemediate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            NETWORK_ACL_ID_FIELD, NETWORK_ACL_ENTRIES_TO_BE_DELETED_FIELD, FMS_CAN_REMEDIATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final ActionTarget networkAclId;

    private final List<EntryDescription> networkAclEntriesToBeDeleted;

    private final Boolean fmsCanRemediate;

    private DeleteNetworkAclEntriesAction(BuilderImpl builder) {
        this.description = builder.description;
        this.networkAclId = builder.networkAclId;
        this.networkAclEntriesToBeDeleted = builder.networkAclEntriesToBeDeleted;
        this.fmsCanRemediate = builder.fmsCanRemediate;
    }

    /**
     * <p>
     * Brief description of this remediation action.
     * </p>
     * 
     * @return Brief description of this remediation action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The network ACL that's associated with the remediation action.
     * </p>
     * 
     * @return The network ACL that's associated with the remediation action.
     */
    public final ActionTarget networkAclId() {
        return networkAclId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkAclEntriesToBeDeleted property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkAclEntriesToBeDeleted() {
        return networkAclEntriesToBeDeleted != null && !(networkAclEntriesToBeDeleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the entries that the remediation action would delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkAclEntriesToBeDeleted} method.
     * </p>
     * 
     * @return Lists the entries that the remediation action would delete.
     */
    public final List<EntryDescription> networkAclEntriesToBeDeleted() {
        return networkAclEntriesToBeDeleted;
    }

    /**
     * <p>
     * Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value indicates
     * that auto remediation is disabled or Firewall Manager is unable to perform the action due to a conflict of some
     * kind.
     * </p>
     * 
     * @return Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value
     *         indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a
     *         conflict of some kind.
     */
    public final Boolean fmsCanRemediate() {
        return fmsCanRemediate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkAclEntriesToBeDeleted() ? networkAclEntriesToBeDeleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fmsCanRemediate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkAclEntriesAction)) {
            return false;
        }
        DeleteNetworkAclEntriesAction other = (DeleteNetworkAclEntriesAction) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(networkAclId(), other.networkAclId())
                && hasNetworkAclEntriesToBeDeleted() == other.hasNetworkAclEntriesToBeDeleted()
                && Objects.equals(networkAclEntriesToBeDeleted(), other.networkAclEntriesToBeDeleted())
                && Objects.equals(fmsCanRemediate(), other.fmsCanRemediate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteNetworkAclEntriesAction").add("Description", description())
                .add("NetworkAclId", networkAclId())
                .add("NetworkAclEntriesToBeDeleted", hasNetworkAclEntriesToBeDeleted() ? networkAclEntriesToBeDeleted() : null)
                .add("FMSCanRemediate", fmsCanRemediate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NetworkAclId":
            return Optional.ofNullable(clazz.cast(networkAclId()));
        case "NetworkAclEntriesToBeDeleted":
            return Optional.ofNullable(clazz.cast(networkAclEntriesToBeDeleted()));
        case "FMSCanRemediate":
            return Optional.ofNullable(clazz.cast(fmsCanRemediate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("NetworkAclId", NETWORK_ACL_ID_FIELD);
        map.put("NetworkAclEntriesToBeDeleted", NETWORK_ACL_ENTRIES_TO_BE_DELETED_FIELD);
        map.put("FMSCanRemediate", FMS_CAN_REMEDIATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkAclEntriesAction, T> g) {
        return obj -> g.apply((DeleteNetworkAclEntriesAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteNetworkAclEntriesAction> {
        /**
         * <p>
         * Brief description of this remediation action.
         * </p>
         * 
         * @param description
         *        Brief description of this remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The network ACL that's associated with the remediation action.
         * </p>
         * 
         * @param networkAclId
         *        The network ACL that's associated with the remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(ActionTarget networkAclId);

        /**
         * <p>
         * The network ACL that's associated with the remediation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #networkAclId(ActionTarget)}.
         * 
         * @param networkAclId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAclId(ActionTarget)
         */
        default Builder networkAclId(Consumer<ActionTarget.Builder> networkAclId) {
            return networkAclId(ActionTarget.builder().applyMutation(networkAclId).build());
        }

        /**
         * <p>
         * Lists the entries that the remediation action would delete.
         * </p>
         * 
         * @param networkAclEntriesToBeDeleted
         *        Lists the entries that the remediation action would delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclEntriesToBeDeleted(Collection<EntryDescription> networkAclEntriesToBeDeleted);

        /**
         * <p>
         * Lists the entries that the remediation action would delete.
         * </p>
         * 
         * @param networkAclEntriesToBeDeleted
         *        Lists the entries that the remediation action would delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclEntriesToBeDeleted(EntryDescription... networkAclEntriesToBeDeleted);

        /**
         * <p>
         * Lists the entries that the remediation action would delete.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.EntryDescription.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.fms.model.EntryDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.EntryDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #networkAclEntriesToBeDeleted(List<EntryDescription>)}.
         * 
         * @param networkAclEntriesToBeDeleted
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.EntryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAclEntriesToBeDeleted(java.util.Collection<EntryDescription>)
         */
        Builder networkAclEntriesToBeDeleted(Consumer<EntryDescription.Builder>... networkAclEntriesToBeDeleted);

        /**
         * <p>
         * Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value
         * indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a
         * conflict of some kind.
         * </p>
         * 
         * @param fmsCanRemediate
         *        Indicates whether it is possible for Firewall Manager to perform this remediation action. A false
         *        value indicates that auto remediation is disabled or Firewall Manager is unable to perform the action
         *        due to a conflict of some kind.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fmsCanRemediate(Boolean fmsCanRemediate);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private ActionTarget networkAclId;

        private List<EntryDescription> networkAclEntriesToBeDeleted = DefaultSdkAutoConstructList.getInstance();

        private Boolean fmsCanRemediate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkAclEntriesAction model) {
            description(model.description);
            networkAclId(model.networkAclId);
            networkAclEntriesToBeDeleted(model.networkAclEntriesToBeDeleted);
            fmsCanRemediate(model.fmsCanRemediate);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getNetworkAclId() {
            return networkAclId != null ? networkAclId.toBuilder() : null;
        }

        public final void setNetworkAclId(ActionTarget.BuilderImpl networkAclId) {
            this.networkAclId = networkAclId != null ? networkAclId.build() : null;
        }

        @Override
        public final Builder networkAclId(ActionTarget networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final List<EntryDescription.Builder> getNetworkAclEntriesToBeDeleted() {
            List<EntryDescription.Builder> result = EntriesDescriptionCopier.copyToBuilder(this.networkAclEntriesToBeDeleted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkAclEntriesToBeDeleted(Collection<EntryDescription.BuilderImpl> networkAclEntriesToBeDeleted) {
            this.networkAclEntriesToBeDeleted = EntriesDescriptionCopier.copyFromBuilder(networkAclEntriesToBeDeleted);
        }

        @Override
        public final Builder networkAclEntriesToBeDeleted(Collection<EntryDescription> networkAclEntriesToBeDeleted) {
            this.networkAclEntriesToBeDeleted = EntriesDescriptionCopier.copy(networkAclEntriesToBeDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAclEntriesToBeDeleted(EntryDescription... networkAclEntriesToBeDeleted) {
            networkAclEntriesToBeDeleted(Arrays.asList(networkAclEntriesToBeDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAclEntriesToBeDeleted(Consumer<EntryDescription.Builder>... networkAclEntriesToBeDeleted) {
            networkAclEntriesToBeDeleted(Stream.of(networkAclEntriesToBeDeleted)
                    .map(c -> EntryDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getFmsCanRemediate() {
            return fmsCanRemediate;
        }

        public final void setFmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
        }

        @Override
        public final Builder fmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
            return this;
        }

        @Override
        public DeleteNetworkAclEntriesAction build() {
            return new DeleteNetworkAclEntriesAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
