/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the <code>CreateNetworkAcl</code> action in Amazon EC2. This is a remediation option in
 * <code>RemediationAction</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkAclAction implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateNetworkAclAction.Builder, CreateNetworkAclAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateNetworkAclAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ActionTarget> VPC_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("Vpc").getter(getter(CreateNetworkAclAction::vpc)).setter(setter(Builder::vpc))
            .constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()).build();

    private static final SdkField<Boolean> FMS_CAN_REMEDIATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FMSCanRemediate").getter(getter(CreateNetworkAclAction::fmsCanRemediate))
            .setter(setter(Builder::fmsCanRemediate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FMSCanRemediate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, VPC_FIELD,
            FMS_CAN_REMEDIATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final ActionTarget vpc;

    private final Boolean fmsCanRemediate;

    private CreateNetworkAclAction(BuilderImpl builder) {
        this.description = builder.description;
        this.vpc = builder.vpc;
        this.fmsCanRemediate = builder.fmsCanRemediate;
    }

    /**
     * <p>
     * Brief description of this remediation action.
     * </p>
     * 
     * @return Brief description of this remediation action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The VPC that's associated with the remediation action.
     * </p>
     * 
     * @return The VPC that's associated with the remediation action.
     */
    public final ActionTarget vpc() {
        return vpc;
    }

    /**
     * <p>
     * Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value indicates
     * that auto remediation is disabled or Firewall Manager is unable to perform the action due to a conflict of some
     * kind.
     * </p>
     * 
     * @return Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value
     *         indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a
     *         conflict of some kind.
     */
    public final Boolean fmsCanRemediate() {
        return fmsCanRemediate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(fmsCanRemediate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAclAction)) {
            return false;
        }
        CreateNetworkAclAction other = (CreateNetworkAclAction) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(vpc(), other.vpc())
                && Objects.equals(fmsCanRemediate(), other.fmsCanRemediate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkAclAction").add("Description", description()).add("Vpc", vpc())
                .add("FMSCanRemediate", fmsCanRemediate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "FMSCanRemediate":
            return Optional.ofNullable(clazz.cast(fmsCanRemediate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Vpc", VPC_FIELD);
        map.put("FMSCanRemediate", FMS_CAN_REMEDIATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkAclAction, T> g) {
        return obj -> g.apply((CreateNetworkAclAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateNetworkAclAction> {
        /**
         * <p>
         * Brief description of this remediation action.
         * </p>
         * 
         * @param description
         *        Brief description of this remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The VPC that's associated with the remediation action.
         * </p>
         * 
         * @param vpc
         *        The VPC that's associated with the remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(ActionTarget vpc);

        /**
         * <p>
         * The VPC that's associated with the remediation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #vpc(ActionTarget)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(ActionTarget)
         */
        default Builder vpc(Consumer<ActionTarget.Builder> vpc) {
            return vpc(ActionTarget.builder().applyMutation(vpc).build());
        }

        /**
         * <p>
         * Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value
         * indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a
         * conflict of some kind.
         * </p>
         * 
         * @param fmsCanRemediate
         *        Indicates whether it is possible for Firewall Manager to perform this remediation action. A false
         *        value indicates that auto remediation is disabled or Firewall Manager is unable to perform the action
         *        due to a conflict of some kind.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fmsCanRemediate(Boolean fmsCanRemediate);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private ActionTarget vpc;

        private Boolean fmsCanRemediate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAclAction model) {
            description(model.description);
            vpc(model.vpc);
            fmsCanRemediate(model.fmsCanRemediate);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(ActionTarget.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(ActionTarget vpc) {
            this.vpc = vpc;
            return this;
        }

        public final Boolean getFmsCanRemediate() {
            return fmsCanRemediate;
        }

        public final void setFmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
        }

        @Override
        public final Builder fmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
            return this;
        }

        @Override
        public CreateNetworkAclAction build() {
            return new CreateNetworkAclAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
