/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateResourceRequest extends FmsRequest implements
        ToCopyableBuilder<BatchDisassociateResourceRequest.Builder, BatchDisassociateResourceRequest> {
    private static final SdkField<String> RESOURCE_SET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSetIdentifier").getter(getter(BatchDisassociateResourceRequest::resourceSetIdentifier))
            .setter(setter(Builder::resourceSetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetIdentifier").build())
            .build();

    private static final SdkField<List<String>> ITEMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(BatchDisassociateResourceRequest::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_IDENTIFIER_FIELD,
            ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceSetIdentifier;

    private final List<String> items;

    private BatchDisassociateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceSetIdentifier = builder.resourceSetIdentifier;
        this.items = builder.items;
    }

    /**
     * <p>
     * A unique identifier for the resource set, used in a request to refer to the resource set.
     * </p>
     * 
     * @return A unique identifier for the resource set, used in a request to refer to the resource set.
     */
    public final String resourceSetIdentifier() {
        return resourceSetIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The uniform resource identifiers (URI) of resources that should be disassociated from the resource set. The URIs
     * must be Amazon Resource Names (ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The uniform resource identifiers (URI) of resources that should be disassociated from the resource set.
     *         The URIs must be Amazon Resource Names (ARNs).
     */
    public final List<String> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateResourceRequest)) {
            return false;
        }
        BatchDisassociateResourceRequest other = (BatchDisassociateResourceRequest) obj;
        return Objects.equals(resourceSetIdentifier(), other.resourceSetIdentifier()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDisassociateResourceRequest").add("ResourceSetIdentifier", resourceSetIdentifier())
                .add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceSetIdentifier":
            return Optional.ofNullable(clazz.cast(resourceSetIdentifier()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceSetIdentifier", RESOURCE_SET_IDENTIFIER_FIELD);
        map.put("Items", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateResourceRequest, T> g) {
        return obj -> g.apply((BatchDisassociateResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDisassociateResourceRequest> {
        /**
         * <p>
         * A unique identifier for the resource set, used in a request to refer to the resource set.
         * </p>
         * 
         * @param resourceSetIdentifier
         *        A unique identifier for the resource set, used in a request to refer to the resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSetIdentifier(String resourceSetIdentifier);

        /**
         * <p>
         * The uniform resource identifiers (URI) of resources that should be disassociated from the resource set. The
         * URIs must be Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param items
         *        The uniform resource identifiers (URI) of resources that should be disassociated from the resource
         *        set. The URIs must be Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<String> items);

        /**
         * <p>
         * The uniform resource identifiers (URI) of resources that should be disassociated from the resource set. The
         * URIs must be Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param items
         *        The uniform resource identifiers (URI) of resources that should be disassociated from the resource
         *        set. The URIs must be Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(String... items);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String resourceSetIdentifier;

        private List<String> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateResourceRequest model) {
            super(model);
            resourceSetIdentifier(model.resourceSetIdentifier);
            items(model.items);
        }

        public final String getResourceSetIdentifier() {
            return resourceSetIdentifier;
        }

        public final void setResourceSetIdentifier(String resourceSetIdentifier) {
            this.resourceSetIdentifier = resourceSetIdentifier;
        }

        @Override
        public final Builder resourceSetIdentifier(String resourceSetIdentifier) {
            this.resourceSetIdentifier = resourceSetIdentifier;
            return this;
        }

        public final Collection<String> getItems() {
            if (items instanceof SdkAutoConstructList) {
                return null;
            }
            return items;
        }

        public final void setItems(Collection<String> items) {
            this.items = IdentifierListCopier.copy(items);
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = IdentifierListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisassociateResourceRequest build() {
            return new BatchDisassociateResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
