/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Firewall Manager applications list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppsListData implements SdkPojo, Serializable, ToCopyableBuilder<AppsListData.Builder, AppsListData> {
    private static final SdkField<String> LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ListId")
            .getter(getter(AppsListData::listId)).setter(setter(Builder::listId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()).build();

    private static final SdkField<String> LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListName").getter(getter(AppsListData::listName)).setter(setter(Builder::listName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()).build();

    private static final SdkField<String> LIST_UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListUpdateToken").getter(getter(AppsListData::listUpdateToken)).setter(setter(Builder::listUpdateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListUpdateToken").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(AppsListData::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(AppsListData::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<List<App>> APPS_LIST_FIELD = SdkField
            .<List<App>> builder(MarshallingType.LIST)
            .memberName("AppsList")
            .getter(getter(AppsListData::appsList))
            .setter(setter(Builder::appsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<App> builder(MarshallingType.SDK_POJO)
                                            .constructor(App::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<App>>> PREVIOUS_APPS_LIST_FIELD = SdkField
            .<Map<String, List<App>>> builder(MarshallingType.MAP)
            .memberName("PreviousAppsList")
            .getter(getter(AppsListData::previousAppsList))
            .setter(setter(Builder::previousAppsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousAppsList").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<App>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<App> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(App::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ID_FIELD,
            LIST_NAME_FIELD, LIST_UPDATE_TOKEN_FIELD, CREATE_TIME_FIELD, LAST_UPDATE_TIME_FIELD, APPS_LIST_FIELD,
            PREVIOUS_APPS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String listId;

    private final String listName;

    private final String listUpdateToken;

    private final Instant createTime;

    private final Instant lastUpdateTime;

    private final List<App> appsList;

    private final Map<String, List<App>> previousAppsList;

    private AppsListData(BuilderImpl builder) {
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.listUpdateToken = builder.listUpdateToken;
        this.createTime = builder.createTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.appsList = builder.appsList;
        this.previousAppsList = builder.previousAppsList;
    }

    /**
     * <p>
     * The ID of the Firewall Manager applications list.
     * </p>
     * 
     * @return The ID of the Firewall Manager applications list.
     */
    public final String listId() {
        return listId;
    }

    /**
     * <p>
     * The name of the Firewall Manager applications list.
     * </p>
     * 
     * @return The name of the Firewall Manager applications list.
     */
    public final String listName() {
        return listName;
    }

    /**
     * <p>
     * A unique identifier for each update to the list. When you update the list, the update token must match the token
     * of the current version of the application list. You can retrieve the update token by getting the list.
     * </p>
     * 
     * @return A unique identifier for each update to the list. When you update the list, the update token must match
     *         the token of the current version of the application list. You can retrieve the update token by getting
     *         the list.
     */
    public final String listUpdateToken() {
        return listUpdateToken;
    }

    /**
     * <p>
     * The time that the Firewall Manager applications list was created.
     * </p>
     * 
     * @return The time that the Firewall Manager applications list was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time that the Firewall Manager applications list was last updated.
     * </p>
     * 
     * @return The time that the Firewall Manager applications list was last updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppsList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAppsList() {
        return appsList != null && !(appsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of applications in the Firewall Manager applications list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppsList} method.
     * </p>
     * 
     * @return An array of applications in the Firewall Manager applications list.
     */
    public final List<App> appsList() {
        return appsList;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreviousAppsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPreviousAppsList() {
        return previousAppsList != null && !(previousAppsList instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of previous version numbers to their corresponding <code>App</code> object arrays.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreviousAppsList} method.
     * </p>
     * 
     * @return A map of previous version numbers to their corresponding <code>App</code> object arrays.
     */
    public final Map<String, List<App>> previousAppsList() {
        return previousAppsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listId());
        hashCode = 31 * hashCode + Objects.hashCode(listName());
        hashCode = 31 * hashCode + Objects.hashCode(listUpdateToken());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppsList() ? appsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPreviousAppsList() ? previousAppsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppsListData)) {
            return false;
        }
        AppsListData other = (AppsListData) obj;
        return Objects.equals(listId(), other.listId()) && Objects.equals(listName(), other.listName())
                && Objects.equals(listUpdateToken(), other.listUpdateToken()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && hasAppsList() == other.hasAppsList()
                && Objects.equals(appsList(), other.appsList()) && hasPreviousAppsList() == other.hasPreviousAppsList()
                && Objects.equals(previousAppsList(), other.previousAppsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppsListData").add("ListId", listId()).add("ListName", listName())
                .add("ListUpdateToken", listUpdateToken()).add("CreateTime", createTime())
                .add("LastUpdateTime", lastUpdateTime()).add("AppsList", hasAppsList() ? appsList() : null)
                .add("PreviousAppsList", hasPreviousAppsList() ? previousAppsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListId":
            return Optional.ofNullable(clazz.cast(listId()));
        case "ListName":
            return Optional.ofNullable(clazz.cast(listName()));
        case "ListUpdateToken":
            return Optional.ofNullable(clazz.cast(listUpdateToken()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "AppsList":
            return Optional.ofNullable(clazz.cast(appsList()));
        case "PreviousAppsList":
            return Optional.ofNullable(clazz.cast(previousAppsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ListId", LIST_ID_FIELD);
        map.put("ListName", LIST_NAME_FIELD);
        map.put("ListUpdateToken", LIST_UPDATE_TOKEN_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("AppsList", APPS_LIST_FIELD);
        map.put("PreviousAppsList", PREVIOUS_APPS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppsListData, T> g) {
        return obj -> g.apply((AppsListData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppsListData> {
        /**
         * <p>
         * The ID of the Firewall Manager applications list.
         * </p>
         * 
         * @param listId
         *        The ID of the Firewall Manager applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listId(String listId);

        /**
         * <p>
         * The name of the Firewall Manager applications list.
         * </p>
         * 
         * @param listName
         *        The name of the Firewall Manager applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listName(String listName);

        /**
         * <p>
         * A unique identifier for each update to the list. When you update the list, the update token must match the
         * token of the current version of the application list. You can retrieve the update token by getting the list.
         * </p>
         * 
         * @param listUpdateToken
         *        A unique identifier for each update to the list. When you update the list, the update token must match
         *        the token of the current version of the application list. You can retrieve the update token by getting
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listUpdateToken(String listUpdateToken);

        /**
         * <p>
         * The time that the Firewall Manager applications list was created.
         * </p>
         * 
         * @param createTime
         *        The time that the Firewall Manager applications list was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time that the Firewall Manager applications list was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time that the Firewall Manager applications list was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * An array of applications in the Firewall Manager applications list.
         * </p>
         * 
         * @param appsList
         *        An array of applications in the Firewall Manager applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsList(Collection<App> appsList);

        /**
         * <p>
         * An array of applications in the Firewall Manager applications list.
         * </p>
         * 
         * @param appsList
         *        An array of applications in the Firewall Manager applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsList(App... appsList);

        /**
         * <p>
         * An array of applications in the Firewall Manager applications list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.App.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.App#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.App.Builder#build()} is
         * called immediately and its result is passed to {@link #appsList(List<App>)}.
         * 
         * @param appsList
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.App.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appsList(java.util.Collection<App>)
         */
        Builder appsList(Consumer<App.Builder>... appsList);

        /**
         * <p>
         * A map of previous version numbers to their corresponding <code>App</code> object arrays.
         * </p>
         * 
         * @param previousAppsList
         *        A map of previous version numbers to their corresponding <code>App</code> object arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousAppsList(Map<String, ? extends Collection<App>> previousAppsList);
    }

    static final class BuilderImpl implements Builder {
        private String listId;

        private String listName;

        private String listUpdateToken;

        private Instant createTime;

        private Instant lastUpdateTime;

        private List<App> appsList = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<App>> previousAppsList = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppsListData model) {
            listId(model.listId);
            listName(model.listName);
            listUpdateToken(model.listUpdateToken);
            createTime(model.createTime);
            lastUpdateTime(model.lastUpdateTime);
            appsList(model.appsList);
            previousAppsList(model.previousAppsList);
        }

        public final String getListId() {
            return listId;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final String getListName() {
            return listName;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final String getListUpdateToken() {
            return listUpdateToken;
        }

        public final void setListUpdateToken(String listUpdateToken) {
            this.listUpdateToken = listUpdateToken;
        }

        @Override
        public final Builder listUpdateToken(String listUpdateToken) {
            this.listUpdateToken = listUpdateToken;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final List<App.Builder> getAppsList() {
            List<App.Builder> result = AppsListCopier.copyToBuilder(this.appsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppsList(Collection<App.BuilderImpl> appsList) {
            this.appsList = AppsListCopier.copyFromBuilder(appsList);
        }

        @Override
        public final Builder appsList(Collection<App> appsList) {
            this.appsList = AppsListCopier.copy(appsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsList(App... appsList) {
            appsList(Arrays.asList(appsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsList(Consumer<App.Builder>... appsList) {
            appsList(Stream.of(appsList).map(c -> App.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, List<App.Builder>> getPreviousAppsList() {
            Map<String, List<App.Builder>> result = PreviousAppsListCopier.copyToBuilder(this.previousAppsList);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPreviousAppsList(Map<String, ? extends Collection<App.BuilderImpl>> previousAppsList) {
            this.previousAppsList = PreviousAppsListCopier.copyFromBuilder(previousAppsList);
        }

        @Override
        public final Builder previousAppsList(Map<String, ? extends Collection<App>> previousAppsList) {
            this.previousAppsList = PreviousAppsListCopier.copy(previousAppsList);
            return this;
        }

        @Override
        public AppsListData build() {
            return new AppsListData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
