/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.FailedItem;
import software.amazon.awssdk.services.fms.model.FailedItemListCopier;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisassociateResourceResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, BatchDisassociateResourceResponse> {
    private static final SdkField<String> RESOURCE_SET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetIdentifier").getter(BatchDisassociateResourceResponse.getter(BatchDisassociateResourceResponse::resourceSetIdentifier)).setter(BatchDisassociateResourceResponse.setter(Builder::resourceSetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetIdentifier").build()}).build();
    private static final SdkField<List<FailedItem>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedItems").getter(BatchDisassociateResourceResponse.getter(BatchDisassociateResourceResponse::failedItems)).setter(BatchDisassociateResourceResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_IDENTIFIER_FIELD, FAILED_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDisassociateResourceResponse.memberNameToFieldInitializer();
    private final String resourceSetIdentifier;
    private final List<FailedItem> failedItems;

    private BatchDisassociateResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceSetIdentifier = builder.resourceSetIdentifier;
        this.failedItems = builder.failedItems;
    }

    public final String resourceSetIdentifier() {
        return this.resourceSetIdentifier;
    }

    public final boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructList);
    }

    public final List<FailedItem> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateResourceResponse)) {
            return false;
        }
        BatchDisassociateResourceResponse other = (BatchDisassociateResourceResponse)((Object)obj);
        return Objects.equals(this.resourceSetIdentifier(), other.resourceSetIdentifier()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDisassociateResourceResponse").add("ResourceSetIdentifier", (Object)this.resourceSetIdentifier()).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceSetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceSetIdentifier()));
            }
            case "FailedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceSetIdentifier", RESOURCE_SET_IDENTIFIER_FIELD);
        map.put("FailedItems", FAILED_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateResourceResponse, T> g) {
        return obj -> g.apply((BatchDisassociateResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private String resourceSetIdentifier;
        private List<FailedItem> failedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateResourceResponse model) {
            super(model);
            this.resourceSetIdentifier(model.resourceSetIdentifier);
            this.failedItems(model.failedItems);
        }

        public final String getResourceSetIdentifier() {
            return this.resourceSetIdentifier;
        }

        public final void setResourceSetIdentifier(String resourceSetIdentifier) {
            this.resourceSetIdentifier = resourceSetIdentifier;
        }

        @Override
        public final Builder resourceSetIdentifier(String resourceSetIdentifier) {
            this.resourceSetIdentifier = resourceSetIdentifier;
            return this;
        }

        public final List<FailedItem.Builder> getFailedItems() {
            List<FailedItem.Builder> result = FailedItemListCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Collection<FailedItem.BuilderImpl> failedItems) {
            this.failedItems = FailedItemListCopier.copyFromBuilder(failedItems);
        }

        @Override
        public final Builder failedItems(Collection<FailedItem> failedItems) {
            this.failedItems = FailedItemListCopier.copy(failedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(FailedItem ... failedItems) {
            this.failedItems(Arrays.asList(failedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(Consumer<FailedItem.Builder> ... failedItems) {
            this.failedItems(Stream.of(failedItems).map(c -> (FailedItem)((FailedItem.Builder)FailedItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDisassociateResourceResponse build() {
            return new BatchDisassociateResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisassociateResourceResponse> {
        public Builder resourceSetIdentifier(String var1);

        public Builder failedItems(Collection<FailedItem> var1);

        public Builder failedItems(FailedItem ... var1);

        public Builder failedItems(Consumer<FailedItem.Builder> ... var1);
    }
}

