/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.NetworkFirewallActionListCopier;
import software.amazon.awssdk.services.fms.model.StatefulEngineOptions;
import software.amazon.awssdk.services.fms.model.StatefulRuleGroup;
import software.amazon.awssdk.services.fms.model.StatefulRuleGroupListCopier;
import software.amazon.awssdk.services.fms.model.StatelessRuleGroup;
import software.amazon.awssdk.services.fms.model.StatelessRuleGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFirewallPolicyDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFirewallPolicyDescription> {
    private static final SdkField<List<StatelessRuleGroup>> STATELESS_RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessRuleGroups").getter(NetworkFirewallPolicyDescription.getter(NetworkFirewallPolicyDescription::statelessRuleGroups)).setter(NetworkFirewallPolicyDescription.setter(Builder::statelessRuleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatelessRuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATELESS_DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessDefaultActions").getter(NetworkFirewallPolicyDescription.getter(NetworkFirewallPolicyDescription::statelessDefaultActions)).setter(NetworkFirewallPolicyDescription.setter(Builder::statelessDefaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessDefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessFragmentDefaultActions").getter(NetworkFirewallPolicyDescription.getter(NetworkFirewallPolicyDescription::statelessFragmentDefaultActions)).setter(NetworkFirewallPolicyDescription.setter(Builder::statelessFragmentDefaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessFragmentDefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATELESS_CUSTOM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessCustomActions").getter(NetworkFirewallPolicyDescription.getter(NetworkFirewallPolicyDescription::statelessCustomActions)).setter(NetworkFirewallPolicyDescription.setter(Builder::statelessCustomActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessCustomActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StatefulRuleGroup>> STATEFUL_RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatefulRuleGroups").getter(NetworkFirewallPolicyDescription.getter(NetworkFirewallPolicyDescription::statefulRuleGroups)).setter(NetworkFirewallPolicyDescription.setter(Builder::statefulRuleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatefulRuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATEFUL_DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatefulDefaultActions").getter(NetworkFirewallPolicyDescription.getter(NetworkFirewallPolicyDescription::statefulDefaultActions)).setter(NetworkFirewallPolicyDescription.setter(Builder::statefulDefaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulDefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StatefulEngineOptions> STATEFUL_ENGINE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatefulEngineOptions").getter(NetworkFirewallPolicyDescription.getter(NetworkFirewallPolicyDescription::statefulEngineOptions)).setter(NetworkFirewallPolicyDescription.setter(Builder::statefulEngineOptions)).constructor(StatefulEngineOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulEngineOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATELESS_RULE_GROUPS_FIELD, STATELESS_DEFAULT_ACTIONS_FIELD, STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD, STATELESS_CUSTOM_ACTIONS_FIELD, STATEFUL_RULE_GROUPS_FIELD, STATEFUL_DEFAULT_ACTIONS_FIELD, STATEFUL_ENGINE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkFirewallPolicyDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StatelessRuleGroup> statelessRuleGroups;
    private final List<String> statelessDefaultActions;
    private final List<String> statelessFragmentDefaultActions;
    private final List<String> statelessCustomActions;
    private final List<StatefulRuleGroup> statefulRuleGroups;
    private final List<String> statefulDefaultActions;
    private final StatefulEngineOptions statefulEngineOptions;

    private NetworkFirewallPolicyDescription(BuilderImpl builder) {
        this.statelessRuleGroups = builder.statelessRuleGroups;
        this.statelessDefaultActions = builder.statelessDefaultActions;
        this.statelessFragmentDefaultActions = builder.statelessFragmentDefaultActions;
        this.statelessCustomActions = builder.statelessCustomActions;
        this.statefulRuleGroups = builder.statefulRuleGroups;
        this.statefulDefaultActions = builder.statefulDefaultActions;
        this.statefulEngineOptions = builder.statefulEngineOptions;
    }

    public final boolean hasStatelessRuleGroups() {
        return this.statelessRuleGroups != null && !(this.statelessRuleGroups instanceof SdkAutoConstructList);
    }

    public final List<StatelessRuleGroup> statelessRuleGroups() {
        return this.statelessRuleGroups;
    }

    public final boolean hasStatelessDefaultActions() {
        return this.statelessDefaultActions != null && !(this.statelessDefaultActions instanceof SdkAutoConstructList);
    }

    public final List<String> statelessDefaultActions() {
        return this.statelessDefaultActions;
    }

    public final boolean hasStatelessFragmentDefaultActions() {
        return this.statelessFragmentDefaultActions != null && !(this.statelessFragmentDefaultActions instanceof SdkAutoConstructList);
    }

    public final List<String> statelessFragmentDefaultActions() {
        return this.statelessFragmentDefaultActions;
    }

    public final boolean hasStatelessCustomActions() {
        return this.statelessCustomActions != null && !(this.statelessCustomActions instanceof SdkAutoConstructList);
    }

    public final List<String> statelessCustomActions() {
        return this.statelessCustomActions;
    }

    public final boolean hasStatefulRuleGroups() {
        return this.statefulRuleGroups != null && !(this.statefulRuleGroups instanceof SdkAutoConstructList);
    }

    public final List<StatefulRuleGroup> statefulRuleGroups() {
        return this.statefulRuleGroups;
    }

    public final boolean hasStatefulDefaultActions() {
        return this.statefulDefaultActions != null && !(this.statefulDefaultActions instanceof SdkAutoConstructList);
    }

    public final List<String> statefulDefaultActions() {
        return this.statefulDefaultActions;
    }

    public final StatefulEngineOptions statefulEngineOptions() {
        return this.statefulEngineOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessRuleGroups() ? this.statelessRuleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessDefaultActions() ? this.statelessDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessFragmentDefaultActions() ? this.statelessFragmentDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessCustomActions() ? this.statelessCustomActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatefulRuleGroups() ? this.statefulRuleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatefulDefaultActions() ? this.statefulDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statefulEngineOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallPolicyDescription)) {
            return false;
        }
        NetworkFirewallPolicyDescription other = (NetworkFirewallPolicyDescription)obj;
        return this.hasStatelessRuleGroups() == other.hasStatelessRuleGroups() && Objects.equals(this.statelessRuleGroups(), other.statelessRuleGroups()) && this.hasStatelessDefaultActions() == other.hasStatelessDefaultActions() && Objects.equals(this.statelessDefaultActions(), other.statelessDefaultActions()) && this.hasStatelessFragmentDefaultActions() == other.hasStatelessFragmentDefaultActions() && Objects.equals(this.statelessFragmentDefaultActions(), other.statelessFragmentDefaultActions()) && this.hasStatelessCustomActions() == other.hasStatelessCustomActions() && Objects.equals(this.statelessCustomActions(), other.statelessCustomActions()) && this.hasStatefulRuleGroups() == other.hasStatefulRuleGroups() && Objects.equals(this.statefulRuleGroups(), other.statefulRuleGroups()) && this.hasStatefulDefaultActions() == other.hasStatefulDefaultActions() && Objects.equals(this.statefulDefaultActions(), other.statefulDefaultActions()) && Objects.equals(this.statefulEngineOptions(), other.statefulEngineOptions());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFirewallPolicyDescription").add("StatelessRuleGroups", this.hasStatelessRuleGroups() ? this.statelessRuleGroups() : null).add("StatelessDefaultActions", this.hasStatelessDefaultActions() ? this.statelessDefaultActions() : null).add("StatelessFragmentDefaultActions", this.hasStatelessFragmentDefaultActions() ? this.statelessFragmentDefaultActions() : null).add("StatelessCustomActions", this.hasStatelessCustomActions() ? this.statelessCustomActions() : null).add("StatefulRuleGroups", this.hasStatefulRuleGroups() ? this.statefulRuleGroups() : null).add("StatefulDefaultActions", this.hasStatefulDefaultActions() ? this.statefulDefaultActions() : null).add("StatefulEngineOptions", (Object)this.statefulEngineOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatelessRuleGroups": {
                return Optional.ofNullable(clazz.cast(this.statelessRuleGroups()));
            }
            case "StatelessDefaultActions": {
                return Optional.ofNullable(clazz.cast(this.statelessDefaultActions()));
            }
            case "StatelessFragmentDefaultActions": {
                return Optional.ofNullable(clazz.cast(this.statelessFragmentDefaultActions()));
            }
            case "StatelessCustomActions": {
                return Optional.ofNullable(clazz.cast(this.statelessCustomActions()));
            }
            case "StatefulRuleGroups": {
                return Optional.ofNullable(clazz.cast(this.statefulRuleGroups()));
            }
            case "StatefulDefaultActions": {
                return Optional.ofNullable(clazz.cast(this.statefulDefaultActions()));
            }
            case "StatefulEngineOptions": {
                return Optional.ofNullable(clazz.cast(this.statefulEngineOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StatelessRuleGroups", STATELESS_RULE_GROUPS_FIELD);
        map.put("StatelessDefaultActions", STATELESS_DEFAULT_ACTIONS_FIELD);
        map.put("StatelessFragmentDefaultActions", STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD);
        map.put("StatelessCustomActions", STATELESS_CUSTOM_ACTIONS_FIELD);
        map.put("StatefulRuleGroups", STATEFUL_RULE_GROUPS_FIELD);
        map.put("StatefulDefaultActions", STATEFUL_DEFAULT_ACTIONS_FIELD);
        map.put("StatefulEngineOptions", STATEFUL_ENGINE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallPolicyDescription, T> g) {
        return obj -> g.apply((NetworkFirewallPolicyDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StatelessRuleGroup> statelessRuleGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> statelessDefaultActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> statelessFragmentDefaultActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> statelessCustomActions = DefaultSdkAutoConstructList.getInstance();
        private List<StatefulRuleGroup> statefulRuleGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> statefulDefaultActions = DefaultSdkAutoConstructList.getInstance();
        private StatefulEngineOptions statefulEngineOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallPolicyDescription model) {
            this.statelessRuleGroups(model.statelessRuleGroups);
            this.statelessDefaultActions(model.statelessDefaultActions);
            this.statelessFragmentDefaultActions(model.statelessFragmentDefaultActions);
            this.statelessCustomActions(model.statelessCustomActions);
            this.statefulRuleGroups(model.statefulRuleGroups);
            this.statefulDefaultActions(model.statefulDefaultActions);
            this.statefulEngineOptions(model.statefulEngineOptions);
        }

        public final List<StatelessRuleGroup.Builder> getStatelessRuleGroups() {
            List<StatelessRuleGroup.Builder> result = StatelessRuleGroupListCopier.copyToBuilder(this.statelessRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessRuleGroups(Collection<StatelessRuleGroup.BuilderImpl> statelessRuleGroups) {
            this.statelessRuleGroups = StatelessRuleGroupListCopier.copyFromBuilder(statelessRuleGroups);
        }

        @Override
        public final Builder statelessRuleGroups(Collection<StatelessRuleGroup> statelessRuleGroups) {
            this.statelessRuleGroups = StatelessRuleGroupListCopier.copy(statelessRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroups(StatelessRuleGroup ... statelessRuleGroups) {
            this.statelessRuleGroups(Arrays.asList(statelessRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroups(Consumer<StatelessRuleGroup.Builder> ... statelessRuleGroups) {
            this.statelessRuleGroups(Stream.of(statelessRuleGroups).map(c -> (StatelessRuleGroup)((StatelessRuleGroup.Builder)StatelessRuleGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStatelessDefaultActions() {
            if (this.statelessDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statelessDefaultActions;
        }

        public final void setStatelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = NetworkFirewallActionListCopier.copy(statelessDefaultActions);
        }

        @Override
        public final Builder statelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = NetworkFirewallActionListCopier.copy(statelessDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessDefaultActions(String ... statelessDefaultActions) {
            this.statelessDefaultActions(Arrays.asList(statelessDefaultActions));
            return this;
        }

        public final Collection<String> getStatelessFragmentDefaultActions() {
            if (this.statelessFragmentDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statelessFragmentDefaultActions;
        }

        public final void setStatelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = NetworkFirewallActionListCopier.copy(statelessFragmentDefaultActions);
        }

        @Override
        public final Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = NetworkFirewallActionListCopier.copy(statelessFragmentDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessFragmentDefaultActions(String ... statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions(Arrays.asList(statelessFragmentDefaultActions));
            return this;
        }

        public final Collection<String> getStatelessCustomActions() {
            if (this.statelessCustomActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statelessCustomActions;
        }

        public final void setStatelessCustomActions(Collection<String> statelessCustomActions) {
            this.statelessCustomActions = NetworkFirewallActionListCopier.copy(statelessCustomActions);
        }

        @Override
        public final Builder statelessCustomActions(Collection<String> statelessCustomActions) {
            this.statelessCustomActions = NetworkFirewallActionListCopier.copy(statelessCustomActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(String ... statelessCustomActions) {
            this.statelessCustomActions(Arrays.asList(statelessCustomActions));
            return this;
        }

        public final List<StatefulRuleGroup.Builder> getStatefulRuleGroups() {
            List<StatefulRuleGroup.Builder> result = StatefulRuleGroupListCopier.copyToBuilder(this.statefulRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRuleGroups(Collection<StatefulRuleGroup.BuilderImpl> statefulRuleGroups) {
            this.statefulRuleGroups = StatefulRuleGroupListCopier.copyFromBuilder(statefulRuleGroups);
        }

        @Override
        public final Builder statefulRuleGroups(Collection<StatefulRuleGroup> statefulRuleGroups) {
            this.statefulRuleGroups = StatefulRuleGroupListCopier.copy(statefulRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroups(StatefulRuleGroup ... statefulRuleGroups) {
            this.statefulRuleGroups(Arrays.asList(statefulRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroups(Consumer<StatefulRuleGroup.Builder> ... statefulRuleGroups) {
            this.statefulRuleGroups(Stream.of(statefulRuleGroups).map(c -> (StatefulRuleGroup)((StatefulRuleGroup.Builder)StatefulRuleGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStatefulDefaultActions() {
            if (this.statefulDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statefulDefaultActions;
        }

        public final void setStatefulDefaultActions(Collection<String> statefulDefaultActions) {
            this.statefulDefaultActions = NetworkFirewallActionListCopier.copy(statefulDefaultActions);
        }

        @Override
        public final Builder statefulDefaultActions(Collection<String> statefulDefaultActions) {
            this.statefulDefaultActions = NetworkFirewallActionListCopier.copy(statefulDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulDefaultActions(String ... statefulDefaultActions) {
            this.statefulDefaultActions(Arrays.asList(statefulDefaultActions));
            return this;
        }

        public final StatefulEngineOptions.Builder getStatefulEngineOptions() {
            return this.statefulEngineOptions != null ? this.statefulEngineOptions.toBuilder() : null;
        }

        public final void setStatefulEngineOptions(StatefulEngineOptions.BuilderImpl statefulEngineOptions) {
            this.statefulEngineOptions = statefulEngineOptions != null ? statefulEngineOptions.build() : null;
        }

        @Override
        public final Builder statefulEngineOptions(StatefulEngineOptions statefulEngineOptions) {
            this.statefulEngineOptions = statefulEngineOptions;
            return this;
        }

        public NetworkFirewallPolicyDescription build() {
            return new NetworkFirewallPolicyDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFirewallPolicyDescription> {
        public Builder statelessRuleGroups(Collection<StatelessRuleGroup> var1);

        public Builder statelessRuleGroups(StatelessRuleGroup ... var1);

        public Builder statelessRuleGroups(Consumer<StatelessRuleGroup.Builder> ... var1);

        public Builder statelessDefaultActions(Collection<String> var1);

        public Builder statelessDefaultActions(String ... var1);

        public Builder statelessFragmentDefaultActions(Collection<String> var1);

        public Builder statelessFragmentDefaultActions(String ... var1);

        public Builder statelessCustomActions(Collection<String> var1);

        public Builder statelessCustomActions(String ... var1);

        public Builder statefulRuleGroups(Collection<StatefulRuleGroup> var1);

        public Builder statefulRuleGroups(StatefulRuleGroup ... var1);

        public Builder statefulRuleGroups(Consumer<StatefulRuleGroup.Builder> ... var1);

        public Builder statefulDefaultActions(Collection<String> var1);

        public Builder statefulDefaultActions(String ... var1);

        public Builder statefulEngineOptions(StatefulEngineOptions var1);

        default public Builder statefulEngineOptions(Consumer<StatefulEngineOptions.Builder> statefulEngineOptions) {
            return this.statefulEngineOptions((StatefulEngineOptions)((StatefulEngineOptions.Builder)StatefulEngineOptions.builder().applyMutation(statefulEngineOptions)).build());
        }
    }
}

