/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.NetworkAclIcmpTypeCode;
import software.amazon.awssdk.services.fms.model.NetworkAclPortRange;
import software.amazon.awssdk.services.fms.model.NetworkAclRuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkAclEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkAclEntry> {
    private static final SdkField<NetworkAclIcmpTypeCode> ICMP_TYPE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IcmpTypeCode").getter(NetworkAclEntry.getter(NetworkAclEntry::icmpTypeCode)).setter(NetworkAclEntry.setter(Builder::icmpTypeCode)).constructor(NetworkAclIcmpTypeCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IcmpTypeCode").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(NetworkAclEntry.getter(NetworkAclEntry::protocol)).setter(NetworkAclEntry.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<NetworkAclPortRange> PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortRange").getter(NetworkAclEntry.getter(NetworkAclEntry::portRange)).setter(NetworkAclEntry.setter(Builder::portRange)).constructor(NetworkAclPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(NetworkAclEntry.getter(NetworkAclEntry::cidrBlock)).setter(NetworkAclEntry.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlock").getter(NetworkAclEntry.getter(NetworkAclEntry::ipv6CidrBlock)).setter(NetworkAclEntry.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleAction").getter(NetworkAclEntry.getter(NetworkAclEntry::ruleActionAsString)).setter(NetworkAclEntry.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").build()}).build();
    private static final SdkField<Boolean> EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Egress").getter(NetworkAclEntry.getter(NetworkAclEntry::egress)).setter(NetworkAclEntry.setter(Builder::egress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICMP_TYPE_CODE_FIELD, PROTOCOL_FIELD, PORT_RANGE_FIELD, CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_FIELD, RULE_ACTION_FIELD, EGRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final NetworkAclIcmpTypeCode icmpTypeCode;
    private final String protocol;
    private final NetworkAclPortRange portRange;
    private final String cidrBlock;
    private final String ipv6CidrBlock;
    private final String ruleAction;
    private final Boolean egress;

    private NetworkAclEntry(BuilderImpl builder) {
        this.icmpTypeCode = builder.icmpTypeCode;
        this.protocol = builder.protocol;
        this.portRange = builder.portRange;
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ruleAction = builder.ruleAction;
        this.egress = builder.egress;
    }

    public final NetworkAclIcmpTypeCode icmpTypeCode() {
        return this.icmpTypeCode;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final NetworkAclPortRange portRange() {
        return this.portRange;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public final NetworkAclRuleAction ruleAction() {
        return NetworkAclRuleAction.fromValue(this.ruleAction);
    }

    public final String ruleActionAsString() {
        return this.ruleAction;
    }

    public final Boolean egress() {
        return this.egress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.portRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.egress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclEntry)) {
            return false;
        }
        NetworkAclEntry other = (NetworkAclEntry)obj;
        return Objects.equals(this.icmpTypeCode(), other.icmpTypeCode()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.portRange(), other.portRange()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.ruleActionAsString(), other.ruleActionAsString()) && Objects.equals(this.egress(), other.egress());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkAclEntry").add("IcmpTypeCode", (Object)this.icmpTypeCode()).add("Protocol", (Object)this.protocol()).add("PortRange", (Object)this.portRange()).add("CidrBlock", (Object)this.cidrBlock()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("RuleAction", (Object)this.ruleActionAsString()).add("Egress", (Object)this.egress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IcmpTypeCode": {
                return Optional.ofNullable(clazz.cast(this.icmpTypeCode()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "PortRange": {
                return Optional.ofNullable(clazz.cast(this.portRange()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleActionAsString()));
            }
            case "Egress": {
                return Optional.ofNullable(clazz.cast(this.egress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkAclEntry, T> g) {
        return obj -> g.apply((NetworkAclEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkAclIcmpTypeCode icmpTypeCode;
        private String protocol;
        private NetworkAclPortRange portRange;
        private String cidrBlock;
        private String ipv6CidrBlock;
        private String ruleAction;
        private Boolean egress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclEntry model) {
            this.icmpTypeCode(model.icmpTypeCode);
            this.protocol(model.protocol);
            this.portRange(model.portRange);
            this.cidrBlock(model.cidrBlock);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.ruleAction(model.ruleAction);
            this.egress(model.egress);
        }

        public final NetworkAclIcmpTypeCode.Builder getIcmpTypeCode() {
            return this.icmpTypeCode != null ? this.icmpTypeCode.toBuilder() : null;
        }

        public final void setIcmpTypeCode(NetworkAclIcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        @Override
        public final Builder icmpTypeCode(NetworkAclIcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final NetworkAclPortRange.Builder getPortRange() {
            return this.portRange != null ? this.portRange.toBuilder() : null;
        }

        public final void setPortRange(NetworkAclPortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        @Override
        public final Builder portRange(NetworkAclPortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(NetworkAclRuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final Boolean getEgress() {
            return this.egress;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public NetworkAclEntry build() {
            return new NetworkAclEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkAclEntry> {
        public Builder icmpTypeCode(NetworkAclIcmpTypeCode var1);

        default public Builder icmpTypeCode(Consumer<NetworkAclIcmpTypeCode.Builder> icmpTypeCode) {
            return this.icmpTypeCode((NetworkAclIcmpTypeCode)((NetworkAclIcmpTypeCode.Builder)NetworkAclIcmpTypeCode.builder().applyMutation(icmpTypeCode)).build());
        }

        public Builder protocol(String var1);

        public Builder portRange(NetworkAclPortRange var1);

        default public Builder portRange(Consumer<NetworkAclPortRange.Builder> portRange) {
            return this.portRange((NetworkAclPortRange)((NetworkAclPortRange.Builder)NetworkAclPortRange.builder().applyMutation(portRange)).build());
        }

        public Builder cidrBlock(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(NetworkAclRuleAction var1);

        public Builder egress(Boolean var1);
    }
}

