/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.NetworkAclEntriesCopier;
import software.amazon.awssdk.services.fms.model.NetworkAclEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkAclEntrySet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkAclEntrySet> {
    private static final SdkField<List<NetworkAclEntry>> FIRST_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FirstEntries").getter(NetworkAclEntrySet.getter(NetworkAclEntrySet::firstEntries)).setter(NetworkAclEntrySet.setter(Builder::firstEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkAclEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> FORCE_REMEDIATE_FOR_FIRST_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceRemediateForFirstEntries").getter(NetworkAclEntrySet.getter(NetworkAclEntrySet::forceRemediateForFirstEntries)).setter(NetworkAclEntrySet.setter(Builder::forceRemediateForFirstEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceRemediateForFirstEntries").build()}).build();
    private static final SdkField<List<NetworkAclEntry>> LAST_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LastEntries").getter(NetworkAclEntrySet.getter(NetworkAclEntrySet::lastEntries)).setter(NetworkAclEntrySet.setter(Builder::lastEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkAclEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> FORCE_REMEDIATE_FOR_LAST_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceRemediateForLastEntries").getter(NetworkAclEntrySet.getter(NetworkAclEntrySet::forceRemediateForLastEntries)).setter(NetworkAclEntrySet.setter(Builder::forceRemediateForLastEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceRemediateForLastEntries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_ENTRIES_FIELD, FORCE_REMEDIATE_FOR_FIRST_ENTRIES_FIELD, LAST_ENTRIES_FIELD, FORCE_REMEDIATE_FOR_LAST_ENTRIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<NetworkAclEntry> firstEntries;
    private final Boolean forceRemediateForFirstEntries;
    private final List<NetworkAclEntry> lastEntries;
    private final Boolean forceRemediateForLastEntries;

    private NetworkAclEntrySet(BuilderImpl builder) {
        this.firstEntries = builder.firstEntries;
        this.forceRemediateForFirstEntries = builder.forceRemediateForFirstEntries;
        this.lastEntries = builder.lastEntries;
        this.forceRemediateForLastEntries = builder.forceRemediateForLastEntries;
    }

    public final boolean hasFirstEntries() {
        return this.firstEntries != null && !(this.firstEntries instanceof SdkAutoConstructList);
    }

    public final List<NetworkAclEntry> firstEntries() {
        return this.firstEntries;
    }

    public final Boolean forceRemediateForFirstEntries() {
        return this.forceRemediateForFirstEntries;
    }

    public final boolean hasLastEntries() {
        return this.lastEntries != null && !(this.lastEntries instanceof SdkAutoConstructList);
    }

    public final List<NetworkAclEntry> lastEntries() {
        return this.lastEntries;
    }

    public final Boolean forceRemediateForLastEntries() {
        return this.forceRemediateForLastEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirstEntries() ? this.firstEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forceRemediateForFirstEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastEntries() ? this.lastEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forceRemediateForLastEntries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclEntrySet)) {
            return false;
        }
        NetworkAclEntrySet other = (NetworkAclEntrySet)obj;
        return this.hasFirstEntries() == other.hasFirstEntries() && Objects.equals(this.firstEntries(), other.firstEntries()) && Objects.equals(this.forceRemediateForFirstEntries(), other.forceRemediateForFirstEntries()) && this.hasLastEntries() == other.hasLastEntries() && Objects.equals(this.lastEntries(), other.lastEntries()) && Objects.equals(this.forceRemediateForLastEntries(), other.forceRemediateForLastEntries());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkAclEntrySet").add("FirstEntries", this.hasFirstEntries() ? this.firstEntries() : null).add("ForceRemediateForFirstEntries", (Object)this.forceRemediateForFirstEntries()).add("LastEntries", this.hasLastEntries() ? this.lastEntries() : null).add("ForceRemediateForLastEntries", (Object)this.forceRemediateForLastEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirstEntries": {
                return Optional.ofNullable(clazz.cast(this.firstEntries()));
            }
            case "ForceRemediateForFirstEntries": {
                return Optional.ofNullable(clazz.cast(this.forceRemediateForFirstEntries()));
            }
            case "LastEntries": {
                return Optional.ofNullable(clazz.cast(this.lastEntries()));
            }
            case "ForceRemediateForLastEntries": {
                return Optional.ofNullable(clazz.cast(this.forceRemediateForLastEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkAclEntrySet, T> g) {
        return obj -> g.apply((NetworkAclEntrySet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<NetworkAclEntry> firstEntries = DefaultSdkAutoConstructList.getInstance();
        private Boolean forceRemediateForFirstEntries;
        private List<NetworkAclEntry> lastEntries = DefaultSdkAutoConstructList.getInstance();
        private Boolean forceRemediateForLastEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclEntrySet model) {
            this.firstEntries(model.firstEntries);
            this.forceRemediateForFirstEntries(model.forceRemediateForFirstEntries);
            this.lastEntries(model.lastEntries);
            this.forceRemediateForLastEntries(model.forceRemediateForLastEntries);
        }

        public final List<NetworkAclEntry.Builder> getFirstEntries() {
            List<NetworkAclEntry.Builder> result = NetworkAclEntriesCopier.copyToBuilder(this.firstEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirstEntries(Collection<NetworkAclEntry.BuilderImpl> firstEntries) {
            this.firstEntries = NetworkAclEntriesCopier.copyFromBuilder(firstEntries);
        }

        @Override
        public final Builder firstEntries(Collection<NetworkAclEntry> firstEntries) {
            this.firstEntries = NetworkAclEntriesCopier.copy(firstEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firstEntries(NetworkAclEntry ... firstEntries) {
            this.firstEntries(Arrays.asList(firstEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firstEntries(Consumer<NetworkAclEntry.Builder> ... firstEntries) {
            this.firstEntries(Stream.of(firstEntries).map(c -> (NetworkAclEntry)((NetworkAclEntry.Builder)NetworkAclEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getForceRemediateForFirstEntries() {
            return this.forceRemediateForFirstEntries;
        }

        public final void setForceRemediateForFirstEntries(Boolean forceRemediateForFirstEntries) {
            this.forceRemediateForFirstEntries = forceRemediateForFirstEntries;
        }

        @Override
        public final Builder forceRemediateForFirstEntries(Boolean forceRemediateForFirstEntries) {
            this.forceRemediateForFirstEntries = forceRemediateForFirstEntries;
            return this;
        }

        public final List<NetworkAclEntry.Builder> getLastEntries() {
            List<NetworkAclEntry.Builder> result = NetworkAclEntriesCopier.copyToBuilder(this.lastEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastEntries(Collection<NetworkAclEntry.BuilderImpl> lastEntries) {
            this.lastEntries = NetworkAclEntriesCopier.copyFromBuilder(lastEntries);
        }

        @Override
        public final Builder lastEntries(Collection<NetworkAclEntry> lastEntries) {
            this.lastEntries = NetworkAclEntriesCopier.copy(lastEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastEntries(NetworkAclEntry ... lastEntries) {
            this.lastEntries(Arrays.asList(lastEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastEntries(Consumer<NetworkAclEntry.Builder> ... lastEntries) {
            this.lastEntries(Stream.of(lastEntries).map(c -> (NetworkAclEntry)((NetworkAclEntry.Builder)NetworkAclEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getForceRemediateForLastEntries() {
            return this.forceRemediateForLastEntries;
        }

        public final void setForceRemediateForLastEntries(Boolean forceRemediateForLastEntries) {
            this.forceRemediateForLastEntries = forceRemediateForLastEntries;
        }

        @Override
        public final Builder forceRemediateForLastEntries(Boolean forceRemediateForLastEntries) {
            this.forceRemediateForLastEntries = forceRemediateForLastEntries;
            return this;
        }

        public NetworkAclEntrySet build() {
            return new NetworkAclEntrySet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkAclEntrySet> {
        public Builder firstEntries(Collection<NetworkAclEntry> var1);

        public Builder firstEntries(NetworkAclEntry ... var1);

        public Builder firstEntries(Consumer<NetworkAclEntry.Builder> ... var1);

        public Builder forceRemediateForFirstEntries(Boolean var1);

        public Builder lastEntries(Collection<NetworkAclEntry> var1);

        public Builder lastEntries(NetworkAclEntry ... var1);

        public Builder lastEntries(Consumer<NetworkAclEntry.Builder> ... var1);

        public Builder forceRemediateForLastEntries(Boolean var1);
    }
}

