/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.EntriesWithConflictsCopier;
import software.amazon.awssdk.services.fms.model.EntryDescription;
import software.amazon.awssdk.services.fms.model.EntryViolationReason;
import software.amazon.awssdk.services.fms.model.EntryViolationReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntryViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntryViolation> {
    private static final SdkField<EntryDescription> EXPECTED_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpectedEntry").getter(EntryViolation.getter(EntryViolation::expectedEntry)).setter(EntryViolation.setter(Builder::expectedEntry)).constructor(EntryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedEntry").build()}).build();
    private static final SdkField<String> EXPECTED_EVALUATION_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedEvaluationOrder").getter(EntryViolation.getter(EntryViolation::expectedEvaluationOrder)).setter(EntryViolation.setter(Builder::expectedEvaluationOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedEvaluationOrder").build()}).build();
    private static final SdkField<String> ACTUAL_EVALUATION_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActualEvaluationOrder").getter(EntryViolation.getter(EntryViolation::actualEvaluationOrder)).setter(EntryViolation.setter(Builder::actualEvaluationOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualEvaluationOrder").build()}).build();
    private static final SdkField<EntryDescription> ENTRY_AT_EXPECTED_EVALUATION_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntryAtExpectedEvaluationOrder").getter(EntryViolation.getter(EntryViolation::entryAtExpectedEvaluationOrder)).setter(EntryViolation.setter(Builder::entryAtExpectedEvaluationOrder)).constructor(EntryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryAtExpectedEvaluationOrder").build()}).build();
    private static final SdkField<List<EntryDescription>> ENTRIES_WITH_CONFLICTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntriesWithConflicts").getter(EntryViolation.getter(EntryViolation::entriesWithConflicts)).setter(EntryViolation.setter(Builder::entriesWithConflicts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntriesWithConflicts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTRY_VIOLATION_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntryViolationReasons").getter(EntryViolation.getter(EntryViolation::entryViolationReasonsAsStrings)).setter(EntryViolation.setter(Builder::entryViolationReasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryViolationReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPECTED_ENTRY_FIELD, EXPECTED_EVALUATION_ORDER_FIELD, ACTUAL_EVALUATION_ORDER_FIELD, ENTRY_AT_EXPECTED_EVALUATION_ORDER_FIELD, ENTRIES_WITH_CONFLICTS_FIELD, ENTRY_VIOLATION_REASONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final EntryDescription expectedEntry;
    private final String expectedEvaluationOrder;
    private final String actualEvaluationOrder;
    private final EntryDescription entryAtExpectedEvaluationOrder;
    private final List<EntryDescription> entriesWithConflicts;
    private final List<String> entryViolationReasons;

    private EntryViolation(BuilderImpl builder) {
        this.expectedEntry = builder.expectedEntry;
        this.expectedEvaluationOrder = builder.expectedEvaluationOrder;
        this.actualEvaluationOrder = builder.actualEvaluationOrder;
        this.entryAtExpectedEvaluationOrder = builder.entryAtExpectedEvaluationOrder;
        this.entriesWithConflicts = builder.entriesWithConflicts;
        this.entryViolationReasons = builder.entryViolationReasons;
    }

    public final EntryDescription expectedEntry() {
        return this.expectedEntry;
    }

    public final String expectedEvaluationOrder() {
        return this.expectedEvaluationOrder;
    }

    public final String actualEvaluationOrder() {
        return this.actualEvaluationOrder;
    }

    public final EntryDescription entryAtExpectedEvaluationOrder() {
        return this.entryAtExpectedEvaluationOrder;
    }

    public final boolean hasEntriesWithConflicts() {
        return this.entriesWithConflicts != null && !(this.entriesWithConflicts instanceof SdkAutoConstructList);
    }

    public final List<EntryDescription> entriesWithConflicts() {
        return this.entriesWithConflicts;
    }

    public final List<EntryViolationReason> entryViolationReasons() {
        return EntryViolationReasonsCopier.copyStringToEnum(this.entryViolationReasons);
    }

    public final boolean hasEntryViolationReasons() {
        return this.entryViolationReasons != null && !(this.entryViolationReasons instanceof SdkAutoConstructList);
    }

    public final List<String> entryViolationReasonsAsStrings() {
        return this.entryViolationReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedEvaluationOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualEvaluationOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.entryAtExpectedEvaluationOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntriesWithConflicts() ? this.entriesWithConflicts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntryViolationReasons() ? this.entryViolationReasonsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntryViolation)) {
            return false;
        }
        EntryViolation other = (EntryViolation)obj;
        return Objects.equals(this.expectedEntry(), other.expectedEntry()) && Objects.equals(this.expectedEvaluationOrder(), other.expectedEvaluationOrder()) && Objects.equals(this.actualEvaluationOrder(), other.actualEvaluationOrder()) && Objects.equals(this.entryAtExpectedEvaluationOrder(), other.entryAtExpectedEvaluationOrder()) && this.hasEntriesWithConflicts() == other.hasEntriesWithConflicts() && Objects.equals(this.entriesWithConflicts(), other.entriesWithConflicts()) && this.hasEntryViolationReasons() == other.hasEntryViolationReasons() && Objects.equals(this.entryViolationReasonsAsStrings(), other.entryViolationReasonsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EntryViolation").add("ExpectedEntry", (Object)this.expectedEntry()).add("ExpectedEvaluationOrder", (Object)this.expectedEvaluationOrder()).add("ActualEvaluationOrder", (Object)this.actualEvaluationOrder()).add("EntryAtExpectedEvaluationOrder", (Object)this.entryAtExpectedEvaluationOrder()).add("EntriesWithConflicts", this.hasEntriesWithConflicts() ? this.entriesWithConflicts() : null).add("EntryViolationReasons", this.hasEntryViolationReasons() ? this.entryViolationReasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpectedEntry": {
                return Optional.ofNullable(clazz.cast(this.expectedEntry()));
            }
            case "ExpectedEvaluationOrder": {
                return Optional.ofNullable(clazz.cast(this.expectedEvaluationOrder()));
            }
            case "ActualEvaluationOrder": {
                return Optional.ofNullable(clazz.cast(this.actualEvaluationOrder()));
            }
            case "EntryAtExpectedEvaluationOrder": {
                return Optional.ofNullable(clazz.cast(this.entryAtExpectedEvaluationOrder()));
            }
            case "EntriesWithConflicts": {
                return Optional.ofNullable(clazz.cast(this.entriesWithConflicts()));
            }
            case "EntryViolationReasons": {
                return Optional.ofNullable(clazz.cast(this.entryViolationReasonsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntryViolation, T> g) {
        return obj -> g.apply((EntryViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EntryDescription expectedEntry;
        private String expectedEvaluationOrder;
        private String actualEvaluationOrder;
        private EntryDescription entryAtExpectedEvaluationOrder;
        private List<EntryDescription> entriesWithConflicts = DefaultSdkAutoConstructList.getInstance();
        private List<String> entryViolationReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntryViolation model) {
            this.expectedEntry(model.expectedEntry);
            this.expectedEvaluationOrder(model.expectedEvaluationOrder);
            this.actualEvaluationOrder(model.actualEvaluationOrder);
            this.entryAtExpectedEvaluationOrder(model.entryAtExpectedEvaluationOrder);
            this.entriesWithConflicts(model.entriesWithConflicts);
            this.entryViolationReasonsWithStrings(model.entryViolationReasons);
        }

        public final EntryDescription.Builder getExpectedEntry() {
            return this.expectedEntry != null ? this.expectedEntry.toBuilder() : null;
        }

        public final void setExpectedEntry(EntryDescription.BuilderImpl expectedEntry) {
            this.expectedEntry = expectedEntry != null ? expectedEntry.build() : null;
        }

        @Override
        public final Builder expectedEntry(EntryDescription expectedEntry) {
            this.expectedEntry = expectedEntry;
            return this;
        }

        public final String getExpectedEvaluationOrder() {
            return this.expectedEvaluationOrder;
        }

        public final void setExpectedEvaluationOrder(String expectedEvaluationOrder) {
            this.expectedEvaluationOrder = expectedEvaluationOrder;
        }

        @Override
        public final Builder expectedEvaluationOrder(String expectedEvaluationOrder) {
            this.expectedEvaluationOrder = expectedEvaluationOrder;
            return this;
        }

        public final String getActualEvaluationOrder() {
            return this.actualEvaluationOrder;
        }

        public final void setActualEvaluationOrder(String actualEvaluationOrder) {
            this.actualEvaluationOrder = actualEvaluationOrder;
        }

        @Override
        public final Builder actualEvaluationOrder(String actualEvaluationOrder) {
            this.actualEvaluationOrder = actualEvaluationOrder;
            return this;
        }

        public final EntryDescription.Builder getEntryAtExpectedEvaluationOrder() {
            return this.entryAtExpectedEvaluationOrder != null ? this.entryAtExpectedEvaluationOrder.toBuilder() : null;
        }

        public final void setEntryAtExpectedEvaluationOrder(EntryDescription.BuilderImpl entryAtExpectedEvaluationOrder) {
            this.entryAtExpectedEvaluationOrder = entryAtExpectedEvaluationOrder != null ? entryAtExpectedEvaluationOrder.build() : null;
        }

        @Override
        public final Builder entryAtExpectedEvaluationOrder(EntryDescription entryAtExpectedEvaluationOrder) {
            this.entryAtExpectedEvaluationOrder = entryAtExpectedEvaluationOrder;
            return this;
        }

        public final List<EntryDescription.Builder> getEntriesWithConflicts() {
            List<EntryDescription.Builder> result = EntriesWithConflictsCopier.copyToBuilder(this.entriesWithConflicts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntriesWithConflicts(Collection<EntryDescription.BuilderImpl> entriesWithConflicts) {
            this.entriesWithConflicts = EntriesWithConflictsCopier.copyFromBuilder(entriesWithConflicts);
        }

        @Override
        public final Builder entriesWithConflicts(Collection<EntryDescription> entriesWithConflicts) {
            this.entriesWithConflicts = EntriesWithConflictsCopier.copy(entriesWithConflicts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entriesWithConflicts(EntryDescription ... entriesWithConflicts) {
            this.entriesWithConflicts(Arrays.asList(entriesWithConflicts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entriesWithConflicts(Consumer<EntryDescription.Builder> ... entriesWithConflicts) {
            this.entriesWithConflicts(Stream.of(entriesWithConflicts).map(c -> (EntryDescription)((EntryDescription.Builder)EntryDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEntryViolationReasons() {
            if (this.entryViolationReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entryViolationReasons;
        }

        public final void setEntryViolationReasons(Collection<String> entryViolationReasons) {
            this.entryViolationReasons = EntryViolationReasonsCopier.copy(entryViolationReasons);
        }

        @Override
        public final Builder entryViolationReasonsWithStrings(Collection<String> entryViolationReasons) {
            this.entryViolationReasons = EntryViolationReasonsCopier.copy(entryViolationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryViolationReasonsWithStrings(String ... entryViolationReasons) {
            this.entryViolationReasonsWithStrings(Arrays.asList(entryViolationReasons));
            return this;
        }

        @Override
        public final Builder entryViolationReasons(Collection<EntryViolationReason> entryViolationReasons) {
            this.entryViolationReasons = EntryViolationReasonsCopier.copyEnumToString(entryViolationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryViolationReasons(EntryViolationReason ... entryViolationReasons) {
            this.entryViolationReasons(Arrays.asList(entryViolationReasons));
            return this;
        }

        public EntryViolation build() {
            return new EntryViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntryViolation> {
        public Builder expectedEntry(EntryDescription var1);

        default public Builder expectedEntry(Consumer<EntryDescription.Builder> expectedEntry) {
            return this.expectedEntry((EntryDescription)((EntryDescription.Builder)EntryDescription.builder().applyMutation(expectedEntry)).build());
        }

        public Builder expectedEvaluationOrder(String var1);

        public Builder actualEvaluationOrder(String var1);

        public Builder entryAtExpectedEvaluationOrder(EntryDescription var1);

        default public Builder entryAtExpectedEvaluationOrder(Consumer<EntryDescription.Builder> entryAtExpectedEvaluationOrder) {
            return this.entryAtExpectedEvaluationOrder((EntryDescription)((EntryDescription.Builder)EntryDescription.builder().applyMutation(entryAtExpectedEvaluationOrder)).build());
        }

        public Builder entriesWithConflicts(Collection<EntryDescription> var1);

        public Builder entriesWithConflicts(EntryDescription ... var1);

        public Builder entriesWithConflicts(Consumer<EntryDescription.Builder> ... var1);

        public Builder entryViolationReasonsWithStrings(Collection<String> var1);

        public Builder entryViolationReasonsWithStrings(String ... var1);

        public Builder entryViolationReasons(Collection<EntryViolationReason> var1);

        public Builder entryViolationReasons(EntryViolationReason ... var1);
    }
}

