/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a Firewall Manager network ACL policy. This is used in the <code>PolicyOption</code> of a
 * <code>SecurityServicePolicyData</code> for a <code>Policy</code>, when the <code>SecurityServicePolicyData</code>
 * type is set to <code>NETWORK_ACL_COMMON</code>.
 * </p>
 * <p>
 * For information about network ACLs, see <a
 * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Control traffic to subnets using
 * network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkAclCommonPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkAclCommonPolicy.Builder, NetworkAclCommonPolicy> {
    private static final SdkField<NetworkAclEntrySet> NETWORK_ACL_ENTRY_SET_FIELD = SdkField
            .<NetworkAclEntrySet> builder(MarshallingType.SDK_POJO).memberName("NetworkAclEntrySet")
            .getter(getter(NetworkAclCommonPolicy::networkAclEntrySet)).setter(setter(Builder::networkAclEntrySet))
            .constructor(NetworkAclEntrySet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclEntrySet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ACL_ENTRY_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final NetworkAclEntrySet networkAclEntrySet;

    private NetworkAclCommonPolicy(BuilderImpl builder) {
        this.networkAclEntrySet = builder.networkAclEntrySet;
    }

    /**
     * <p>
     * The definition of the first and last rules for the network ACL policy.
     * </p>
     * 
     * @return The definition of the first and last rules for the network ACL policy.
     */
    public final NetworkAclEntrySet networkAclEntrySet() {
        return networkAclEntrySet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAclEntrySet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclCommonPolicy)) {
            return false;
        }
        NetworkAclCommonPolicy other = (NetworkAclCommonPolicy) obj;
        return Objects.equals(networkAclEntrySet(), other.networkAclEntrySet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkAclCommonPolicy").add("NetworkAclEntrySet", networkAclEntrySet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkAclEntrySet":
            return Optional.ofNullable(clazz.cast(networkAclEntrySet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkAclCommonPolicy, T> g) {
        return obj -> g.apply((NetworkAclCommonPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkAclCommonPolicy> {
        /**
         * <p>
         * The definition of the first and last rules for the network ACL policy.
         * </p>
         * 
         * @param networkAclEntrySet
         *        The definition of the first and last rules for the network ACL policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclEntrySet(NetworkAclEntrySet networkAclEntrySet);

        /**
         * <p>
         * The definition of the first and last rules for the network ACL policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkAclEntrySet.Builder} avoiding the
         * need to create one manually via {@link NetworkAclEntrySet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkAclEntrySet.Builder#build()} is called immediately and its
         * result is passed to {@link #networkAclEntrySet(NetworkAclEntrySet)}.
         * 
         * @param networkAclEntrySet
         *        a consumer that will call methods on {@link NetworkAclEntrySet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAclEntrySet(NetworkAclEntrySet)
         */
        default Builder networkAclEntrySet(Consumer<NetworkAclEntrySet.Builder> networkAclEntrySet) {
            return networkAclEntrySet(NetworkAclEntrySet.builder().applyMutation(networkAclEntrySet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NetworkAclEntrySet networkAclEntrySet;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclCommonPolicy model) {
            networkAclEntrySet(model.networkAclEntrySet);
        }

        public final NetworkAclEntrySet.Builder getNetworkAclEntrySet() {
            return networkAclEntrySet != null ? networkAclEntrySet.toBuilder() : null;
        }

        public final void setNetworkAclEntrySet(NetworkAclEntrySet.BuilderImpl networkAclEntrySet) {
            this.networkAclEntrySet = networkAclEntrySet != null ? networkAclEntrySet.build() : null;
        }

        @Override
        public final Builder networkAclEntrySet(NetworkAclEntrySet networkAclEntrySet) {
            this.networkAclEntrySet = networkAclEntrySet;
            return this;
        }

        @Override
        public NetworkAclCommonPolicy build() {
            return new NetworkAclCommonPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
