/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A DNS Firewall rule group that Firewall Manager tried to associate with a VPC is already associated with the VPC and
 * can't be associated again.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsDuplicateRuleGroupViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<DnsDuplicateRuleGroupViolation.Builder, DnsDuplicateRuleGroupViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(DnsDuplicateRuleGroupViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<String> VIOLATION_TARGET_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ViolationTargetDescription")
            .getter(getter(DnsDuplicateRuleGroupViolation::violationTargetDescription))
            .setter(setter(Builder::violationTargetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTargetDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            VIOLATION_TARGET_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final String violationTargetDescription;

    private DnsDuplicateRuleGroupViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.violationTargetDescription = builder.violationTargetDescription;
    }

    /**
     * <p>
     * Information about the VPC ID.
     * </p>
     * 
     * @return Information about the VPC ID.
     */
    public final String violationTarget() {
        return violationTarget;
    }

    /**
     * <p>
     * A description of the violation that specifies the rule group and VPC.
     * </p>
     * 
     * @return A description of the violation that specifies the rule group and VPC.
     */
    public final String violationTargetDescription() {
        return violationTargetDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(violationTargetDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsDuplicateRuleGroupViolation)) {
            return false;
        }
        DnsDuplicateRuleGroupViolation other = (DnsDuplicateRuleGroupViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget())
                && Objects.equals(violationTargetDescription(), other.violationTargetDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsDuplicateRuleGroupViolation").add("ViolationTarget", violationTarget())
                .add("ViolationTargetDescription", violationTargetDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "ViolationTargetDescription":
            return Optional.ofNullable(clazz.cast(violationTargetDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsDuplicateRuleGroupViolation, T> g) {
        return obj -> g.apply((DnsDuplicateRuleGroupViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsDuplicateRuleGroupViolation> {
        /**
         * <p>
         * Information about the VPC ID.
         * </p>
         * 
         * @param violationTarget
         *        Information about the VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * A description of the violation that specifies the rule group and VPC.
         * </p>
         * 
         * @param violationTargetDescription
         *        A description of the violation that specifies the rule group and VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTargetDescription(String violationTargetDescription);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private String violationTargetDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsDuplicateRuleGroupViolation model) {
            violationTarget(model.violationTarget);
            violationTargetDescription(model.violationTargetDescription);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final String getViolationTargetDescription() {
            return violationTargetDescription;
        }

        public final void setViolationTargetDescription(String violationTargetDescription) {
            this.violationTargetDescription = violationTargetDescription;
        }

        @Override
        public final Builder violationTargetDescription(String violationTargetDescription) {
            this.violationTargetDescription = violationTargetDescription;
            return this;
        }

        @Override
        public DnsDuplicateRuleGroupViolation build() {
            return new DnsDuplicateRuleGroupViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
