/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailedItemReason {
    NOT_VALID_ARN("NOT_VALID_ARN"),
    NOT_VALID_PARTITION("NOT_VALID_PARTITION"),
    NOT_VALID_REGION("NOT_VALID_REGION"),
    NOT_VALID_SERVICE("NOT_VALID_SERVICE"),
    NOT_VALID_RESOURCE_TYPE("NOT_VALID_RESOURCE_TYPE"),
    NOT_VALID_ACCOUNT_ID("NOT_VALID_ACCOUNT_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailedItemReason> VALUE_MAP;
    private final String value;

    private FailedItemReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailedItemReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailedItemReason> knownValues() {
        EnumSet<FailedItemReason> knownValues = EnumSet.allOf(FailedItemReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailedItemReason.class, FailedItemReason::toString);
    }
}

