/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for network interfaces associated with an EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2NetworkInterfaceViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2NetworkInterfaceViolation.Builder, AwsEc2NetworkInterfaceViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(AwsEc2NetworkInterfaceViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<List<String>> VIOLATING_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ViolatingSecurityGroups")
            .getter(getter(AwsEc2NetworkInterfaceViolation::violatingSecurityGroups))
            .setter(setter(Builder::violatingSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            VIOLATING_SECURITY_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final List<String> violatingSecurityGroups;

    private AwsEc2NetworkInterfaceViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.violatingSecurityGroups = builder.violatingSecurityGroups;
    }

    /**
     * <p>
     * The resource ID of the network interface.
     * </p>
     * 
     * @return The resource ID of the network interface.
     */
    public final String violationTarget() {
        return violationTarget;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViolatingSecurityGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasViolatingSecurityGroups() {
        return violatingSecurityGroups != null && !(violatingSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of security groups that violate the rules specified in the primary security group of the Firewall Manager
     * policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolatingSecurityGroups} method.
     * </p>
     * 
     * @return List of security groups that violate the rules specified in the primary security group of the Firewall
     *         Manager policy.
     */
    public final List<String> violatingSecurityGroups() {
        return violatingSecurityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(hasViolatingSecurityGroups() ? violatingSecurityGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceViolation)) {
            return false;
        }
        AwsEc2NetworkInterfaceViolation other = (AwsEc2NetworkInterfaceViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget())
                && hasViolatingSecurityGroups() == other.hasViolatingSecurityGroups()
                && Objects.equals(violatingSecurityGroups(), other.violatingSecurityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2NetworkInterfaceViolation").add("ViolationTarget", violationTarget())
                .add("ViolatingSecurityGroups", hasViolatingSecurityGroups() ? violatingSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "ViolatingSecurityGroups":
            return Optional.ofNullable(clazz.cast(violatingSecurityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceViolation, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2NetworkInterfaceViolation> {
        /**
         * <p>
         * The resource ID of the network interface.
         * </p>
         * 
         * @param violationTarget
         *        The resource ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * List of security groups that violate the rules specified in the primary security group of the Firewall
         * Manager policy.
         * </p>
         * 
         * @param violatingSecurityGroups
         *        List of security groups that violate the rules specified in the primary security group of the Firewall
         *        Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingSecurityGroups(Collection<String> violatingSecurityGroups);

        /**
         * <p>
         * List of security groups that violate the rules specified in the primary security group of the Firewall
         * Manager policy.
         * </p>
         * 
         * @param violatingSecurityGroups
         *        List of security groups that violate the rules specified in the primary security group of the Firewall
         *        Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingSecurityGroups(String... violatingSecurityGroups);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private List<String> violatingSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceViolation model) {
            violationTarget(model.violationTarget);
            violatingSecurityGroups(model.violatingSecurityGroups);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        @Transient
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final Collection<String> getViolatingSecurityGroups() {
            if (violatingSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return violatingSecurityGroups;
        }

        public final void setViolatingSecurityGroups(Collection<String> violatingSecurityGroups) {
            this.violatingSecurityGroups = ResourceIdListCopier.copy(violatingSecurityGroups);
        }

        @Override
        @Transient
        public final Builder violatingSecurityGroups(Collection<String> violatingSecurityGroups) {
            this.violatingSecurityGroups = ResourceIdListCopier.copy(violatingSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder violatingSecurityGroups(String... violatingSecurityGroups) {
            violatingSecurityGroups(Arrays.asList(violatingSecurityGroups));
            return this;
        }

        @Override
        public AwsEc2NetworkInterfaceViolation build() {
            return new AwsEc2NetworkInterfaceViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
