/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the noncompliant resources in a member account for a specific Firewall Manager policy. A maximum of 100
 * entries are displayed. If more than 100 resources are noncompliant, <code>EvaluationLimitExceeded</code> is set to
 * <code>True</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyComplianceDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyComplianceDetail.Builder, PolicyComplianceDetail> {
    private static final SdkField<String> POLICY_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyOwner").getter(getter(PolicyComplianceDetail::policyOwner)).setter(setter(Builder::policyOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyOwner").build()).build();

    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(PolicyComplianceDetail::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> MEMBER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberAccount").getter(getter(PolicyComplianceDetail::memberAccount))
            .setter(setter(Builder::memberAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccount").build()).build();

    private static final SdkField<List<ComplianceViolator>> VIOLATORS_FIELD = SdkField
            .<List<ComplianceViolator>> builder(MarshallingType.LIST)
            .memberName("Violators")
            .getter(getter(PolicyComplianceDetail::violators))
            .setter(setter(Builder::violators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Violators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceViolator> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceViolator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EVALUATION_LIMIT_EXCEEDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EvaluationLimitExceeded").getter(getter(PolicyComplianceDetail::evaluationLimitExceeded))
            .setter(setter(Builder::evaluationLimitExceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationLimitExceeded").build())
            .build();

    private static final SdkField<Instant> EXPIRED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiredAt").getter(getter(PolicyComplianceDetail::expiredAt)).setter(setter(Builder::expiredAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiredAt").build()).build();

    private static final SdkField<Map<String, String>> ISSUE_INFO_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("IssueInfoMap")
            .getter(getter(PolicyComplianceDetail::issueInfoMapAsStrings))
            .setter(setter(Builder::issueInfoMapWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueInfoMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_OWNER_FIELD,
            POLICY_ID_FIELD, MEMBER_ACCOUNT_FIELD, VIOLATORS_FIELD, EVALUATION_LIMIT_EXCEEDED_FIELD, EXPIRED_AT_FIELD,
            ISSUE_INFO_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyOwner;

    private final String policyId;

    private final String memberAccount;

    private final List<ComplianceViolator> violators;

    private final Boolean evaluationLimitExceeded;

    private final Instant expiredAt;

    private final Map<String, String> issueInfoMap;

    private PolicyComplianceDetail(BuilderImpl builder) {
        this.policyOwner = builder.policyOwner;
        this.policyId = builder.policyId;
        this.memberAccount = builder.memberAccount;
        this.violators = builder.violators;
        this.evaluationLimitExceeded = builder.evaluationLimitExceeded;
        this.expiredAt = builder.expiredAt;
        this.issueInfoMap = builder.issueInfoMap;
    }

    /**
     * <p>
     * The Amazon Web Services account that created the Firewall Manager policy.
     * </p>
     * 
     * @return The Amazon Web Services account that created the Firewall Manager policy.
     */
    public final String policyOwner() {
        return policyOwner;
    }

    /**
     * <p>
     * The ID of the Firewall Manager policy.
     * </p>
     * 
     * @return The ID of the Firewall Manager policy.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String memberAccount() {
        return memberAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Violators property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasViolators() {
        return violators != null && !(violators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance
     * with the security group policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolators} method.
     * </p>
     * 
     * @return An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in
     *         compliance with the security group policy.
     */
    public final List<ComplianceViolator> violators() {
        return violators;
    }

    /**
     * <p>
     * Indicates if over 100 resources are noncompliant with the Firewall Manager policy.
     * </p>
     * 
     * @return Indicates if over 100 resources are noncompliant with the Firewall Manager policy.
     */
    public final Boolean evaluationLimitExceeded() {
        return evaluationLimitExceeded;
    }

    /**
     * <p>
     * A timestamp that indicates when the returned information should be considered out of date.
     * </p>
     * 
     * @return A timestamp that indicates when the returned information should be considered out of date.
     */
    public final Instant expiredAt() {
        return expiredAt;
    }

    /**
     * <p>
     * Details about problems with dependent services, such as WAF or Config, and the error message received that
     * indicates the problem with the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssueInfoMap} method.
     * </p>
     * 
     * @return Details about problems with dependent services, such as WAF or Config, and the error message received
     *         that indicates the problem with the service.
     */
    public final Map<DependentServiceName, String> issueInfoMap() {
        return IssueInfoMapCopier.copyStringToEnum(issueInfoMap);
    }

    /**
     * For responses, this returns true if the service returned a value for the IssueInfoMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIssueInfoMap() {
        return issueInfoMap != null && !(issueInfoMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details about problems with dependent services, such as WAF or Config, and the error message received that
     * indicates the problem with the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssueInfoMap} method.
     * </p>
     * 
     * @return Details about problems with dependent services, such as WAF or Config, and the error message received
     *         that indicates the problem with the service.
     */
    public final Map<String, String> issueInfoMapAsStrings() {
        return issueInfoMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyOwner());
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(hasViolators() ? violators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluationLimitExceeded());
        hashCode = 31 * hashCode + Objects.hashCode(expiredAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasIssueInfoMap() ? issueInfoMapAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyComplianceDetail)) {
            return false;
        }
        PolicyComplianceDetail other = (PolicyComplianceDetail) obj;
        return Objects.equals(policyOwner(), other.policyOwner()) && Objects.equals(policyId(), other.policyId())
                && Objects.equals(memberAccount(), other.memberAccount()) && hasViolators() == other.hasViolators()
                && Objects.equals(violators(), other.violators())
                && Objects.equals(evaluationLimitExceeded(), other.evaluationLimitExceeded())
                && Objects.equals(expiredAt(), other.expiredAt()) && hasIssueInfoMap() == other.hasIssueInfoMap()
                && Objects.equals(issueInfoMapAsStrings(), other.issueInfoMapAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyComplianceDetail").add("PolicyOwner", policyOwner()).add("PolicyId", policyId())
                .add("MemberAccount", memberAccount()).add("Violators", hasViolators() ? violators() : null)
                .add("EvaluationLimitExceeded", evaluationLimitExceeded()).add("ExpiredAt", expiredAt())
                .add("IssueInfoMap", hasIssueInfoMap() ? issueInfoMapAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyOwner":
            return Optional.ofNullable(clazz.cast(policyOwner()));
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "MemberAccount":
            return Optional.ofNullable(clazz.cast(memberAccount()));
        case "Violators":
            return Optional.ofNullable(clazz.cast(violators()));
        case "EvaluationLimitExceeded":
            return Optional.ofNullable(clazz.cast(evaluationLimitExceeded()));
        case "ExpiredAt":
            return Optional.ofNullable(clazz.cast(expiredAt()));
        case "IssueInfoMap":
            return Optional.ofNullable(clazz.cast(issueInfoMapAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyComplianceDetail, T> g) {
        return obj -> g.apply((PolicyComplianceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyComplianceDetail> {
        /**
         * <p>
         * The Amazon Web Services account that created the Firewall Manager policy.
         * </p>
         * 
         * @param policyOwner
         *        The Amazon Web Services account that created the Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyOwner(String policyOwner);

        /**
         * <p>
         * The ID of the Firewall Manager policy.
         * </p>
         * 
         * @param policyId
         *        The ID of the Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param memberAccount
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccount(String memberAccount);

        /**
         * <p>
         * An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance
         * with the security group policy.
         * </p>
         * 
         * @param violators
         *        An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in
         *        compliance with the security group policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violators(Collection<ComplianceViolator> violators);

        /**
         * <p>
         * An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance
         * with the security group policy.
         * </p>
         * 
         * @param violators
         *        An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in
         *        compliance with the security group policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violators(ComplianceViolator... violators);

        /**
         * <p>
         * An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance
         * with the security group policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceViolator>.Builder} avoiding the
         * need to create one manually via {@link List<ComplianceViolator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceViolator>.Builder#build()} is called immediately
         * and its result is passed to {@link #violators(List<ComplianceViolator>)}.
         * 
         * @param violators
         *        a consumer that will call methods on {@link List<ComplianceViolator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violators(List<ComplianceViolator>)
         */
        Builder violators(Consumer<ComplianceViolator.Builder>... violators);

        /**
         * <p>
         * Indicates if over 100 resources are noncompliant with the Firewall Manager policy.
         * </p>
         * 
         * @param evaluationLimitExceeded
         *        Indicates if over 100 resources are noncompliant with the Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationLimitExceeded(Boolean evaluationLimitExceeded);

        /**
         * <p>
         * A timestamp that indicates when the returned information should be considered out of date.
         * </p>
         * 
         * @param expiredAt
         *        A timestamp that indicates when the returned information should be considered out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiredAt(Instant expiredAt);

        /**
         * <p>
         * Details about problems with dependent services, such as WAF or Config, and the error message received that
         * indicates the problem with the service.
         * </p>
         * 
         * @param issueInfoMap
         *        Details about problems with dependent services, such as WAF or Config, and the error message received
         *        that indicates the problem with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueInfoMapWithStrings(Map<String, String> issueInfoMap);

        /**
         * <p>
         * Details about problems with dependent services, such as WAF or Config, and the error message received that
         * indicates the problem with the service.
         * </p>
         * 
         * @param issueInfoMap
         *        Details about problems with dependent services, such as WAF or Config, and the error message received
         *        that indicates the problem with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueInfoMap(Map<DependentServiceName, String> issueInfoMap);
    }

    static final class BuilderImpl implements Builder {
        private String policyOwner;

        private String policyId;

        private String memberAccount;

        private List<ComplianceViolator> violators = DefaultSdkAutoConstructList.getInstance();

        private Boolean evaluationLimitExceeded;

        private Instant expiredAt;

        private Map<String, String> issueInfoMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyComplianceDetail model) {
            policyOwner(model.policyOwner);
            policyId(model.policyId);
            memberAccount(model.memberAccount);
            violators(model.violators);
            evaluationLimitExceeded(model.evaluationLimitExceeded);
            expiredAt(model.expiredAt);
            issueInfoMapWithStrings(model.issueInfoMap);
        }

        public final String getPolicyOwner() {
            return policyOwner;
        }

        public final void setPolicyOwner(String policyOwner) {
            this.policyOwner = policyOwner;
        }

        @Override
        @Transient
        public final Builder policyOwner(String policyOwner) {
            this.policyOwner = policyOwner;
            return this;
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        @Transient
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getMemberAccount() {
            return memberAccount;
        }

        public final void setMemberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
        }

        @Override
        @Transient
        public final Builder memberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
            return this;
        }

        public final List<ComplianceViolator.Builder> getViolators() {
            List<ComplianceViolator.Builder> result = ComplianceViolatorsCopier.copyToBuilder(this.violators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolators(Collection<ComplianceViolator.BuilderImpl> violators) {
            this.violators = ComplianceViolatorsCopier.copyFromBuilder(violators);
        }

        @Override
        @Transient
        public final Builder violators(Collection<ComplianceViolator> violators) {
            this.violators = ComplianceViolatorsCopier.copy(violators);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder violators(ComplianceViolator... violators) {
            violators(Arrays.asList(violators));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder violators(Consumer<ComplianceViolator.Builder>... violators) {
            violators(Stream.of(violators).map(c -> ComplianceViolator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEvaluationLimitExceeded() {
            return evaluationLimitExceeded;
        }

        public final void setEvaluationLimitExceeded(Boolean evaluationLimitExceeded) {
            this.evaluationLimitExceeded = evaluationLimitExceeded;
        }

        @Override
        @Transient
        public final Builder evaluationLimitExceeded(Boolean evaluationLimitExceeded) {
            this.evaluationLimitExceeded = evaluationLimitExceeded;
            return this;
        }

        public final Instant getExpiredAt() {
            return expiredAt;
        }

        public final void setExpiredAt(Instant expiredAt) {
            this.expiredAt = expiredAt;
        }

        @Override
        @Transient
        public final Builder expiredAt(Instant expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        public final Map<String, String> getIssueInfoMap() {
            if (issueInfoMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return issueInfoMap;
        }

        public final void setIssueInfoMap(Map<String, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copy(issueInfoMap);
        }

        @Override
        @Transient
        public final Builder issueInfoMapWithStrings(Map<String, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copy(issueInfoMap);
            return this;
        }

        @Override
        @Transient
        public final Builder issueInfoMap(Map<DependentServiceName, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copyEnumToString(issueInfoMap);
            return this;
        }

        @Override
        public PolicyComplianceDetail build() {
            return new PolicyComplianceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
