/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violations for a resource based on the specified AWS Firewall Manager policy and AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViolationDetail implements SdkPojo, Serializable, ToCopyableBuilder<ViolationDetail.Builder, ViolationDetail> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(ViolationDetail::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> MEMBER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberAccount").getter(getter(ViolationDetail::memberAccount)).setter(setter(Builder::memberAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccount").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ViolationDetail::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ViolationDetail::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<ResourceViolation>> RESOURCE_VIOLATIONS_FIELD = SdkField
            .<List<ResourceViolation>> builder(MarshallingType.LIST)
            .memberName("ResourceViolations")
            .getter(getter(ViolationDetail::resourceViolations))
            .setter(setter(Builder::resourceViolations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceViolations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceViolation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceViolation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(ViolationDetail::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceDescription").getter(getter(ViolationDetail::resourceDescription))
            .setter(setter(Builder::resourceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            MEMBER_ACCOUNT_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_VIOLATIONS_FIELD, RESOURCE_TAGS_FIELD,
            RESOURCE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final String memberAccount;

    private final String resourceId;

    private final String resourceType;

    private final List<ResourceViolation> resourceViolations;

    private final List<Tag> resourceTags;

    private final String resourceDescription;

    private ViolationDetail(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.memberAccount = builder.memberAccount;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceViolations = builder.resourceViolations;
        this.resourceTags = builder.resourceTags;
        this.resourceDescription = builder.resourceDescription;
    }

    /**
     * <p>
     * The ID of the AWS Firewall Manager policy that the violation details were requested for.
     * </p>
     * 
     * @return The ID of the AWS Firewall Manager policy that the violation details were requested for.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The AWS account that the violation details were requested for.
     * </p>
     * 
     * @return The AWS account that the violation details were requested for.
     */
    public final String memberAccount() {
        return memberAccount;
    }

    /**
     * <p>
     * The resource ID that the violation details were requested for.
     * </p>
     * 
     * @return The resource ID that the violation details were requested for.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The resource type that the violation details were requested for.
     * </p>
     * 
     * @return The resource type that the violation details were requested for.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * Returns true if the ResourceViolations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResourceViolations() {
        return resourceViolations != null && !(resourceViolations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of violations for the requested resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceViolations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of violations for the requested resource.
     */
    public final List<ResourceViolation> resourceViolations() {
        return resourceViolations;
    }

    /**
     * Returns true if the ResourceTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>ResourceTag</code> objects associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The <code>ResourceTag</code> objects associated with the resource.
     */
    public final List<Tag> resourceTags() {
        return resourceTags;
    }

    /**
     * <p>
     * Brief description for the requested resource.
     * </p>
     * 
     * @return Brief description for the requested resource.
     */
    public final String resourceDescription() {
        return resourceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceViolations() ? resourceViolations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViolationDetail)) {
            return false;
        }
        ViolationDetail other = (ViolationDetail) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(memberAccount(), other.memberAccount())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceType(), other.resourceType())
                && hasResourceViolations() == other.hasResourceViolations()
                && Objects.equals(resourceViolations(), other.resourceViolations())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && Objects.equals(resourceDescription(), other.resourceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViolationDetail").add("PolicyId", policyId()).add("MemberAccount", memberAccount())
                .add("ResourceId", resourceId()).add("ResourceType", resourceType())
                .add("ResourceViolations", hasResourceViolations() ? resourceViolations() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).add("ResourceDescription", resourceDescription())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "MemberAccount":
            return Optional.ofNullable(clazz.cast(memberAccount()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceViolations":
            return Optional.ofNullable(clazz.cast(resourceViolations()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "ResourceDescription":
            return Optional.ofNullable(clazz.cast(resourceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViolationDetail, T> g) {
        return obj -> g.apply((ViolationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViolationDetail> {
        /**
         * <p>
         * The ID of the AWS Firewall Manager policy that the violation details were requested for.
         * </p>
         * 
         * @param policyId
         *        The ID of the AWS Firewall Manager policy that the violation details were requested for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The AWS account that the violation details were requested for.
         * </p>
         * 
         * @param memberAccount
         *        The AWS account that the violation details were requested for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccount(String memberAccount);

        /**
         * <p>
         * The resource ID that the violation details were requested for.
         * </p>
         * 
         * @param resourceId
         *        The resource ID that the violation details were requested for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The resource type that the violation details were requested for.
         * </p>
         * 
         * @param resourceType
         *        The resource type that the violation details were requested for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * List of violations for the requested resource.
         * </p>
         * 
         * @param resourceViolations
         *        List of violations for the requested resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceViolations(Collection<ResourceViolation> resourceViolations);

        /**
         * <p>
         * List of violations for the requested resource.
         * </p>
         * 
         * @param resourceViolations
         *        List of violations for the requested resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceViolations(ResourceViolation... resourceViolations);

        /**
         * <p>
         * List of violations for the requested resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceViolation>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceViolation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceViolation>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceViolations(List<ResourceViolation>)}.
         * 
         * @param resourceViolations
         *        a consumer that will call methods on {@link List<ResourceViolation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceViolations(List<ResourceViolation>)
         */
        Builder resourceViolations(Consumer<ResourceViolation.Builder>... resourceViolations);

        /**
         * <p>
         * The <code>ResourceTag</code> objects associated with the resource.
         * </p>
         * 
         * @param resourceTags
         *        The <code>ResourceTag</code> objects associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<Tag> resourceTags);

        /**
         * <p>
         * The <code>ResourceTag</code> objects associated with the resource.
         * </p>
         * 
         * @param resourceTags
         *        The <code>ResourceTag</code> objects associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Tag... resourceTags);

        /**
         * <p>
         * The <code>ResourceTag</code> objects associated with the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #resourceTags(List<Tag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(List<Tag>)
         */
        Builder resourceTags(Consumer<Tag.Builder>... resourceTags);

        /**
         * <p>
         * Brief description for the requested resource.
         * </p>
         * 
         * @param resourceDescription
         *        Brief description for the requested resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDescription(String resourceDescription);
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private String memberAccount;

        private String resourceId;

        private String resourceType;

        private List<ResourceViolation> resourceViolations = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private String resourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ViolationDetail model) {
            policyId(model.policyId);
            memberAccount(model.memberAccount);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            resourceViolations(model.resourceViolations);
            resourceTags(model.resourceTags);
            resourceDescription(model.resourceDescription);
        }

        public final String getPolicyId() {
            return policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getMemberAccount() {
            return memberAccount;
        }

        @Override
        public final Builder memberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
            return this;
        }

        public final void setMemberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final List<ResourceViolation.Builder> getResourceViolations() {
            List<ResourceViolation.Builder> result = ResourceViolationsCopier.copyToBuilder(this.resourceViolations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resourceViolations(Collection<ResourceViolation> resourceViolations) {
            this.resourceViolations = ResourceViolationsCopier.copy(resourceViolations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceViolations(ResourceViolation... resourceViolations) {
            resourceViolations(Arrays.asList(resourceViolations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceViolations(Consumer<ResourceViolation.Builder>... resourceViolations) {
            resourceViolations(Stream.of(resourceViolations).map(c -> ResourceViolation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceViolations(Collection<ResourceViolation.BuilderImpl> resourceViolations) {
            this.resourceViolations = ResourceViolationsCopier.copyFromBuilder(resourceViolations);
        }

        public final List<Tag.Builder> getResourceTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resourceTags(Collection<Tag> resourceTags) {
            this.resourceTags = TagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Tag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<Tag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceTags(Collection<Tag.BuilderImpl> resourceTags) {
            this.resourceTags = TagListCopier.copyFromBuilder(resourceTags);
        }

        public final String getResourceDescription() {
            return resourceDescription;
        }

        @Override
        public final Builder resourceDescription(String resourceDescription) {
            this.resourceDescription = resourceDescription;
            return this;
        }

        public final void setResourceDescription(String resourceDescription) {
            this.resourceDescription = resourceDescription;
        }

        @Override
        public ViolationDetail build() {
            return new ViolationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
