/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.FmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProtocolsListRequest
extends FmsRequest
implements ToCopyableBuilder<Builder, GetProtocolsListRequest> {
    private static final SdkField<String> LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListId").getter(GetProtocolsListRequest.getter(GetProtocolsListRequest::listId)).setter(GetProtocolsListRequest.setter(Builder::listId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()}).build();
    private static final SdkField<Boolean> DEFAULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultList").getter(GetProtocolsListRequest.getter(GetProtocolsListRequest::defaultList)).setter(GetProtocolsListRequest.setter(Builder::defaultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ID_FIELD, DEFAULT_LIST_FIELD));
    private final String listId;
    private final Boolean defaultList;

    private GetProtocolsListRequest(BuilderImpl builder) {
        super(builder);
        this.listId = builder.listId;
        this.defaultList = builder.defaultList;
    }

    public final String listId() {
        return this.listId;
    }

    public final Boolean defaultList() {
        return this.defaultList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.listId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProtocolsListRequest)) {
            return false;
        }
        GetProtocolsListRequest other = (GetProtocolsListRequest)((Object)obj);
        return Objects.equals(this.listId(), other.listId()) && Objects.equals(this.defaultList(), other.defaultList());
    }

    public final String toString() {
        return ToString.builder((String)"GetProtocolsListRequest").add("ListId", (Object)this.listId()).add("DefaultList", (Object)this.defaultList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListId": {
                return Optional.ofNullable(clazz.cast(this.listId()));
            }
            case "DefaultList": {
                return Optional.ofNullable(clazz.cast(this.defaultList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProtocolsListRequest, T> g) {
        return obj -> g.apply((GetProtocolsListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsRequest.BuilderImpl
    implements Builder {
        private String listId;
        private Boolean defaultList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProtocolsListRequest model) {
            super(model);
            this.listId(model.listId);
            this.defaultList(model.defaultList);
        }

        public final String getListId() {
            return this.listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        public final Boolean getDefaultList() {
            return this.defaultList;
        }

        @Override
        public final Builder defaultList(Boolean defaultList) {
            this.defaultList = defaultList;
            return this;
        }

        public final void setDefaultList(Boolean defaultList) {
            this.defaultList = defaultList;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProtocolsListRequest build() {
            return new GetProtocolsListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProtocolsListRequest> {
        public Builder listId(String var1);

        public Builder defaultList(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

