/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateReportConfigurationDataSources;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateReportConfigurationOutputs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentTemplateReportConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentTemplateReportConfiguration> {
    private static final SdkField<ExperimentTemplateReportConfigurationOutputs> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputs").getter(ExperimentTemplateReportConfiguration.getter(ExperimentTemplateReportConfiguration::outputs)).setter(ExperimentTemplateReportConfiguration.setter(Builder::outputs)).constructor(ExperimentTemplateReportConfigurationOutputs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build()}).build();
    private static final SdkField<ExperimentTemplateReportConfigurationDataSources> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSources").getter(ExperimentTemplateReportConfiguration.getter(ExperimentTemplateReportConfiguration::dataSources)).setter(ExperimentTemplateReportConfiguration.setter(Builder::dataSources)).constructor(ExperimentTemplateReportConfigurationDataSources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final SdkField<String> PRE_EXPERIMENT_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preExperimentDuration").getter(ExperimentTemplateReportConfiguration.getter(ExperimentTemplateReportConfiguration::preExperimentDuration)).setter(ExperimentTemplateReportConfiguration.setter(Builder::preExperimentDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preExperimentDuration").build()}).build();
    private static final SdkField<String> POST_EXPERIMENT_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("postExperimentDuration").getter(ExperimentTemplateReportConfiguration.getter(ExperimentTemplateReportConfiguration::postExperimentDuration)).setter(ExperimentTemplateReportConfiguration.setter(Builder::postExperimentDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postExperimentDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUTS_FIELD, DATA_SOURCES_FIELD, PRE_EXPERIMENT_DURATION_FIELD, POST_EXPERIMENT_DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentTemplateReportConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ExperimentTemplateReportConfigurationOutputs outputs;
    private final ExperimentTemplateReportConfigurationDataSources dataSources;
    private final String preExperimentDuration;
    private final String postExperimentDuration;

    private ExperimentTemplateReportConfiguration(BuilderImpl builder) {
        this.outputs = builder.outputs;
        this.dataSources = builder.dataSources;
        this.preExperimentDuration = builder.preExperimentDuration;
        this.postExperimentDuration = builder.postExperimentDuration;
    }

    public final ExperimentTemplateReportConfigurationOutputs outputs() {
        return this.outputs;
    }

    public final ExperimentTemplateReportConfigurationDataSources dataSources() {
        return this.dataSources;
    }

    public final String preExperimentDuration() {
        return this.preExperimentDuration;
    }

    public final String postExperimentDuration() {
        return this.postExperimentDuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.preExperimentDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.postExperimentDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplateReportConfiguration)) {
            return false;
        }
        ExperimentTemplateReportConfiguration other = (ExperimentTemplateReportConfiguration)obj;
        return Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.dataSources(), other.dataSources()) && Objects.equals(this.preExperimentDuration(), other.preExperimentDuration()) && Objects.equals(this.postExperimentDuration(), other.postExperimentDuration());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentTemplateReportConfiguration").add("Outputs", (Object)this.outputs()).add("DataSources", (Object)this.dataSources()).add("PreExperimentDuration", (Object)this.preExperimentDuration()).add("PostExperimentDuration", (Object)this.postExperimentDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "dataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "preExperimentDuration": {
                return Optional.ofNullable(clazz.cast(this.preExperimentDuration()));
            }
            case "postExperimentDuration": {
                return Optional.ofNullable(clazz.cast(this.postExperimentDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("outputs", OUTPUTS_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("preExperimentDuration", PRE_EXPERIMENT_DURATION_FIELD);
        map.put("postExperimentDuration", POST_EXPERIMENT_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTemplateReportConfiguration, T> g) {
        return obj -> g.apply((ExperimentTemplateReportConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExperimentTemplateReportConfigurationOutputs outputs;
        private ExperimentTemplateReportConfigurationDataSources dataSources;
        private String preExperimentDuration;
        private String postExperimentDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTemplateReportConfiguration model) {
            this.outputs(model.outputs);
            this.dataSources(model.dataSources);
            this.preExperimentDuration(model.preExperimentDuration);
            this.postExperimentDuration(model.postExperimentDuration);
        }

        public final ExperimentTemplateReportConfigurationOutputs.Builder getOutputs() {
            return this.outputs != null ? this.outputs.toBuilder() : null;
        }

        public final void setOutputs(ExperimentTemplateReportConfigurationOutputs.BuilderImpl outputs) {
            this.outputs = outputs != null ? outputs.build() : null;
        }

        @Override
        public final Builder outputs(ExperimentTemplateReportConfigurationOutputs outputs) {
            this.outputs = outputs;
            return this;
        }

        public final ExperimentTemplateReportConfigurationDataSources.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        public final void setDataSources(ExperimentTemplateReportConfigurationDataSources.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public final Builder dataSources(ExperimentTemplateReportConfigurationDataSources dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final String getPreExperimentDuration() {
            return this.preExperimentDuration;
        }

        public final void setPreExperimentDuration(String preExperimentDuration) {
            this.preExperimentDuration = preExperimentDuration;
        }

        @Override
        public final Builder preExperimentDuration(String preExperimentDuration) {
            this.preExperimentDuration = preExperimentDuration;
            return this;
        }

        public final String getPostExperimentDuration() {
            return this.postExperimentDuration;
        }

        public final void setPostExperimentDuration(String postExperimentDuration) {
            this.postExperimentDuration = postExperimentDuration;
        }

        @Override
        public final Builder postExperimentDuration(String postExperimentDuration) {
            this.postExperimentDuration = postExperimentDuration;
            return this;
        }

        public ExperimentTemplateReportConfiguration build() {
            return new ExperimentTemplateReportConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentTemplateReportConfiguration> {
        public Builder outputs(ExperimentTemplateReportConfigurationOutputs var1);

        default public Builder outputs(Consumer<ExperimentTemplateReportConfigurationOutputs.Builder> outputs) {
            return this.outputs((ExperimentTemplateReportConfigurationOutputs)((ExperimentTemplateReportConfigurationOutputs.Builder)ExperimentTemplateReportConfigurationOutputs.builder().applyMutation(outputs)).build());
        }

        public Builder dataSources(ExperimentTemplateReportConfigurationDataSources var1);

        default public Builder dataSources(Consumer<ExperimentTemplateReportConfigurationDataSources.Builder> dataSources) {
            return this.dataSources((ExperimentTemplateReportConfigurationDataSources)((ExperimentTemplateReportConfigurationDataSources.Builder)ExperimentTemplateReportConfigurationDataSources.builder().applyMutation(dataSources)).build());
        }

        public Builder preExperimentDuration(String var1);

        public Builder postExperimentDuration(String var1);
    }
}

