/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisClient;
import software.amazon.awssdk.services.fis.internal.UserAgentUtils;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateSummary;
import software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse;

public class ListExperimentTemplatesIterable
implements SdkIterable<ListExperimentTemplatesResponse> {
    private final FisClient client;
    private final ListExperimentTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExperimentTemplatesIterable(FisClient client, ListExperimentTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExperimentTemplatesResponseFetcher();
    }

    public Iterator<ListExperimentTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExperimentTemplateSummary> experimentTemplates() {
        Function<ListExperimentTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.experimentTemplates() != null) {
                return response.experimentTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExperimentTemplatesResponseFetcher
    implements SyncPageFetcher<ListExperimentTemplatesResponse> {
        private ListExperimentTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListExperimentTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExperimentTemplatesResponse nextPage(ListExperimentTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListExperimentTemplatesIterable.this.client.listExperimentTemplates(ListExperimentTemplatesIterable.this.firstRequest);
            }
            return ListExperimentTemplatesIterable.this.client.listExperimentTemplates((ListExperimentTemplatesRequest)((Object)ListExperimentTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

