/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisAsyncClient;
import software.amazon.awssdk.services.fis.internal.UserAgentUtils;
import software.amazon.awssdk.services.fis.model.ListExperimentResolvedTargetsRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentResolvedTargetsResponse;
import software.amazon.awssdk.services.fis.model.ResolvedTarget;

public class ListExperimentResolvedTargetsPublisher
implements SdkPublisher<ListExperimentResolvedTargetsResponse> {
    private final FisAsyncClient client;
    private final ListExperimentResolvedTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExperimentResolvedTargetsPublisher(FisAsyncClient client, ListExperimentResolvedTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExperimentResolvedTargetsPublisher(FisAsyncClient client, ListExperimentResolvedTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExperimentResolvedTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExperimentResolvedTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResolvedTarget> resolvedTargets() {
        Function<ListExperimentResolvedTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolvedTargets() != null) {
                return response.resolvedTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExperimentResolvedTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExperimentResolvedTargetsResponseFetcher
    implements AsyncPageFetcher<ListExperimentResolvedTargetsResponse> {
        private ListExperimentResolvedTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListExperimentResolvedTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExperimentResolvedTargetsResponse> nextPage(ListExperimentResolvedTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListExperimentResolvedTargetsPublisher.this.client.listExperimentResolvedTargets(ListExperimentResolvedTargetsPublisher.this.firstRequest);
            }
            return ListExperimentResolvedTargetsPublisher.this.client.listExperimentResolvedTargets((ListExperimentResolvedTargetsRequest)((Object)ListExperimentResolvedTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

