/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.ExperimentOptions;
import software.amazon.awssdk.services.fis.model.ExperimentState;
import software.amazon.awssdk.services.fis.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ExperimentSummary.getter(ExperimentSummary::id)).setter(ExperimentSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ExperimentSummary.getter(ExperimentSummary::arn)).setter(ExperimentSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> EXPERIMENT_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experimentTemplateId").getter(ExperimentSummary.getter(ExperimentSummary::experimentTemplateId)).setter(ExperimentSummary.setter(Builder::experimentTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplateId").build()}).build();
    private static final SdkField<ExperimentState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(ExperimentSummary.getter(ExperimentSummary::state)).setter(ExperimentSummary.setter(Builder::state)).constructor(ExperimentState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ExperimentSummary.getter(ExperimentSummary::creationTime)).setter(ExperimentSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ExperimentSummary.getter(ExperimentSummary::tags)).setter(ExperimentSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ExperimentOptions> EXPERIMENT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("experimentOptions").getter(ExperimentSummary.getter(ExperimentSummary::experimentOptions)).setter(ExperimentSummary.setter(Builder::experimentOptions)).constructor(ExperimentOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, EXPERIMENT_TEMPLATE_ID_FIELD, STATE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD, EXPERIMENT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String experimentTemplateId;
    private final ExperimentState state;
    private final Instant creationTime;
    private final Map<String, String> tags;
    private final ExperimentOptions experimentOptions;

    private ExperimentSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.experimentTemplateId = builder.experimentTemplateId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
        this.experimentOptions = builder.experimentOptions;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String experimentTemplateId() {
        return this.experimentTemplateId;
    }

    public final ExperimentState state() {
        return this.state;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ExperimentOptions experimentOptions() {
        return this.experimentOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentSummary)) {
            return false;
        }
        ExperimentSummary other = (ExperimentSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.experimentTemplateId(), other.experimentTemplateId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.experimentOptions(), other.experimentOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ExperimentTemplateId", (Object)this.experimentTemplateId()).add("State", (Object)this.state()).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).add("ExperimentOptions", (Object)this.experimentOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "experimentTemplateId": {
                return Optional.ofNullable(clazz.cast(this.experimentTemplateId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "experimentOptions": {
                return Optional.ofNullable(clazz.cast(this.experimentOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("experimentTemplateId", EXPERIMENT_TEMPLATE_ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("experimentOptions", EXPERIMENT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentSummary, T> g) {
        return obj -> g.apply((ExperimentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String experimentTemplateId;
        private ExperimentState state;
        private Instant creationTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ExperimentOptions experimentOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.experimentTemplateId(model.experimentTemplateId);
            this.state(model.state);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
            this.experimentOptions(model.experimentOptions);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getExperimentTemplateId() {
            return this.experimentTemplateId;
        }

        public final void setExperimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
        }

        @Override
        public final Builder experimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        public final ExperimentState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(ExperimentState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ExperimentState state) {
            this.state = state;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ExperimentOptions.Builder getExperimentOptions() {
            return this.experimentOptions != null ? this.experimentOptions.toBuilder() : null;
        }

        public final void setExperimentOptions(ExperimentOptions.BuilderImpl experimentOptions) {
            this.experimentOptions = experimentOptions != null ? experimentOptions.build() : null;
        }

        @Override
        public final Builder experimentOptions(ExperimentOptions experimentOptions) {
            this.experimentOptions = experimentOptions;
            return this;
        }

        public ExperimentSummary build() {
            return new ExperimentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder experimentTemplateId(String var1);

        public Builder state(ExperimentState var1);

        default public Builder state(Consumer<ExperimentState.Builder> state) {
            return this.state((ExperimentState)((ExperimentState.Builder)ExperimentState.builder().applyMutation(state)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder experimentOptions(ExperimentOptions var1);

        default public Builder experimentOptions(Consumer<ExperimentOptions.Builder> experimentOptions) {
            return this.experimentOptions((ExperimentOptions)((ExperimentOptions.Builder)ExperimentOptions.builder().applyMutation(experimentOptions)).build());
        }
    }
}

