/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisClient;
import software.amazon.awssdk.services.fis.internal.UserAgentUtils;
import software.amazon.awssdk.services.fis.model.ExperimentSummary;
import software.amazon.awssdk.services.fis.model.ListExperimentsRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentsResponse;

public class ListExperimentsIterable
implements SdkIterable<ListExperimentsResponse> {
    private final FisClient client;
    private final ListExperimentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExperimentsIterable(FisClient client, ListExperimentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExperimentsResponseFetcher();
    }

    public Iterator<ListExperimentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExperimentSummary> experiments() {
        Function<ListExperimentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.experiments() != null) {
                return response.experiments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExperimentsResponseFetcher
    implements SyncPageFetcher<ListExperimentsResponse> {
        private ListExperimentsResponseFetcher() {
        }

        public boolean hasNextPage(ListExperimentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExperimentsResponse nextPage(ListExperimentsResponse previousPage) {
            if (previousPage == null) {
                return ListExperimentsIterable.this.client.listExperiments(ListExperimentsIterable.this.firstRequest);
            }
            return ListExperimentsIterable.this.client.listExperiments((ListExperimentsRequest)((Object)ListExperimentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

